/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TriggerControlDataTriggerEvent is the corresponding interface of TriggerControlDataTriggerEvent
type TriggerControlDataTriggerEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TriggerControlData
	// GetActionSelector returns ActionSelector (property field)
	GetActionSelector() byte
	// IsTriggerControlDataTriggerEvent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTriggerControlDataTriggerEvent()
	// CreateBuilder creates a TriggerControlDataTriggerEventBuilder
	CreateTriggerControlDataTriggerEventBuilder() TriggerControlDataTriggerEventBuilder
}

// _TriggerControlDataTriggerEvent is the data-structure of this message
type _TriggerControlDataTriggerEvent struct {
	TriggerControlDataContract
	ActionSelector byte
}

var _ TriggerControlDataTriggerEvent = (*_TriggerControlDataTriggerEvent)(nil)
var _ TriggerControlDataRequirements = (*_TriggerControlDataTriggerEvent)(nil)

// NewTriggerControlDataTriggerEvent factory function for _TriggerControlDataTriggerEvent
func NewTriggerControlDataTriggerEvent(commandTypeContainer TriggerControlCommandTypeContainer, triggerGroup byte, actionSelector byte) *_TriggerControlDataTriggerEvent {
	_result := &_TriggerControlDataTriggerEvent{
		TriggerControlDataContract: NewTriggerControlData(commandTypeContainer, triggerGroup),
		ActionSelector:             actionSelector,
	}
	_result.TriggerControlDataContract.(*_TriggerControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TriggerControlDataTriggerEventBuilder is a builder for TriggerControlDataTriggerEvent
type TriggerControlDataTriggerEventBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(actionSelector byte) TriggerControlDataTriggerEventBuilder
	// WithActionSelector adds ActionSelector (property field)
	WithActionSelector(byte) TriggerControlDataTriggerEventBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TriggerControlDataBuilder
	// Build builds the TriggerControlDataTriggerEvent or returns an error if something is wrong
	Build() (TriggerControlDataTriggerEvent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TriggerControlDataTriggerEvent
}

// NewTriggerControlDataTriggerEventBuilder() creates a TriggerControlDataTriggerEventBuilder
func NewTriggerControlDataTriggerEventBuilder() TriggerControlDataTriggerEventBuilder {
	return &_TriggerControlDataTriggerEventBuilder{_TriggerControlDataTriggerEvent: new(_TriggerControlDataTriggerEvent)}
}

type _TriggerControlDataTriggerEventBuilder struct {
	*_TriggerControlDataTriggerEvent

	parentBuilder *_TriggerControlDataBuilder

	collectedErr []error
}

var _ (TriggerControlDataTriggerEventBuilder) = (*_TriggerControlDataTriggerEventBuilder)(nil)

func (b *_TriggerControlDataTriggerEventBuilder) setParent(contract TriggerControlDataContract) {
	b.TriggerControlDataContract = contract
	contract.(*_TriggerControlData)._SubType = b._TriggerControlDataTriggerEvent
}

func (b *_TriggerControlDataTriggerEventBuilder) WithMandatoryFields(actionSelector byte) TriggerControlDataTriggerEventBuilder {
	return b.WithActionSelector(actionSelector)
}

func (b *_TriggerControlDataTriggerEventBuilder) WithActionSelector(actionSelector byte) TriggerControlDataTriggerEventBuilder {
	b.ActionSelector = actionSelector
	return b
}

func (b *_TriggerControlDataTriggerEventBuilder) Build() (TriggerControlDataTriggerEvent, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TriggerControlDataTriggerEvent.deepCopy(), nil
}

func (b *_TriggerControlDataTriggerEventBuilder) MustBuild() TriggerControlDataTriggerEvent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TriggerControlDataTriggerEventBuilder) Done() TriggerControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTriggerControlDataBuilder().(*_TriggerControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TriggerControlDataTriggerEventBuilder) buildForTriggerControlData() (TriggerControlData, error) {
	return b.Build()
}

func (b *_TriggerControlDataTriggerEventBuilder) DeepCopy() any {
	_copy := b.CreateTriggerControlDataTriggerEventBuilder().(*_TriggerControlDataTriggerEventBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTriggerControlDataTriggerEventBuilder creates a TriggerControlDataTriggerEventBuilder
func (b *_TriggerControlDataTriggerEvent) CreateTriggerControlDataTriggerEventBuilder() TriggerControlDataTriggerEventBuilder {
	if b == nil {
		return NewTriggerControlDataTriggerEventBuilder()
	}
	return &_TriggerControlDataTriggerEventBuilder{_TriggerControlDataTriggerEvent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TriggerControlDataTriggerEvent) GetParent() TriggerControlDataContract {
	return m.TriggerControlDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TriggerControlDataTriggerEvent) GetActionSelector() byte {
	return m.ActionSelector
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTriggerControlDataTriggerEvent(structType any) TriggerControlDataTriggerEvent {
	if casted, ok := structType.(TriggerControlDataTriggerEvent); ok {
		return casted
	}
	if casted, ok := structType.(*TriggerControlDataTriggerEvent); ok {
		return *casted
	}
	return nil
}

func (m *_TriggerControlDataTriggerEvent) GetTypeName() string {
	return "TriggerControlDataTriggerEvent"
}

func (m *_TriggerControlDataTriggerEvent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TriggerControlDataContract.(*_TriggerControlData).getLengthInBits(ctx))

	// Simple field (actionSelector)
	lengthInBits += 8

	return lengthInBits
}

func (m *_TriggerControlDataTriggerEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TriggerControlDataTriggerEvent) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TriggerControlData) (__triggerControlDataTriggerEvent TriggerControlDataTriggerEvent, err error) {
	m.TriggerControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TriggerControlDataTriggerEvent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TriggerControlDataTriggerEvent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	actionSelector, err := ReadSimpleField(ctx, "actionSelector", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionSelector' field"))
	}
	m.ActionSelector = actionSelector

	if closeErr := readBuffer.CloseContext("TriggerControlDataTriggerEvent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TriggerControlDataTriggerEvent")
	}

	return m, nil
}

func (m *_TriggerControlDataTriggerEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TriggerControlDataTriggerEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TriggerControlDataTriggerEvent"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TriggerControlDataTriggerEvent")
		}

		if err := WriteSimpleField[byte](ctx, "actionSelector", m.GetActionSelector(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'actionSelector' field")
		}

		if popErr := writeBuffer.PopContext("TriggerControlDataTriggerEvent"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TriggerControlDataTriggerEvent")
		}
		return nil
	}
	return m.TriggerControlDataContract.(*_TriggerControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TriggerControlDataTriggerEvent) IsTriggerControlDataTriggerEvent() {}

func (m *_TriggerControlDataTriggerEvent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TriggerControlDataTriggerEvent) deepCopy() *_TriggerControlDataTriggerEvent {
	if m == nil {
		return nil
	}
	_TriggerControlDataTriggerEventCopy := &_TriggerControlDataTriggerEvent{
		m.TriggerControlDataContract.(*_TriggerControlData).deepCopy(),
		m.ActionSelector,
	}
	_TriggerControlDataTriggerEventCopy.TriggerControlDataContract.(*_TriggerControlData)._SubType = m
	return _TriggerControlDataTriggerEventCopy
}

func (m *_TriggerControlDataTriggerEvent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
