/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataArmReadyNotReady is the corresponding interface of SecurityDataArmReadyNotReady
type SecurityDataArmReadyNotReady interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// GetZoneNumber returns ZoneNumber (property field)
	GetZoneNumber() uint8
	// IsSecurityDataArmReadyNotReady is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataArmReadyNotReady()
	// CreateBuilder creates a SecurityDataArmReadyNotReadyBuilder
	CreateSecurityDataArmReadyNotReadyBuilder() SecurityDataArmReadyNotReadyBuilder
}

// _SecurityDataArmReadyNotReady is the data-structure of this message
type _SecurityDataArmReadyNotReady struct {
	SecurityDataContract
	ZoneNumber uint8
}

var _ SecurityDataArmReadyNotReady = (*_SecurityDataArmReadyNotReady)(nil)
var _ SecurityDataRequirements = (*_SecurityDataArmReadyNotReady)(nil)

// NewSecurityDataArmReadyNotReady factory function for _SecurityDataArmReadyNotReady
func NewSecurityDataArmReadyNotReady(commandTypeContainer SecurityCommandTypeContainer, argument byte, zoneNumber uint8) *_SecurityDataArmReadyNotReady {
	_result := &_SecurityDataArmReadyNotReady{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
		ZoneNumber:           zoneNumber,
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataArmReadyNotReadyBuilder is a builder for SecurityDataArmReadyNotReady
type SecurityDataArmReadyNotReadyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneNumber uint8) SecurityDataArmReadyNotReadyBuilder
	// WithZoneNumber adds ZoneNumber (property field)
	WithZoneNumber(uint8) SecurityDataArmReadyNotReadyBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataArmReadyNotReady or returns an error if something is wrong
	Build() (SecurityDataArmReadyNotReady, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataArmReadyNotReady
}

// NewSecurityDataArmReadyNotReadyBuilder() creates a SecurityDataArmReadyNotReadyBuilder
func NewSecurityDataArmReadyNotReadyBuilder() SecurityDataArmReadyNotReadyBuilder {
	return &_SecurityDataArmReadyNotReadyBuilder{_SecurityDataArmReadyNotReady: new(_SecurityDataArmReadyNotReady)}
}

type _SecurityDataArmReadyNotReadyBuilder struct {
	*_SecurityDataArmReadyNotReady

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataArmReadyNotReadyBuilder) = (*_SecurityDataArmReadyNotReadyBuilder)(nil)

func (b *_SecurityDataArmReadyNotReadyBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataArmReadyNotReady
}

func (b *_SecurityDataArmReadyNotReadyBuilder) WithMandatoryFields(zoneNumber uint8) SecurityDataArmReadyNotReadyBuilder {
	return b.WithZoneNumber(zoneNumber)
}

func (b *_SecurityDataArmReadyNotReadyBuilder) WithZoneNumber(zoneNumber uint8) SecurityDataArmReadyNotReadyBuilder {
	b.ZoneNumber = zoneNumber
	return b
}

func (b *_SecurityDataArmReadyNotReadyBuilder) Build() (SecurityDataArmReadyNotReady, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataArmReadyNotReady.deepCopy(), nil
}

func (b *_SecurityDataArmReadyNotReadyBuilder) MustBuild() SecurityDataArmReadyNotReady {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataArmReadyNotReadyBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataArmReadyNotReadyBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataArmReadyNotReadyBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataArmReadyNotReadyBuilder().(*_SecurityDataArmReadyNotReadyBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataArmReadyNotReadyBuilder creates a SecurityDataArmReadyNotReadyBuilder
func (b *_SecurityDataArmReadyNotReady) CreateSecurityDataArmReadyNotReadyBuilder() SecurityDataArmReadyNotReadyBuilder {
	if b == nil {
		return NewSecurityDataArmReadyNotReadyBuilder()
	}
	return &_SecurityDataArmReadyNotReadyBuilder{_SecurityDataArmReadyNotReady: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataArmReadyNotReady) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SecurityDataArmReadyNotReady) GetZoneNumber() uint8 {
	return m.ZoneNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSecurityDataArmReadyNotReady(structType any) SecurityDataArmReadyNotReady {
	if casted, ok := structType.(SecurityDataArmReadyNotReady); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataArmReadyNotReady); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataArmReadyNotReady) GetTypeName() string {
	return "SecurityDataArmReadyNotReady"
}

func (m *_SecurityDataArmReadyNotReady) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	// Simple field (zoneNumber)
	lengthInBits += 8

	return lengthInBits
}

func (m *_SecurityDataArmReadyNotReady) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataArmReadyNotReady) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataArmReadyNotReady SecurityDataArmReadyNotReady, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataArmReadyNotReady"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataArmReadyNotReady")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneNumber, err := ReadSimpleField(ctx, "zoneNumber", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneNumber' field"))
	}
	m.ZoneNumber = zoneNumber

	if closeErr := readBuffer.CloseContext("SecurityDataArmReadyNotReady"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataArmReadyNotReady")
	}

	return m, nil
}

func (m *_SecurityDataArmReadyNotReady) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataArmReadyNotReady) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataArmReadyNotReady"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataArmReadyNotReady")
		}

		if err := WriteSimpleField[uint8](ctx, "zoneNumber", m.GetZoneNumber(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneNumber' field")
		}

		if popErr := writeBuffer.PopContext("SecurityDataArmReadyNotReady"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataArmReadyNotReady")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataArmReadyNotReady) IsSecurityDataArmReadyNotReady() {}

func (m *_SecurityDataArmReadyNotReady) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataArmReadyNotReady) deepCopy() *_SecurityDataArmReadyNotReady {
	if m == nil {
		return nil
	}
	_SecurityDataArmReadyNotReadyCopy := &_SecurityDataArmReadyNotReady{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
		m.ZoneNumber,
	}
	_SecurityDataArmReadyNotReadyCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataArmReadyNotReadyCopy
}

func (m *_SecurityDataArmReadyNotReady) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
