/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AccessControlDataAccessPointClosed is the corresponding interface of AccessControlDataAccessPointClosed
type AccessControlDataAccessPointClosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AccessControlData
	// IsAccessControlDataAccessPointClosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAccessControlDataAccessPointClosed()
	// CreateBuilder creates a AccessControlDataAccessPointClosedBuilder
	CreateAccessControlDataAccessPointClosedBuilder() AccessControlDataAccessPointClosedBuilder
}

// _AccessControlDataAccessPointClosed is the data-structure of this message
type _AccessControlDataAccessPointClosed struct {
	AccessControlDataContract
}

var _ AccessControlDataAccessPointClosed = (*_AccessControlDataAccessPointClosed)(nil)
var _ AccessControlDataRequirements = (*_AccessControlDataAccessPointClosed)(nil)

// NewAccessControlDataAccessPointClosed factory function for _AccessControlDataAccessPointClosed
func NewAccessControlDataAccessPointClosed(commandTypeContainer AccessControlCommandTypeContainer, networkId byte, accessPointId byte) *_AccessControlDataAccessPointClosed {
	_result := &_AccessControlDataAccessPointClosed{
		AccessControlDataContract: NewAccessControlData(commandTypeContainer, networkId, accessPointId),
	}
	_result.AccessControlDataContract.(*_AccessControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AccessControlDataAccessPointClosedBuilder is a builder for AccessControlDataAccessPointClosed
type AccessControlDataAccessPointClosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() AccessControlDataAccessPointClosedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AccessControlDataBuilder
	// Build builds the AccessControlDataAccessPointClosed or returns an error if something is wrong
	Build() (AccessControlDataAccessPointClosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AccessControlDataAccessPointClosed
}

// NewAccessControlDataAccessPointClosedBuilder() creates a AccessControlDataAccessPointClosedBuilder
func NewAccessControlDataAccessPointClosedBuilder() AccessControlDataAccessPointClosedBuilder {
	return &_AccessControlDataAccessPointClosedBuilder{_AccessControlDataAccessPointClosed: new(_AccessControlDataAccessPointClosed)}
}

type _AccessControlDataAccessPointClosedBuilder struct {
	*_AccessControlDataAccessPointClosed

	parentBuilder *_AccessControlDataBuilder

	collectedErr []error
}

var _ (AccessControlDataAccessPointClosedBuilder) = (*_AccessControlDataAccessPointClosedBuilder)(nil)

func (b *_AccessControlDataAccessPointClosedBuilder) setParent(contract AccessControlDataContract) {
	b.AccessControlDataContract = contract
	contract.(*_AccessControlData)._SubType = b._AccessControlDataAccessPointClosed
}

func (b *_AccessControlDataAccessPointClosedBuilder) WithMandatoryFields() AccessControlDataAccessPointClosedBuilder {
	return b
}

func (b *_AccessControlDataAccessPointClosedBuilder) Build() (AccessControlDataAccessPointClosed, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AccessControlDataAccessPointClosed.deepCopy(), nil
}

func (b *_AccessControlDataAccessPointClosedBuilder) MustBuild() AccessControlDataAccessPointClosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AccessControlDataAccessPointClosedBuilder) Done() AccessControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAccessControlDataBuilder().(*_AccessControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_AccessControlDataAccessPointClosedBuilder) buildForAccessControlData() (AccessControlData, error) {
	return b.Build()
}

func (b *_AccessControlDataAccessPointClosedBuilder) DeepCopy() any {
	_copy := b.CreateAccessControlDataAccessPointClosedBuilder().(*_AccessControlDataAccessPointClosedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAccessControlDataAccessPointClosedBuilder creates a AccessControlDataAccessPointClosedBuilder
func (b *_AccessControlDataAccessPointClosed) CreateAccessControlDataAccessPointClosedBuilder() AccessControlDataAccessPointClosedBuilder {
	if b == nil {
		return NewAccessControlDataAccessPointClosedBuilder()
	}
	return &_AccessControlDataAccessPointClosedBuilder{_AccessControlDataAccessPointClosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AccessControlDataAccessPointClosed) GetParent() AccessControlDataContract {
	return m.AccessControlDataContract
}

// Deprecated: use the interface for direct cast
func CastAccessControlDataAccessPointClosed(structType any) AccessControlDataAccessPointClosed {
	if casted, ok := structType.(AccessControlDataAccessPointClosed); ok {
		return casted
	}
	if casted, ok := structType.(*AccessControlDataAccessPointClosed); ok {
		return *casted
	}
	return nil
}

func (m *_AccessControlDataAccessPointClosed) GetTypeName() string {
	return "AccessControlDataAccessPointClosed"
}

func (m *_AccessControlDataAccessPointClosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AccessControlDataContract.(*_AccessControlData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_AccessControlDataAccessPointClosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AccessControlDataAccessPointClosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AccessControlData) (__accessControlDataAccessPointClosed AccessControlDataAccessPointClosed, err error) {
	m.AccessControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AccessControlDataAccessPointClosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AccessControlDataAccessPointClosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("AccessControlDataAccessPointClosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AccessControlDataAccessPointClosed")
	}

	return m, nil
}

func (m *_AccessControlDataAccessPointClosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AccessControlDataAccessPointClosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AccessControlDataAccessPointClosed"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AccessControlDataAccessPointClosed")
		}

		if popErr := writeBuffer.PopContext("AccessControlDataAccessPointClosed"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AccessControlDataAccessPointClosed")
		}
		return nil
	}
	return m.AccessControlDataContract.(*_AccessControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AccessControlDataAccessPointClosed) IsAccessControlDataAccessPointClosed() {}

func (m *_AccessControlDataAccessPointClosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AccessControlDataAccessPointClosed) deepCopy() *_AccessControlDataAccessPointClosed {
	if m == nil {
		return nil
	}
	_AccessControlDataAccessPointClosedCopy := &_AccessControlDataAccessPointClosed{
		m.AccessControlDataContract.(*_AccessControlData).deepCopy(),
	}
	_AccessControlDataAccessPointClosedCopy.AccessControlDataContract.(*_AccessControlData)._SubType = m
	return _AccessControlDataAccessPointClosedCopy
}

func (m *_AccessControlDataAccessPointClosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
