/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDatabaseRevision is the corresponding interface of BACnetConstructedDataDatabaseRevision
type BACnetConstructedDataDatabaseRevision interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDatabaseRevision returns DatabaseRevision (property field)
	GetDatabaseRevision() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataDatabaseRevision is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDatabaseRevision()
	// CreateBuilder creates a BACnetConstructedDataDatabaseRevisionBuilder
	CreateBACnetConstructedDataDatabaseRevisionBuilder() BACnetConstructedDataDatabaseRevisionBuilder
}

// _BACnetConstructedDataDatabaseRevision is the data-structure of this message
type _BACnetConstructedDataDatabaseRevision struct {
	BACnetConstructedDataContract
	DatabaseRevision BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataDatabaseRevision = (*_BACnetConstructedDataDatabaseRevision)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDatabaseRevision)(nil)

// NewBACnetConstructedDataDatabaseRevision factory function for _BACnetConstructedDataDatabaseRevision
func NewBACnetConstructedDataDatabaseRevision(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, databaseRevision BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDatabaseRevision {
	if databaseRevision == nil {
		panic("databaseRevision of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataDatabaseRevision must not be nil")
	}
	_result := &_BACnetConstructedDataDatabaseRevision{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DatabaseRevision:              databaseRevision,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDatabaseRevisionBuilder is a builder for BACnetConstructedDataDatabaseRevision
type BACnetConstructedDataDatabaseRevisionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(databaseRevision BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDatabaseRevisionBuilder
	// WithDatabaseRevision adds DatabaseRevision (property field)
	WithDatabaseRevision(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDatabaseRevisionBuilder
	// WithDatabaseRevisionBuilder adds DatabaseRevision (property field) which is build by the builder
	WithDatabaseRevisionBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDatabaseRevisionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDatabaseRevision or returns an error if something is wrong
	Build() (BACnetConstructedDataDatabaseRevision, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDatabaseRevision
}

// NewBACnetConstructedDataDatabaseRevisionBuilder() creates a BACnetConstructedDataDatabaseRevisionBuilder
func NewBACnetConstructedDataDatabaseRevisionBuilder() BACnetConstructedDataDatabaseRevisionBuilder {
	return &_BACnetConstructedDataDatabaseRevisionBuilder{_BACnetConstructedDataDatabaseRevision: new(_BACnetConstructedDataDatabaseRevision)}
}

type _BACnetConstructedDataDatabaseRevisionBuilder struct {
	*_BACnetConstructedDataDatabaseRevision

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDatabaseRevisionBuilder) = (*_BACnetConstructedDataDatabaseRevisionBuilder)(nil)

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDatabaseRevision
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) WithMandatoryFields(databaseRevision BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDatabaseRevisionBuilder {
	return b.WithDatabaseRevision(databaseRevision)
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) WithDatabaseRevision(databaseRevision BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDatabaseRevisionBuilder {
	b.DatabaseRevision = databaseRevision
	return b
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) WithDatabaseRevisionBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDatabaseRevisionBuilder {
	builder := builderSupplier(b.DatabaseRevision.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.DatabaseRevision, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) Build() (BACnetConstructedDataDatabaseRevision, error) {
	if b.DatabaseRevision == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'databaseRevision' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDatabaseRevision.deepCopy(), nil
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) MustBuild() BACnetConstructedDataDatabaseRevision {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDatabaseRevisionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDatabaseRevisionBuilder().(*_BACnetConstructedDataDatabaseRevisionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDatabaseRevisionBuilder creates a BACnetConstructedDataDatabaseRevisionBuilder
func (b *_BACnetConstructedDataDatabaseRevision) CreateBACnetConstructedDataDatabaseRevisionBuilder() BACnetConstructedDataDatabaseRevisionBuilder {
	if b == nil {
		return NewBACnetConstructedDataDatabaseRevisionBuilder()
	}
	return &_BACnetConstructedDataDatabaseRevisionBuilder{_BACnetConstructedDataDatabaseRevision: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDatabaseRevision) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDatabaseRevision) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DATABASE_REVISION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDatabaseRevision) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDatabaseRevision) GetDatabaseRevision() BACnetApplicationTagUnsignedInteger {
	return m.DatabaseRevision
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDatabaseRevision) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetDatabaseRevision())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDatabaseRevision(structType any) BACnetConstructedDataDatabaseRevision {
	if casted, ok := structType.(BACnetConstructedDataDatabaseRevision); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDatabaseRevision); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDatabaseRevision) GetTypeName() string {
	return "BACnetConstructedDataDatabaseRevision"
}

func (m *_BACnetConstructedDataDatabaseRevision) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (databaseRevision)
	lengthInBits += m.DatabaseRevision.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDatabaseRevision) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDatabaseRevision) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDatabaseRevision BACnetConstructedDataDatabaseRevision, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDatabaseRevision"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDatabaseRevision")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	databaseRevision, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "databaseRevision", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'databaseRevision' field"))
	}
	m.DatabaseRevision = databaseRevision

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), databaseRevision)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDatabaseRevision"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDatabaseRevision")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDatabaseRevision) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDatabaseRevision) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDatabaseRevision"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDatabaseRevision")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "databaseRevision", m.GetDatabaseRevision(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'databaseRevision' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDatabaseRevision"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDatabaseRevision")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDatabaseRevision) IsBACnetConstructedDataDatabaseRevision() {}

func (m *_BACnetConstructedDataDatabaseRevision) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDatabaseRevision) deepCopy() *_BACnetConstructedDataDatabaseRevision {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDatabaseRevisionCopy := &_BACnetConstructedDataDatabaseRevision{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.DatabaseRevision),
	}
	_BACnetConstructedDataDatabaseRevisionCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDatabaseRevisionCopy
}

func (m *_BACnetConstructedDataDatabaseRevision) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
