/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/evaluation_helper.h>
#include <plc4c/driver_s7_static.h>

#include "s7_payload_user_data_item.h"

// Code generated by code-generation. DO NOT EDIT.

// Array of discriminator values that match the enum type constants.
// (The order is identical to the enum constants, so we can use the
// enum constant to directly access a given type's discriminator values)
const plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_discriminators[] = {
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_push */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x00, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_push */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x00, .cpuSubfunction = 0x05, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_request */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x04, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_request */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x04, .cpuSubfunction = 0x04, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_response */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x08, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_response */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x08, .cpuSubfunction = 0x04, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_error_response */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x08, .cpuSubfunction = 0x05, .dataLength = 0x00 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response */
   .cpuFunctionGroup = 0x02, .cpuFunctionType = 0x08, .cpuSubfunction = 0x05, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_diagnostic_message */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x03, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_alarm8 */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x05, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_notify */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x06, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_alarm_ack_ind */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x0c, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_alarm_sq */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x11, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_alarm_s */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x12, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_alarm_sc */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x13, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_notify8 */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x00, .cpuSubfunction = 0x16, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_no_data_request */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x04, .cpuSubfunction = 0x01, .dataLength = 0x00 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x04, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_request */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x04, .cpuSubfunction = 0x02, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x00 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x02 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x02, .dataLength = 0x05 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_request */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x04, .cpuSubfunction = 0x0b, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_error_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x0b, .dataLength = 0x00 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x0b, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_request */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x04, .cpuSubfunction = 0x13, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response */
   .cpuFunctionGroup = 0x04, .cpuFunctionType = 0x08, .cpuSubfunction = 0x13, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_request */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x04, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_response */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x08, .cpuSubfunction = 0x01, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_f_request */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x04, .cpuSubfunction = 0x03, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_f_response */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x08, .cpuSubfunction = 0x03, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_set_request */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x04, .cpuSubfunction = 0x04, .dataLength = -1 },
  {/* plc4c_s7_read_write_s7_payload_user_data_item_clk_set_response */
   .cpuFunctionGroup = 0x07, .cpuFunctionType = 0x08, .cpuSubfunction = 0x04, .dataLength = -1 }

};

// Function returning the discriminator values for a given type constant.
plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_get_discriminator(plc4c_s7_read_write_s7_payload_user_data_item_type type) {
  return plc4c_s7_read_write_s7_payload_user_data_item_discriminators[type];
}

// Create an empty NULL-struct
static const plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item_null_const;

plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item_null() {
  return plc4c_s7_read_write_s7_payload_user_data_item_null_const;
}


// Constant values.
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID_const = 0x09;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID_const = 0x00;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ_const = 0x01;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC_const = 0x12;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC_const;
}
static const uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH_const = 0x08;
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH() {
  return PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, uint8_t cpuFunctionGroup, uint8_t cpuFunctionType, uint8_t cpuSubfunction, plc4c_s7_read_write_s7_payload_user_data_item** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_s7_payload_user_data_item));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Simple Field (returnCode)
  plc4c_s7_read_write_data_transport_error_code returnCode;
  _res = plc4c_s7_read_write_data_transport_error_code_parse(ctx, readBuffer, (void*) &returnCode);
  if(_res != OK) {
    return _res;
  }
  (*_message)->return_code = returnCode;

  // Simple Field (transportSize)
  plc4c_s7_read_write_data_transport_size transportSize;
  _res = plc4c_s7_read_write_data_transport_size_parse(ctx, readBuffer, (void*) &transportSize);
  if(_res != OK) {
    return _res;
  }
  (*_message)->transport_size = transportSize;

  // Simple Field (dataLength)
  uint16_t dataLength = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &dataLength);
  if(_res != OK) {
    return _res;
  }
  (*_message)->data_length = dataLength;

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemCyclicServicesPush */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_push;

  // Simple Field (itemsCount)
  uint16_t itemsCount = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &itemsCount);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_push_items_count = itemsCount;


  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) itemsCount;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_value_type* _value = NULL;
      _res = plc4c_s7_read_write_associated_value_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_push_items = items;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x05 ) ) { /* S7PayloadUserDataItemCyclicServicesChangeDrivenPush */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_push;

  // Simple Field (itemsCount)
  uint16_t itemsCount = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &itemsCount);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_change_driven_push_items_count = itemsCount;


  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) itemsCount;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_query_value_type* _value = NULL;
      _res = plc4c_s7_read_write_associated_query_value_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_change_driven_push_items = items;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemCyclicServicesSubscribeRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_request;

  // Simple Field (itemsCount)
  uint16_t itemsCount = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &itemsCount);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_request_items_count = itemsCount;


  // Simple Field (timeBase)
  plc4c_s7_read_write_time_base timeBase;
  _res = plc4c_s7_read_write_time_base_parse(ctx, readBuffer, (void*) &timeBase);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_request_time_base = timeBase;


  // Simple Field (timeFactor)
  uint8_t timeFactor = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &timeFactor);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_request_time_factor = timeFactor;


  // Array field (item)
  plc4c_list* item = NULL;
  plc4c_utils_list_create(&item);
  if(item == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) itemsCount;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_cyc_service_item_type* _value = NULL;
      _res = plc4c_s7_read_write_cyc_service_item_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(item, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_request_item = item;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x04 ) ) { /* S7PayloadUserDataItemCyclicServicesUnsubscribeRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_request;

  // Simple Field (function)
  uint8_t function = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &function);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_unsubscribe_request_function = function;


  // Simple Field (jobId)
  uint8_t jobId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &jobId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_unsubscribe_request_job_id = jobId;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemCyclicServicesSubscribeResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_response;

  // Simple Field (itemsCount)
  uint16_t itemsCount = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &itemsCount);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_response_items_count = itemsCount;


  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) itemsCount;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_value_type* _value = NULL;
      _res = plc4c_s7_read_write_associated_value_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_subscribe_response_items = items;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x04 ) ) { /* S7PayloadUserDataItemCyclicServicesUnsubscribeResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_response;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x05 ) && ( dataLength == 0x00 ) ) { /* S7PayloadUserDataItemCyclicServicesErrorResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_error_response;
  } else 
if( ( cpuFunctionGroup == 0x02 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x05 ) ) { /* S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response;

  // Simple Field (itemsCount)
  uint16_t itemsCount = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &itemsCount);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items_count = itemsCount;


  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) itemsCount;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_query_value_type* _value = NULL;
      _res = plc4c_s7_read_write_associated_query_value_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items = items;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x03 ) ) { /* S7PayloadDiagnosticMessage */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message;

  // Simple Field (eventId)
  uint16_t eventId = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &eventId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_event_id = eventId;


  // Simple Field (priorityClass)
  uint8_t priorityClass = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &priorityClass);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_priority_class = priorityClass;


  // Simple Field (obNumber)
  uint8_t obNumber = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &obNumber);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_ob_number = obNumber;


  // Simple Field (datId)
  uint16_t datId = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &datId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_dat_id = datId;


  // Simple Field (info1)
  uint16_t info1 = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &info1);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_info1 = info1;


  // Simple Field (info2)
  uint32_t info2 = 0;
  _res = plc4c_spi_read_unsigned_int(readBuffer, 32, (uint32_t*) &info2);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_info2 = info2;


  // Simple Field (timeStamp)
  plc4c_s7_read_write_date_and_time* timeStamp;
  _res = plc4c_s7_read_write_date_and_time_parse(ctx, readBuffer, (void*) &timeStamp);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_diagnostic_message_time_stamp = timeStamp;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x05 ) ) { /* S7PayloadAlarm8 */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_alarm8_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x06 ) ) { /* S7PayloadNotify */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_notify_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x0c ) ) { /* S7PayloadAlarmAckInd */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_ack_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_ack_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_alarm_ack_ind_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x11 ) ) { /* S7PayloadAlarmSQ */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_alarm_sq_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x12 ) ) { /* S7PayloadAlarmS */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_alarm_s_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x13 ) ) { /* S7PayloadAlarmSC */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_alarm_sc_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x00 ) && ( cpuSubfunction == 0x16 ) ) { /* S7PayloadNotify8 */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8;

  // Simple Field (alarmMessage)
  plc4c_s7_read_write_alarm_message_push_type* alarmMessage;
  _res = plc4c_s7_read_write_alarm_message_push_type_parse(ctx, readBuffer, (void*) &alarmMessage);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_notify8_alarm_message = alarmMessage;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x01 ) && ( dataLength == 0x00 ) ) { /* S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_no_data_request;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemCpuFunctionReadSzlRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request;

  // Simple Field (szlId)
  plc4c_s7_read_write_szl_id* szlId;
  _res = plc4c_s7_read_write_szl_id_parse(ctx, readBuffer, (void*) &szlId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id = szlId;


  // Simple Field (szlIndex)
  uint16_t szlIndex = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &szlIndex);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_read_szl_request_szl_index = szlIndex;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemCpuFunctionReadSzlResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response;

  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) dataLength;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      char* _value = malloc(sizeof(char));
      _res = plc4c_spi_read_char(readBuffer, (char*) _value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cpu_function_read_szl_response_items = items;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x02 ) ) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_request;

  // Simple Field (subscription)
  uint8_t subscription = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &subscription);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_subscription = subscription;


  // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
  {
    uint8_t _reserved = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
    if(_res != OK) {
      return _res;
    }
    if(_reserved != 0x00) {
      printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
    }
  }


  // Simple Field (magicKey)
  char* magicKey = "";
  _res = plc4c_spi_read_string(readBuffer, 64, "UTF-8", (char**) &magicKey);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_magic_key = magicKey;


  // Optional Field (alarmtype) (Can be skipped, if a given expression evaluates to false)
  plc4c_s7_read_write_alarm_state_type* alarmtype = NULL;
  if((subscription) >= (128)) {
    _res = plc4c_s7_read_write_alarm_state_type_parse(ctx, readBuffer, &alarmtype);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype = alarmtype;
  } else {
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype = NULL;
  }


  // Optional Field (reserve) (Can be skipped, if a given expression evaluates to false)
  uint8_t* reserve = NULL;
  if((subscription) >= (128)) {
    reserve = malloc(sizeof(uint8_t));
    if(reserve == NULL) {
      return NO_MEMORY;
    }
    *reserve = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) reserve);
    if(_res != OK) {
      return _res;
    }
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve = reserve;
  } else {
    (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve = NULL;
  }
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x02 ) && ( dataLength == 0x00 ) ) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x02 ) && ( dataLength == 0x02 ) ) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response;

  // Simple Field (result)
  uint8_t result = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &result);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_result = result;


  // Simple Field (reserved01)
  uint8_t reserved01 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved01);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_reserved01 = reserved01;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x02 ) && ( dataLength == 0x05 ) ) { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response;

  // Simple Field (result)
  uint8_t result = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &result);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_result = result;


  // Simple Field (reserved01)
  uint8_t reserved01 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved01);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved01 = reserved01;


  // Simple Field (alarmType)
  plc4c_s7_read_write_alarm_type alarmType;
  _res = plc4c_s7_read_write_alarm_type_parse(ctx, readBuffer, (void*) &alarmType);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type = alarmType;


  // Simple Field (reserved02)
  uint8_t reserved02 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved02);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved02 = reserved02;


  // Simple Field (reserved03)
  uint8_t reserved03 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &reserved03);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved03 = reserved03;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x0b ) ) { /* S7PayloadUserDataItemCpuFunctionAlarmAckRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_request;

  // Const Field (functionId)
  uint8_t functionId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
  if(_res != OK) {
    return _res;
  }
  if(functionId != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID + " but got " + functionId);
  }


  // Implicit Field (numberOfObjects) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
  uint8_t numberOfObjects = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfObjects);
  if(_res != OK) {
    return _res;
  }


  // Array field (messageObjects)
  plc4c_list* messageObjects = NULL;
  plc4c_utils_list_create(&messageObjects);
  if(messageObjects == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) numberOfObjects;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_alarm_message_object_ack_type* _value = NULL;
      _res = plc4c_s7_read_write_alarm_message_object_ack_type_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(messageObjects, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects = messageObjects;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x0b ) && ( dataLength == 0x00 ) ) { /* S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_error_response;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x0b ) ) { /* S7PayloadUserDataItemCpuFunctionAlarmAckResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response;

  // Simple Field (functionId)
  uint8_t functionId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_response_function_id = functionId;


  // Implicit Field (numberOfObjects) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
  uint8_t numberOfObjects = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfObjects);
  if(_res != OK) {
    return _res;
  }


  // Array field (messageObjects)
  plc4c_list* messageObjects = NULL;
  plc4c_utils_list_create(&messageObjects);
  if(messageObjects == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) numberOfObjects;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      uint8_t* _value = malloc(sizeof(uint8_t));
      _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) _value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(messageObjects, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects = messageObjects;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x13 ) ) { /* S7PayloadUserDataItemCpuFunctionAlarmQueryRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_request;

  // Const Field (functionId)
  uint8_t functionId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
  if(_res != OK) {
    return _res;
  }
  if(functionId != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID + " but got " + functionId);
  }


  // Const Field (numberMessageObj)
  uint8_t numberMessageObj = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberMessageObj);
  if(_res != OK) {
    return _res;
  }
  if(numberMessageObj != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ + " but got " + numberMessageObj);
  }


  // Const Field (variableSpec)
  uint8_t variableSpec = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &variableSpec);
  if(_res != OK) {
    return _res;
  }
  if(variableSpec != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC + " but got " + variableSpec);
  }


  // Const Field (length)
  uint8_t length = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &length);
  if(_res != OK) {
    return _res;
  }
  if(length != PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH + " but got " + length);
  }


  // Simple Field (syntaxId)
  plc4c_s7_read_write_syntax_id_type syntaxId;
  _res = plc4c_s7_read_write_syntax_id_type_parse(ctx, readBuffer, (void*) &syntaxId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_request_syntax_id = syntaxId;


  // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
  {
    uint8_t _reserved = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
    if(_res != OK) {
      return _res;
    }
    if(_reserved != 0x00) {
      printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
    }
  }


  // Simple Field (queryType)
  plc4c_s7_read_write_query_type queryType;
  _res = plc4c_s7_read_write_query_type_parse(ctx, readBuffer, (void*) &queryType);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_request_query_type = queryType;


  // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
  {
    uint8_t _reserved = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
    if(_res != OK) {
      return _res;
    }
    if(_reserved != 0x34) {
      printf("Expected constant value '%d' but got '%d' for reserved field.", 0x34, _reserved);
    }
  }


  // Simple Field (alarmType)
  plc4c_s7_read_write_alarm_type alarmType;
  _res = plc4c_s7_read_write_alarm_type_parse(ctx, readBuffer, (void*) &alarmType);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_request_alarm_type = alarmType;
  } else 
if( ( cpuFunctionGroup == 0x04 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x13 ) ) { /* S7PayloadUserDataItemCpuFunctionAlarmQueryResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response;

  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) dataLength;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      char* _value = malloc(sizeof(char));
      _res = plc4c_spi_read_char(readBuffer, (char*) _value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->s7_payload_user_data_item_cpu_function_alarm_query_response_items = items;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemClkRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_request;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x01 ) ) { /* S7PayloadUserDataItemClkResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_response;

  // Simple Field (res)
  uint8_t res = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &res);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_response_res = res;


  // Simple Field (year1)
  uint8_t year1 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &year1);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_response_year1 = year1;


  // Simple Field (timeStamp)
  plc4c_s7_read_write_date_and_time* timeStamp;
  _res = plc4c_s7_read_write_date_and_time_parse(ctx, readBuffer, (void*) &timeStamp);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_response_time_stamp = timeStamp;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x03 ) ) { /* S7PayloadUserDataItemClkFRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_request;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x03 ) ) { /* S7PayloadUserDataItemClkFResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_response;

  // Simple Field (res)
  uint8_t res = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &res);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_f_response_res = res;


  // Simple Field (year1)
  uint8_t year1 = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &year1);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_f_response_year1 = year1;


  // Simple Field (timeStamp)
  plc4c_s7_read_write_date_and_time* timeStamp;
  _res = plc4c_s7_read_write_date_and_time_parse(ctx, readBuffer, (void*) &timeStamp);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_f_response_time_stamp = timeStamp;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x04 ) && ( cpuSubfunction == 0x04 ) ) { /* S7PayloadUserDataItemClkSetRequest */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_request;

  // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
  {
    uint8_t _reserved = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
    if(_res != OK) {
      return _res;
    }
    if(_reserved != 0x00) {
      printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
    }
  }


  // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
  {
    uint8_t _reserved = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_reserved);
    if(_res != OK) {
      return _res;
    }
    if(_reserved != 0x00) {
      printf("Expected constant value '%d' but got '%d' for reserved field.", 0x00, _reserved);
    }
  }


  // Simple Field (timeStamp)
  plc4c_s7_read_write_date_and_time* timeStamp;
  _res = plc4c_s7_read_write_date_and_time_parse(ctx, readBuffer, (void*) &timeStamp);
  if(_res != OK) {
    return _res;
  }
  (*_message)->s7_payload_user_data_item_clk_set_request_time_stamp = timeStamp;
  } else 
if( ( cpuFunctionGroup == 0x07 ) && ( cpuFunctionType == 0x08 ) && ( cpuSubfunction == 0x04 ) ) { /* S7PayloadUserDataItemClkSetResponse */
    (*_message)->_type = plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_response;
  }

  return OK;
}

plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  plc4c_return_code _res = OK;

  // Simple Field (returnCode)
  _res = plc4c_s7_read_write_data_transport_error_code_serialize(ctx, writeBuffer, &_message->return_code);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (transportSize)
  _res = plc4c_s7_read_write_data_transport_size_serialize(ctx, writeBuffer, &_message->transport_size);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (dataLength)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->data_length);
  if(_res != OK) {
    return _res;
  }

  // Switch Field (Depending on the current type, serialize the subtype elements)
  switch(_message->_type) {
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_push: {

  // Simple Field (itemsCount)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cyclic_services_push_items_count);
  if(_res != OK) {
    return _res;
  }

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_push_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_value_type* _value = (plc4c_s7_read_write_associated_value_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_push_items, curItem);
      _res = plc4c_s7_read_write_associated_value_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_push: {

  // Simple Field (itemsCount)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cyclic_services_change_driven_push_items_count);
  if(_res != OK) {
    return _res;
  }

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_change_driven_push_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_query_value_type* _value = (plc4c_s7_read_write_associated_query_value_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_change_driven_push_items, curItem);
      _res = plc4c_s7_read_write_associated_query_value_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_request: {

  // Simple Field (itemsCount)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cyclic_services_subscribe_request_items_count);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeBase)
  _res = plc4c_s7_read_write_time_base_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cyclic_services_subscribe_request_time_base);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeFactor)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cyclic_services_subscribe_request_time_factor);
  if(_res != OK) {
    return _res;
  }

  // Array field (item)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_subscribe_request_item);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_cyc_service_item_type* _value = (plc4c_s7_read_write_cyc_service_item_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_subscribe_request_item, curItem);
      _res = plc4c_s7_read_write_cyc_service_item_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_request: {

  // Simple Field (function)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cyclic_services_unsubscribe_request_function);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (jobId)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cyclic_services_unsubscribe_request_job_id);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_response: {

  // Simple Field (itemsCount)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cyclic_services_subscribe_response_items_count);
  if(_res != OK) {
    return _res;
  }

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_subscribe_response_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_value_type* _value = (plc4c_s7_read_write_associated_value_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_subscribe_response_items, curItem);
      _res = plc4c_s7_read_write_associated_value_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_error_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response: {

  // Simple Field (itemsCount)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items_count);
  if(_res != OK) {
    return _res;
  }

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_associated_query_value_type* _value = (plc4c_s7_read_write_associated_query_value_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items, curItem);
      _res = plc4c_s7_read_write_associated_query_value_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message: {

  // Simple Field (eventId)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_event_id);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (priorityClass)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_diagnostic_message_priority_class);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (obNumber)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_diagnostic_message_ob_number);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (datId)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_dat_id);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (info1)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_diagnostic_message_info1);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (info2)
  _res = plc4c_spi_write_unsigned_int(writeBuffer, 32, _message->s7_payload_diagnostic_message_info2);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeStamp)
  _res = plc4c_s7_read_write_date_and_time_serialize(ctx, writeBuffer, _message->s7_payload_diagnostic_message_time_stamp);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_alarm8_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_notify_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_ack_push_type_serialize(ctx, writeBuffer, _message->s7_payload_alarm_ack_ind_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_alarm_sq_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_alarm_s_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_alarm_sc_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8: {

  // Simple Field (alarmMessage)
  _res = plc4c_s7_read_write_alarm_message_push_type_serialize(ctx, writeBuffer, _message->s7_payload_notify8_alarm_message);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_no_data_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request: {

  // Simple Field (szlId)
  _res = plc4c_s7_read_write_szl_id_serialize(ctx, writeBuffer, _message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (szlIndex)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_index);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response: {

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      char* _value = (char*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items, curItem);
      plc4c_spi_write_char(writeBuffer, *_value);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_request: {

  // Simple Field (subscription)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_request_subscription);
  if(_res != OK) {
    return _res;
  }

  // Reserved Field
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (magicKey)
  _res = plc4c_spi_write_string(writeBuffer, 64, "UTF-8", (char*) _message->s7_payload_user_data_item_cpu_function_msg_subscription_request_magic_key);
  if(_res != OK) {
    return _res;
  }

  // Optional Field (alarmtype)
  if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype != NULL) {
    _res = plc4c_s7_read_write_alarm_state_type_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype);
    if(_res != OK) {
      return _res;
    }
  }

  // Optional Field (reserve)
  if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve != NULL) {
    _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve);
    if(_res != OK) {
      return _res;
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response: {

  // Simple Field (result)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_result);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (reserved01)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_reserved01);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response: {

  // Simple Field (result)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_result);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (reserved01)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved01);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (alarmType)
  _res = plc4c_s7_read_write_alarm_type_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (reserved02)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved02);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (reserved03)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved03);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_request: {

  // Const Field (functionId)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID());

  // Implicit Field (numberOfObjects) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, plc4c_spi_evaluation_helper_count(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects));
  if(_res != OK) {
    return _res;
  }

  // Array field (messageObjects)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_alarm_message_object_ack_type* _value = (plc4c_s7_read_write_alarm_message_object_ack_type*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects, curItem);
      _res = plc4c_s7_read_write_alarm_message_object_ack_type_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_error_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response: {

  // Simple Field (functionId)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_cpu_function_alarm_ack_response_function_id);
  if(_res != OK) {
    return _res;
  }

  // Implicit Field (numberOfObjects) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, plc4c_spi_evaluation_helper_count(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects));
  if(_res != OK) {
    return _res;
  }

  // Array field (messageObjects)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      uint8_t* _value = (uint8_t*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects, curItem);
      plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_value);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_request: {

  // Const Field (functionId)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID());

  // Const Field (numberMessageObj)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ());

  // Const Field (variableSpec)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC());

  // Const Field (length)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH());

  // Simple Field (syntaxId)
  _res = plc4c_s7_read_write_syntax_id_type_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_syntax_id);
  if(_res != OK) {
    return _res;
  }

  // Reserved Field
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (queryType)
  _res = plc4c_s7_read_write_query_type_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_query_type);
  if(_res != OK) {
    return _res;
  }

  // Reserved Field
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x34);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (alarmType)
  _res = plc4c_s7_read_write_alarm_type_serialize(ctx, writeBuffer, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_alarm_type);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response: {

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_query_response_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      char* _value = (char*) plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_query_response_items, curItem);
      plc4c_spi_write_char(writeBuffer, *_value);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_response: {

  // Simple Field (res)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_clk_response_res);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (year1)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_clk_response_year1);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeStamp)
  _res = plc4c_s7_read_write_date_and_time_serialize(ctx, writeBuffer, _message->s7_payload_user_data_item_clk_response_time_stamp);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_response: {

  // Simple Field (res)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_clk_f_response_res);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (year1)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->s7_payload_user_data_item_clk_f_response_year1);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeStamp)
  _res = plc4c_s7_read_write_date_and_time_serialize(ctx, writeBuffer, _message->s7_payload_user_data_item_clk_f_response_time_stamp);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_request: {

  // Reserved Field
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
  if(_res != OK) {
    return _res;
  }

  // Reserved Field
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, 0x00);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (timeStamp)
  _res = plc4c_s7_read_write_date_and_time_serialize(ctx, writeBuffer, _message->s7_payload_user_data_item_clk_set_request_time_stamp);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_response: {

      break;
    }
  }

  return OK;
}

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  return plc4c_s7_read_write_s7_payload_user_data_item_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_s7_payload_user_data_item* _message) {
  uint16_t lengthInBits = 0;

  // Simple field (returnCode)
  lengthInBits += plc4c_s7_read_write_data_transport_error_code_length_in_bits(ctx, &_message->return_code);

  // Simple field (transportSize)
  lengthInBits += plc4c_s7_read_write_data_transport_size_length_in_bits(ctx, &_message->transport_size);

  // Simple field (dataLength)
  lengthInBits += 16;

  // Depending on the current type, add the length of sub-type elements ...
  switch(_message->_type) {
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_push: {

  // Simple field (itemsCount)
  lengthInBits += 16;


  // Array field
  if(_message->s7_payload_user_data_item_cyclic_services_push_items != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_push_items);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_push_items, curItem);
      lengthInBits += plc4c_s7_read_write_associated_value_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_associated_value_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_push: {

  // Simple field (itemsCount)
  lengthInBits += 16;


  // Array field
  if(_message->s7_payload_user_data_item_cyclic_services_change_driven_push_items != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_change_driven_push_items);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_change_driven_push_items, curItem);
      lengthInBits += plc4c_s7_read_write_associated_query_value_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_associated_query_value_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_request: {

  // Simple field (itemsCount)
  lengthInBits += 16;


  // Simple field (timeBase)
  lengthInBits += plc4c_s7_read_write_time_base_length_in_bits(ctx, &_message->s7_payload_user_data_item_cyclic_services_subscribe_request_time_base);


  // Simple field (timeFactor)
  lengthInBits += 8;


  // Array field
  if(_message->s7_payload_user_data_item_cyclic_services_subscribe_request_item != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_subscribe_request_item);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_subscribe_request_item, curItem);
      lengthInBits += plc4c_s7_read_write_cyc_service_item_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_cyc_service_item_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_request: {

  // Simple field (function)
  lengthInBits += 8;


  // Simple field (jobId)
  lengthInBits += 8;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_response: {

  // Simple field (itemsCount)
  lengthInBits += 16;


  // Array field
  if(_message->s7_payload_user_data_item_cyclic_services_subscribe_response_items != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_subscribe_response_items);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_subscribe_response_items, curItem);
      lengthInBits += plc4c_s7_read_write_associated_value_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_associated_value_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_error_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response: {

  // Simple field (itemsCount)
  lengthInBits += 16;


  // Array field
  if(_message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items, curItem);
      lengthInBits += plc4c_s7_read_write_associated_query_value_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_associated_query_value_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message: {

  // Simple field (eventId)
  lengthInBits += 16;


  // Simple field (priorityClass)
  lengthInBits += 8;


  // Simple field (obNumber)
  lengthInBits += 8;


  // Simple field (datId)
  lengthInBits += 16;


  // Simple field (info1)
  lengthInBits += 16;


  // Simple field (info2)
  lengthInBits += 32;


  // Simple field (timeStamp)
  lengthInBits += plc4c_s7_read_write_date_and_time_length_in_bits(ctx, _message->s7_payload_diagnostic_message_time_stamp);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_alarm8_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_notify_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_ack_push_type_length_in_bits(ctx, _message->s7_payload_alarm_ack_ind_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_alarm_sq_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_alarm_s_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_alarm_sc_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8: {

  // Simple field (alarmMessage)
  lengthInBits += plc4c_s7_read_write_alarm_message_push_type_length_in_bits(ctx, _message->s7_payload_notify8_alarm_message);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_no_data_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request: {

  // Simple field (szlId)
  lengthInBits += plc4c_s7_read_write_szl_id_length_in_bits(ctx, _message->s7_payload_user_data_item_cpu_function_read_szl_request_szl_id);


  // Simple field (szlIndex)
  lengthInBits += 16;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response: {

  // Array field
  lengthInBits += 8 * plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_read_szl_response_items);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_request: {

  // Simple field (subscription)
  lengthInBits += 8;


  // Reserved Field (reserved)
  lengthInBits += 8;


  // Simple field (magicKey)
  lengthInBits += 64;


  // Optional Field (alarmtype)
  if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype != NULL) {
    lengthInBits += plc4c_s7_read_write_alarm_state_type_length_in_bits(ctx, _message->s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype);
  }


  // Optional Field (reserve)
  if(_message->s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve != NULL) {
    lengthInBits += 8;
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response: {

  // Simple field (result)
  lengthInBits += 8;


  // Simple field (reserved01)
  lengthInBits += 8;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response: {

  // Simple field (result)
  lengthInBits += 8;


  // Simple field (reserved01)
  lengthInBits += 8;


  // Simple field (alarmType)
  lengthInBits += plc4c_s7_read_write_alarm_type_length_in_bits(ctx, &_message->s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type);


  // Simple field (reserved02)
  lengthInBits += 8;


  // Simple field (reserved03)
  lengthInBits += 8;

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_request: {

  // Const Field (functionId)
  lengthInBits += 8;


  // Implicit Field (numberOfObjects)
  lengthInBits += 8;


  // Array field
  if(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects, curItem);
      lengthInBits += plc4c_s7_read_write_alarm_message_object_ack_type_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_alarm_message_object_ack_type*) curElement);
    }
  }

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_error_response: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response: {

  // Simple field (functionId)
  lengthInBits += 8;


  // Implicit Field (numberOfObjects)
  lengthInBits += 8;


  // Array field
  lengthInBits += 8 * plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_request: {

  // Const Field (functionId)
  lengthInBits += 8;


  // Const Field (numberMessageObj)
  lengthInBits += 8;


  // Const Field (variableSpec)
  lengthInBits += 8;


  // Const Field (length)
  lengthInBits += 8;


  // Simple field (syntaxId)
  lengthInBits += plc4c_s7_read_write_syntax_id_type_length_in_bits(ctx, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_syntax_id);


  // Reserved Field (reserved)
  lengthInBits += 8;


  // Simple field (queryType)
  lengthInBits += plc4c_s7_read_write_query_type_length_in_bits(ctx, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_query_type);


  // Reserved Field (reserved)
  lengthInBits += 8;


  // Simple field (alarmType)
  lengthInBits += plc4c_s7_read_write_alarm_type_length_in_bits(ctx, &_message->s7_payload_user_data_item_cpu_function_alarm_query_request_alarm_type);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response: {

  // Array field
  lengthInBits += 8 * plc4c_utils_list_size(_message->s7_payload_user_data_item_cpu_function_alarm_query_response_items);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_response: {

  // Simple field (res)
  lengthInBits += 8;


  // Simple field (year1)
  lengthInBits += 8;


  // Simple field (timeStamp)
  lengthInBits += plc4c_s7_read_write_date_and_time_length_in_bits(ctx, _message->s7_payload_user_data_item_clk_response_time_stamp);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_request: {

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_f_response: {

  // Simple field (res)
  lengthInBits += 8;


  // Simple field (year1)
  lengthInBits += 8;


  // Simple field (timeStamp)
  lengthInBits += plc4c_s7_read_write_date_and_time_length_in_bits(ctx, _message->s7_payload_user_data_item_clk_f_response_time_stamp);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_request: {

  // Reserved Field (reserved)
  lengthInBits += 8;


  // Reserved Field (reserved)
  lengthInBits += 8;


  // Simple field (timeStamp)
  lengthInBits += plc4c_s7_read_write_date_and_time_length_in_bits(ctx, _message->s7_payload_user_data_item_clk_set_request_time_stamp);

      break;
    }
    case plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_clk_set_response: {

      break;
    }
  }

  return lengthInBits;
}

