/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidatorFactory;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public abstract class AnnotationValidator {
    protected AnnotationValidatorFactory annotFact = null;
    protected PreflightContext ctx = null;
    protected COSDocument cosDocument = null;
    protected COSDictionary annotDictionary = null;
    protected PDAnnotation pdAnnot = null;

    public AnnotationValidator(PreflightContext context, COSDictionary annotDictionary) {
        this.ctx = context;
        this.annotDictionary = annotDictionary;
        this.cosDocument = this.ctx.getDocument().getDocument();
    }

    protected boolean checkFlags() {
        boolean result = this.pdAnnot.isPrinted();
        result = result && !this.pdAnnot.isHidden();
        result = result && !this.pdAnnot.isInvisible();
        boolean bl = result = result && !this.pdAnnot.isNoView();
        if (!result) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.2", "Flags of " + this.pdAnnot.getSubtype() + " annotation are invalid"));
        }
        return result;
    }

    protected boolean checkCA() {
        float caf;
        COSBase ca = this.pdAnnot.getDictionary().getItem(COSName.CA);
        if (ca != null && (caf = COSUtils.getAsFloat(ca, this.cosDocument).floatValue()) != 1.0f) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.2", "CA entry is invalid. Expected 1.0 / Read " + caf));
            return false;
        }
        return true;
    }

    protected boolean checkColors() throws ValidationException {
        if (this.pdAnnot.getColour() != null && !this.searchRGBProfile()) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.3", "Annotation uses a Color profile which isn't the same than the profile contained by the OutputIntent"));
            return false;
        }
        return true;
    }

    protected boolean searchRGBProfile() throws ValidationException {
        ICCProfileWrapper iccpw = ICCProfileWrapper.getOrSearchICCProfile(this.ctx);
        if (iccpw != null) {
            return iccpw.isRGBColorSpace();
        }
        return false;
    }

    protected boolean checkAP() throws ValidationException {
        PDAppearanceDictionary ap = this.pdAnnot.getAppearance();
        if (ap != null) {
            COSDictionary apDict = ap.getDictionary();
            if (apDict.getItem(COSName.D) != null || apDict.getItem(COSName.R) != null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "Only the N Appearance is authorized"));
                return false;
            }
            if (apDict.getItem(COSName.N) == null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.1.2", "The N Appearance must be present"));
                return false;
            }
            COSBase apn = apDict.getItem(COSName.N);
            if (!COSUtils.isStream(apn, this.cosDocument)) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance must be a Stream"));
                return false;
            }
            ContextHelper.validateElement(this.ctx, new PDXObjectForm(COSUtils.getAsStream(apn, this.cosDocument)), "graphic-process");
        } else if (this.pdAnnot instanceof PDAnnotationWidget && this.pdAnnot.getAppearance() == null) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "widget annotation lacks an appearance dictionary"));
            return false;
        }
        return true;
    }

    protected boolean checkActions() throws ValidationException {
        ContextHelper.validateElement(this.ctx, this.annotDictionary, "actions-process");
        return true;
    }

    protected boolean checkPopup() throws ValidationException {
        COSBase cosPopup = this.annotDictionary.getItem("Popup");
        if (cosPopup != null) {
            COSDictionary popupDict = COSUtils.getAsDictionary(cosPopup, this.cosDocument);
            if (popupDict == null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "An Annotation has a Popup entry, but the value is missing or isn't a dictionary"));
                return false;
            }
            AnnotationValidator popupVal = this.annotFact.getAnnotationValidator(this.ctx, popupDict);
            return popupVal.validate();
        }
        return true;
    }

    public boolean validate() throws ValidationException {
        boolean isValide = this.checkMandatoryFields();
        isValide = isValide && this.checkFlags();
        isValide = isValide && this.checkColors();
        isValide = isValide && this.checkAP();
        isValide = isValide && this.checkCA();
        isValide = isValide && this.checkActions();
        isValide = isValide && this.checkPopup();
        return isValide;
    }

    protected abstract boolean checkMandatoryFields();

    public final void setFactory(AnnotationValidatorFactory fact) {
        this.annotFact = fact;
    }
}

