/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.javacc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.preflight.exception.BodyParseException;
import org.apache.pdfbox.preflight.exception.CrossRefParseException;
import org.apache.pdfbox.preflight.exception.HeaderParseException;
import org.apache.pdfbox.preflight.exception.PdfParseException;
import org.apache.pdfbox.preflight.exception.TrailerParseException;
import org.apache.pdfbox.preflight.javacc.PDFParserConstants;
import org.apache.pdfbox.preflight.javacc.PDFParserTokenManager;
import org.apache.pdfbox.preflight.javacc.ParseException;
import org.apache.pdfbox.preflight.javacc.SimpleCharStream;
import org.apache.pdfbox.preflight.javacc.Token;
import org.apache.pdfbox.preflight.javacc.TokenMgrError;

public class PDFParser
implements PDFParserConstants {
    public String pdfHeader = "";
    public PDFParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[37];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static boolean parse(InputStream is) throws IOException, ParseException {
        PDFParser parser = new PDFParser(is);
        parser.PDF();
        return true;
    }

    public static void main(String[] args) {
        PDFParser parser;
        String filename = null;
        long initTime = 0L;
        long parseTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        if (args.length == 0) {
            System.out.println("PDF Parser  . . .");
            parser = new PDFParser(System.in);
        } else if (args.length == 1) {
            filename = args[0];
            System.out.println("PDF Parser :  Reading from file " + filename + " . . .");
            try {
                startTime = System.currentTimeMillis();
                parser = new PDFParser(new FileInputStream(filename));
                stopTime = System.currentTimeMillis();
                initTime = stopTime - startTime;
            }
            catch (FileNotFoundException e) {
                System.out.println("PDF Parser :  File " + filename + " not found.");
                return;
            }
        } else {
            System.out.println("PDF Parser :  Usage is one of:");
            System.out.println("         java PDFParser < inputfile");
            System.out.println("OR");
            System.out.println("         java PDFParser inputfile");
            return;
        }
        try {
            startTime = System.currentTimeMillis();
            parser.PDF();
            stopTime = System.currentTimeMillis();
            parseTime = stopTime - startTime;
            System.out.println("PDF Parser ");
            System.out.print("   PDF Parser parsed " + filename + " successfully in " + (initTime + parseTime) + " ms.");
            System.out.println(" Init. : " + initTime + " ms / parse time : " + parseTime + " ms");
        }
        catch (ParseException e) {
            e.printStackTrace(System.out);
            System.out.println("PDF Parser :  Encountered errors during parse.");
        }
    }

    public final void indirect_object() throws ParseException {
        this.jj_consume_token(20);
        this.object_content();
        this.jj_consume_token(9);
    }

    /*
     * Unable to fully structure code
     */
    public final void object_content() throws ParseException {
        block54: {
            block48: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block54;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        continue block48;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        continue block48;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        continue block48;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        this.checkNumericLength();
                        break;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        this.checkStringHexLength();
                        break;
                    }
                    case 14: {
                        this.start_literal();
                        break;
                    }
                    case 15: {
                        this.array_of_object();
                        break;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        this.checkNameLength();
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block49: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block8;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block49;
                        }
                        case 2: {
                            this.jj_consume_token(2);
                            continue block49;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 38: {
                this.dictionary_object();
                block50: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            ** GOTO lbl105
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block50;
                        }
                        case 2: {
                            this.jj_consume_token(2);
                            continue block50;
                        }
                    }
                    break;
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl105:
                // 1 sources

                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: 
                    case 10: {
                        block51: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 3: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[7] = this.jj_gen;
                                    break block51;
                                }
                            }
                            this.jj_consume_token(3);
                        }
                        this.jj_consume_token(10);
                        this.jj_consume_token(31);
                        i = this.token.image.indexOf(PDFParser.tokenImage[31].substring(1, PDFParser.tokenImage[31].length() - 1));
                        if (this.token.image.charAt(i - 1) != '\n' && this.token.image.charAt(i - 1) != '\r') {
                            throw new PdfParseException("Expected EOL before \"endstream\"", "1.2.2");
                        }
                        block52: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: 
                                case 2: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[8] = this.jj_gen;
                                    break block8;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    this.jj_consume_token(1);
                                    continue block52;
                                }
                                case 2: {
                                    this.jj_consume_token(2);
                                    continue block52;
                                }
                            }
                            break;
                        }
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void array_of_object() throws ParseException {
        int counter;
        block19: {
            counter = 0;
            this.jj_consume_token(15);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 38: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block19;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        ++counter;
                        continue block17;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        ++counter;
                        this.checkNumericLength();
                        continue block17;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        ++counter;
                        this.checkStringHexLength();
                        continue block17;
                    }
                    case 15: {
                        this.array_of_object();
                        ++counter;
                        continue block17;
                    }
                    case 38: {
                        this.dictionary_object();
                        ++counter;
                        continue block17;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        ++counter;
                        this.checkNameLength();
                        continue block17;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        ++counter;
                        continue block17;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        ++counter;
                        continue block17;
                    }
                    case 14: {
                        this.start_literal();
                        ++counter;
                        continue block17;
                    }
                    case 1: {
                        this.jj_consume_token(1);
                        continue block17;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        continue block17;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        continue block17;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(16);
        if (counter > 8191) {
            throw new PdfParseException("Array too long : " + counter, "1.0.2");
        }
    }

    public final void start_literal() throws ParseException {
        this.jj_consume_token(14);
        this.literal();
    }

    void literal() throws ParseException {
        Token currentToken = null;
        int nesting = 1;
        int literalLength = 0;
        while (true) {
            Token previous = this.getToken(0);
            currentToken = this.getToken(1);
            if (currentToken.kind == 0) {
                throw new ParseException("EOF reach before the end of the literal string.");
            }
            literalLength += currentToken.image.getBytes().length;
            if (currentToken.kind == 14) {
                this.jj_consume_token(14);
                if (previous == null || previous.image.getBytes()[previous.image.getBytes().length - 1] == 92) continue;
                ++nesting;
                continue;
            }
            if (currentToken.kind == 29) {
                this.jj_consume_token(29);
                if (previous == null || previous.image.getBytes()[previous.image.getBytes().length - 1] == 92) continue;
                ++nesting;
                continue;
            }
            if (currentToken.kind == 28) {
                if (previous != null && previous.image.getBytes()[previous.image.getBytes().length - 1] != 92) {
                    --nesting;
                }
                this.jj_consume_token(28);
                if (nesting != 0) continue;
                break;
            }
            currentToken = this.getNextToken();
        }
        this.token_source.curLexState = 0;
        if (literalLength > 65535) {
            throw new PdfParseException("Literal String too long", "1.0.4");
        }
    }

    void checkNameLength() throws ParseException, ParseException {
        if (this.token != null && this.token.image.getBytes().length > 127) {
            throw new PdfParseException("Object Name is too long : " + this.token.image.getBytes().length, "1.0.3");
        }
    }

    void checkMagicNumberLength() throws ParseException, ParseException {
        if (this.token != null && this.token.image.getBytes().length < 4) {
            throw new PdfParseException("Not enough bytes after the Header (at least 4 bytes should be present with a value bigger than 127) : " + this.token.image, "1.1");
        }
    }

    void checkStringHexLength() throws ParseException, ParseException {
        if (this.token != null && (this.token.image.length() - 2) / 2 > 65535) {
            throw new PdfParseException("Object String Hexa is toot long", "1.0.5");
        }
    }

    void checkNumericLength() throws ParseException, ParseException {
        if (this.token != null) {
            String num = this.token.image;
            try {
                long numAsLong = Long.parseLong(num);
                if (numAsLong > Integer.MAX_VALUE || numAsLong < Integer.MIN_VALUE) {
                    throw new PdfParseException("Numeric is too long or too small: " + num, "1.0.6");
                }
            }
            catch (NumberFormatException e) {
                try {
                    Double real = Double.parseDouble(num);
                    if (real > 32767.0 || real < -32767.0) {
                        throw new PdfParseException("Float is too long or too small: " + num, "1.0.6");
                    }
                }
                catch (NumberFormatException e2) {
                    throw new PdfParseException("Numeric has invalid format " + num, "1.0.6");
                }
            }
        }
    }

    public final void dictionary_object() throws ParseException {
        int tokenNumber;
        block44: {
            block43: {
                tokenNumber = 0;
                this.jj_consume_token(38);
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block43;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block38;
                        }
                        case 2: {
                            this.jj_consume_token(2);
                            continue block38;
                        }
                        case 3: {
                            this.jj_consume_token(3);
                            continue block38;
                        }
                    }
                    break;
                }
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block39: while (true) {
                block45: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block44;
                        }
                    }
                    this.jj_consume_token(17);
                    ++tokenNumber;
                    this.checkNameLength();
                    block40: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: 
                            case 3: {
                                break;
                            }
                            default: {
                                this.jj_la1[17] = this.jj_gen;
                                break block45;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block40;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                continue block40;
                            }
                            case 3: {
                                this.jj_consume_token(3);
                                continue block40;
                            }
                        }
                        break;
                    }
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        this.checkNameLength();
                        break;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        this.checkNumericLength();
                        break;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        this.checkStringHexLength();
                        break;
                    }
                    case 14: {
                        this.start_literal();
                        break;
                    }
                    case 15: {
                        this.array_of_object();
                        break;
                    }
                    case 38: {
                        this.dictionary_object();
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                ++tokenNumber;
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            continue block39;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block41;
                        }
                        case 2: {
                            this.jj_consume_token(2);
                            continue block41;
                        }
                        case 3: {
                            this.jj_consume_token(3);
                            continue block41;
                        }
                    }
                    break;
                }
                break;
            }
            this.jj_la1[21] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(39);
        int entries = tokenNumber / 2;
        if (entries > 4095) {
            throw new PdfParseException("Too Many Entries In Dictionary : " + entries, "1.0.1");
        }
    }

    public final void PDF_header() throws ParseException, HeaderParseException {
        try {
            this.jj_consume_token(4);
            this.jj_consume_token(5);
            this.pdfHeader = this.token.image;
            this.jj_consume_token(3);
            this.jj_consume_token(4);
            this.jj_consume_token(6);
            this.checkMagicNumberLength();
            this.jj_consume_token(3);
        }
        catch (ParseException e) {
            throw new HeaderParseException(e);
        }
        catch (TokenMgrError e) {
            throw new HeaderParseException(e.getMessage());
        }
    }

    public final void PDF_body() throws ParseException, BodyParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: {
                    block26: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                break;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                break;
                            }
                            default: {
                                this.jj_la1[22] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: {
                                continue block26;
                            }
                        }
                        break;
                    }
                    this.jj_la1[23] = this.jj_gen;
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            block27: while (true) {
                block29: {
                    this.indirect_object();
                    block28: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: {
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break block29;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block28;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        continue block27;
                    }
                }
                break;
            }
            this.jj_la1[28] = this.jj_gen;
        }
        catch (ParseException e) {
            throw new BodyParseException(e);
        }
        catch (TokenMgrError e) {
            throw new BodyParseException(e.getMessage());
        }
    }

    public final void PDF_cross_ref_table() throws ParseException, CrossRefParseException {
        try {
            this.jj_consume_token(32);
            this.jj_consume_token(3);
            block15: while (true) {
                this.jj_consume_token(34);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(1);
                }
                this.jj_consume_token(3);
                block17: while (true) {
                    this.jj_consume_token(33);
                    block18: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                break block18;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    this.jj_consume_token(3);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[31] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[32] = this.jj_gen;
        }
        catch (ParseException e) {
            throw new CrossRefParseException(e);
        }
        catch (TokenMgrError e) {
            throw new CrossRefParseException(e.getMessage());
        }
    }

    public final void PDF_trailer_dictionnary() throws ParseException, TrailerParseException {
        try {
            this.jj_consume_token(37);
            this.jj_consume_token(3);
            this.dictionary_object();
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(1);
            }
            this.jj_consume_token(3);
        }
        catch (ParseException e) {
            throw new TrailerParseException(e);
        }
        catch (TokenMgrError e) {
            throw new TrailerParseException(e.getMessage());
        }
    }

    public final void PDF_Trailer_XRefOffset() throws ParseException, TrailerParseException {
        try {
            this.jj_consume_token(40);
            this.jj_consume_token(3);
            this.jj_consume_token(41);
            this.jj_consume_token(3);
            this.jj_consume_token(42);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException e) {
            throw new TrailerParseException(e);
        }
        catch (TokenMgrError e) {
            throw new TrailerParseException(e.getMessage());
        }
    }

    public final void PDF_linearized_modified() throws ParseException, PdfParseException {
        int foundXref = 0;
        int foundTrailer = 0;
        try {
            block10: while (true) {
                this.PDF_body();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        this.PDF_cross_ref_table();
                        ++foundXref;
                        this.PDF_trailer_dictionnary();
                        ++foundTrailer;
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                this.PDF_Trailer_XRefOffset();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 20: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(0);
            boolean expectedXRefAndTrailer = this.pdfHeader.matches("PDF-1\\.[1-4]");
            if (expectedXRefAndTrailer && (foundXref <= 0 || foundTrailer <= 0)) {
                throw new TrailerParseException("Missing Xref table or Trailer keyword in the given PDF.");
            }
        }
        catch (PdfParseException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new TrailerParseException(e);
        }
        catch (TokenMgrError e) {
            throw new TrailerParseException(e.getMessage());
        }
    }

    public final void PDF() throws ParseException, PdfParseException {
        this.PDF_header();
        this.PDF_linearized_modified();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{14, 14, 456704, 6, 6, 6, 6, 8, 6, 6, 1032, 456704, 981006, 981006, 14, 14, 131072, 14, 14, 980992, 14, 14, 6, 6, 6, 6, 6, 8, 0x100000, 2, 2, 0, 0, 2, 8, 0, 0x100006};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 0, 0, 1, 0};
    }

    public PDFParser(InputStream stream) {
        this(stream, null);
    }

    public PDFParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PDFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PDFParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PDFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PDFParser(PDFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(PDFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 37; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[43];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 37; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 43; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        PDFParser.jj_la1_init_0();
        PDFParser.jj_la1_init_1();
    }
}

