/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.EjbInterceptorBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.intercept.InterceptorComparator;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.PriorityClasses;

public class InterceptorsManager {
    private final WebBeansContext webBeansContext;
    private final BeanManagerImpl beanManager;
    private List<Class<?>> configuredInterceptorClasses = new CopyOnWriteArrayList();
    private List<Interceptor<?>> cdiInterceptors = new ArrayList();
    private ConcurrentMap<Class<?>, Interceptor<?>> ejbInterceptors = new ConcurrentHashMap();
    private List<Class<?>> additionalInterceptorClasses = new ArrayList();
    private Map<Class<? extends Annotation>, Set<Annotation>> additionalInterceptorBindingTypes = new HashMap<Class<? extends Annotation>, Set<Annotation>>();
    private final Collection<AnnotatedType<?>> additionalInterceptorBindingTypesAnnotatedTypes = new ArrayList();
    private final PriorityClasses priorityInterceptors = new PriorityClasses();

    public InterceptorsManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = webBeansContext.getBeanManagerImpl();
    }

    public void clear() {
        this.additionalInterceptorBindingTypes.clear();
        this.additionalInterceptorClasses.clear();
        this.configuredInterceptorClasses.clear();
        this.cdiInterceptors.clear();
        this.ejbInterceptors.clear();
        this.priorityInterceptors.clear();
    }

    public void addEnabledInterceptorClass(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        if (!this.configuredInterceptorClasses.contains(interceptorClazz)) {
            this.configuredInterceptorClasses.add(interceptorClazz);
        }
    }

    public <T> Interceptor<T> getEjbInterceptorForClass(Class<T> interceptorClass) {
        Object interceptor = (Interceptor<?>)this.ejbInterceptors.get(interceptorClass);
        if (interceptor == null) {
            AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(interceptorClass);
            if (annotatedType == null) {
                annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(interceptorClass);
            }
            BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
            EjbInterceptorBeanBuilder<T> buildr = new EjbInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, beanAttributes);
            buildr.defineEjbInterceptorRules();
            Object i = buildr.getBean();
            interceptor = this.ejbInterceptors.putIfAbsent(interceptorClass, (Interceptor<?>)i);
            if (interceptor == null) {
                interceptor = i;
            }
        }
        return interceptor;
    }

    public int compareCdiInterceptors(Class<?> src, Class<?> target) {
        int targetIndex;
        Asserts.assertNotNull(src, "src");
        Asserts.assertNotNull(target, "target");
        int p1 = this.priorityInterceptors.getSorted().indexOf(src);
        int p2 = this.priorityInterceptors.getSorted().indexOf(target);
        int srcIndex = p1;
        if (srcIndex == -1) {
            int i = this.configuredInterceptorClasses.indexOf(src);
            if (i == -1) {
                throw new IllegalArgumentException(src.getName() + " is not an enabled interceptor!");
            }
            srcIndex = this.priorityInterceptors.getSorted().size() + i;
        }
        if ((targetIndex = p2) == -1) {
            int i = this.configuredInterceptorClasses.indexOf(target);
            if (i == -1) {
                throw new IllegalArgumentException(target.getName() + " is not an enabled interceptor!");
            }
            targetIndex = this.priorityInterceptors.getSorted().size() + i;
        }
        if (p1 != -1 && p2 != -1) {
            return p1 - p2;
        }
        if (p1 == -1 && p2 != -1) {
            return -1;
        }
        if (p1 != -1) {
            return 1;
        }
        return srcIndex - targetIndex;
    }

    public boolean isInterceptorClassEnabled(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        return this.configuredInterceptorClasses.contains(interceptorClazz) || this.priorityInterceptors.contains(interceptorClazz);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        ArrayList interceptorList = new ArrayList();
        for (Interceptor<?> interceptor : this.cdiInterceptors) {
            if (!interceptor.intercepts(type) || !this.intercepts(interceptor, interceptorBindings) || !this.isInterceptorClassEnabled(interceptor.getBeanClass())) continue;
            interceptorList.add(interceptor);
        }
        Collections.sort(interceptorList, new InterceptorComparator(this.webBeansContext));
        return interceptorList;
    }

    private boolean intercepts(Interceptor<?> interceptor, Annotation[] requestedInterceptorBindings) {
        for (Annotation interceptorBinding : interceptor.getInterceptorBindings()) {
            boolean found = false;
            for (AnnotatedType<?> at : this.additionalInterceptorBindingTypesAnnotatedTypes) {
                if (!interceptorBinding.annotationType().equals(at.getJavaClass())) continue;
                found = true;
                if (this.inBindingArray(at, interceptorBinding, requestedInterceptorBindings)) continue;
                return false;
            }
            if (found || this.inBindingArray(interceptorBinding, requestedInterceptorBindings)) continue;
            return false;
        }
        return true;
    }

    private boolean inBindingArray(AnnotatedType<?> at, Annotation interceptorBinding, Annotation[] requestedInterceptorBindings) {
        for (Annotation requestedBinding : requestedInterceptorBindings) {
            if (!AnnotationUtil.isCdiAnnotationEqual(at, requestedBinding, interceptorBinding)) continue;
            return true;
        }
        return false;
    }

    private boolean inBindingArray(Annotation interceptorBinding, Annotation[] requestedInterceptorBindings) {
        for (Annotation requestedBinding : requestedInterceptorBindings) {
            if (!AnnotationUtil.isCdiAnnotationEqual(requestedBinding, interceptorBinding)) continue;
            return true;
        }
        return false;
    }

    public void addCdiInterceptor(Interceptor interceptor) {
        this.cdiInterceptors.add(interceptor);
        this.beanManager.addPassivationInfo((Bean<?>)interceptor);
    }

    public List<Interceptor<?>> getCdiInterceptors() {
        return this.cdiInterceptors;
    }

    public void addCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        this.additionalInterceptorClasses.add(clazz);
    }

    public boolean containsCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return this.additionalInterceptorClasses.contains(clazz);
    }

    public void addInterceptorBindingType(AnnotatedType<? extends Annotation> annotatedType) {
        this.additionalInterceptorBindingTypesAnnotatedTypes.add(annotatedType);
    }

    public void addInterceptorBindingType(Class<? extends Annotation> bindingType, Annotation ... inheritsArray) {
        Set<Annotation> inherits = this.additionalInterceptorBindingTypes.get(bindingType);
        if (inherits == null) {
            inherits = new HashSet<Annotation>();
            this.additionalInterceptorBindingTypes.put(bindingType, inherits);
        }
        Collections.addAll(inherits, inheritsArray);
    }

    public boolean hasInterceptorBindingType(Class<? extends Annotation> bindingType) {
        boolean contains = this.additionalInterceptorBindingTypes.keySet().contains(bindingType);
        if (contains) {
            return true;
        }
        for (AnnotatedType<?> at : this.additionalInterceptorBindingTypesAnnotatedTypes) {
            if (!bindingType.equals(at.getJavaClass())) continue;
            return true;
        }
        return false;
    }

    public void validateInterceptorClasses() {
        for (Class<?> interceptorClass : this.configuredInterceptorClasses) {
            AnnotatedType<?> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(interceptorClass);
            if (annotatedType.isAnnotationPresent(javax.interceptor.Interceptor.class) || this.containsCustomInterceptorClass(interceptorClass)) continue;
            throw new WebBeansDeploymentException("Given class : " + interceptorClass + " is not a interceptor class");
        }
    }

    public List<Class<?>> getPrioritizedInterceptors() {
        return this.priorityInterceptors.getSorted();
    }

    public void addPriorityClazzInterceptor(Class<?> javaClass, Priority priority) {
        this.priorityInterceptors.add(javaClass, priority);
    }
}

