/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;

public class TemporaryClassLoader
extends ClassLoader {
    public TemporaryClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("jdk.") || name.startsWith("jakarta.")) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        String resourceName = name.replace('.', '/') + ".class";
        InputStream resource = this.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        try {
            int n = 0;
            while ((n = resource.read(b, 0, b.length)) != -1) {
                bout.write(b, 0, n);
            }
            byte[] classBytes = bout.toByteArray();
            ClassReader cr = new ClassReader(classBytes);
            AccessScanner accessScanner = new AccessScanner(589824);
            cr.accept(accessScanner, 7);
            if (accessScanner.isAnnotation || accessScanner.isEnum) {
                try {
                    Class<?> frameworkClass = Class.forName(name, resolve, this.getClass().getClassLoader());
                    return frameworkClass;
                }
                catch (ClassNotFoundException frameworkClass) {
                    // empty catch block
                }
            }
            try {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            catch (SecurityException e) {
                return super.loadClass(name, resolve);
            }
        }
        catch (IOException ioe) {
            return super.loadClass(name, resolve);
        }
    }

    public class AccessScanner
    extends ClassVisitor {
        boolean isEnum;
        boolean isAnnotation;

        public AccessScanner(int api) {
            super(api);
            this.isEnum = false;
            this.isAnnotation = false;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isEnum = (access & 0x4000) > 0;
            this.isAnnotation = (access & 0x2000) > 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }
}

