/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.annotation.Annotation;
import java.util.function.IntPredicate;
import org.apache.bval.util.Validate;

public abstract class NumberSignValidator<A extends Annotation>
implements ConstraintValidator<A, Number> {
    private final IntPredicate comparisonTest;

    protected NumberSignValidator(IntPredicate comparisonTest) {
        this.comparisonTest = Validate.notNull(comparisonTest);
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        double d = value.doubleValue();
        if (Double.isNaN(d)) {
            return false;
        }
        return this.comparisonTest.test(Double.compare(d, 0.0));
    }

    public static class ForNegative
    extends NumberSignValidator<Negative> {
        public ForNegative() {
            super(n -> n < 0);
        }

        public static class OrZero
        extends NumberSignValidator<NegativeOrZero> {
            public OrZero() {
                super(n -> n <= 0);
            }
        }
    }

    public static class ForPositive
    extends NumberSignValidator<Positive> {
        public ForPositive() {
            super(n -> n > 0);
        }

        public static class OrZero
        extends NumberSignValidator<PositiveOrZero> {
            public OrZero() {
                super(n -> n >= 0);
            }
        }
    }
}

