/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.RelationId;
import org.apache.openjpa.jdbc.meta.ValueHandler;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InvalidStateException;

public class HandlerStrategies {
    private static final Localizer _loc = Localizer.forPackage(HandlerStrategies.class);

    public static Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        ValueMappingInfo vinfo = vm.getValueInfo();
        vinfo.assertNoJoin(vm, true);
        vinfo.assertNoForeignKey(vm, !adapt);
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        Column[] cols = vm.getHandler().map(vm, colName.getName(), io, adapt);
        if (cols.length > 0 && cols[0].getTable() == null) {
            cols = vinfo.getColumns(vm, colName, cols, vm.getFieldMapping().getTable(), adapt);
            if (vinfo.isImplicitRelation()) {
                for (Column col : cols) {
                    col.setImplicitRelation(true);
                }
            }
            ColumnIO mappedIO = vinfo.getColumnIO();
            vm.setColumns(cols);
            vm.setColumnIO(mappedIO);
            if (mappedIO != null) {
                for (int i = 0; i < cols.length; ++i) {
                    io.setInsertable(i, mappedIO.isInsertable(i, false));
                    io.setNullInsertable(i, mappedIO.isInsertable(i, true));
                    io.setUpdatable(i, mappedIO.isUpdatable(i, false));
                    io.setNullUpdatable(i, mappedIO.isUpdatable(i, true));
                }
            }
        }
        vm.mapConstraints(colName, adapt);
        return cols;
    }

    public static boolean set(ValueMapping vm, Object val, JDBCStore store, Row row, Column[] cols, ColumnIO io, boolean nullNone) throws SQLException {
        boolean isSet;
        block4: {
            ValueHandler handler;
            block5: {
                block3: {
                    if (!HandlerStrategies.canSetAny(row, io, cols)) {
                        return false;
                    }
                    handler = vm.getHandler();
                    val = handler.toDataStoreValue(vm, val, store);
                    isSet = false;
                    if (val != null) break block3;
                    for (int i = 0; i < cols.length; ++i) {
                        if (!HandlerStrategies.canSet(row, io, i, true)) continue;
                        isSet = true;
                        HandlerStrategies.set(row, cols[i], null, handler, nullNone);
                    }
                    break block4;
                }
                if (cols.length != 1) break block5;
                if (!HandlerStrategies.canSet(row, io, 0, val == null)) break block4;
                isSet = true;
                HandlerStrategies.set(row, cols[0], val, handler, nullNone);
                break block4;
            }
            Object[] vals = (Object[])val;
            for (int i = 0; i < vals.length; ++i) {
                if (!HandlerStrategies.canSet(row, io, i, vals[i] == null)) continue;
                isSet = true;
                HandlerStrategies.set(row, cols[i], vals[i], handler, nullNone);
            }
        }
        return isSet;
    }

    private static boolean canSet(Row row, ColumnIO io, int i, boolean nullValue) {
        if (row.getAction() == 1) {
            return io.isInsertable(i, nullValue);
        }
        if (row.getAction() == 0) {
            return io.isUpdatable(i, nullValue);
        }
        return true;
    }

    private static boolean canSetAny(Row row, ColumnIO io, Column[] cols) {
        if (row.getAction() == 1) {
            return io.isAnyInsertable(cols, false);
        }
        if (row.getAction() == 0) {
            return io.isAnyUpdatable(cols, false);
        }
        return true;
    }

    private static void set(Row row, Column col, Object val, ValueHandler handler, boolean nullNone) throws SQLException {
        if (val == null) {
            row.setNull(col, nullNone);
        } else if (col.isRelationId() && handler instanceof RelationId) {
            row.setRelationId(col, (OpenJPAStateManager)val, (RelationId)((Object)handler));
        } else {
            row.setObject(col, val);
        }
    }

    public static void where(ValueMapping vm, Object val, JDBCStore store, Row row, Column[] cols) throws SQLException {
        if (cols.length == 0) {
            return;
        }
        if ((val = HandlerStrategies.toDataStoreValue(vm, val, cols, store)) == null) {
            for (Column col : cols) {
                row.whereNull(col);
            }
        } else if (cols.length == 1) {
            HandlerStrategies.where(row, cols[0], val);
        } else {
            Object[] vals = (Object[])val;
            for (int i = 0; i < vals.length; ++i) {
                HandlerStrategies.where(row, cols[i], vals[i]);
            }
        }
    }

    private static void where(Row row, Column col, Object val) throws SQLException {
        if (val == null) {
            row.whereNull(col);
        } else {
            row.whereObject(col, val);
        }
    }

    public static Object loadObject(ValueMapping vm, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins, Column[] cols, boolean objectValueRequiresLoad) throws SQLException {
        if (cols.length == 0) {
            throw new InvalidStateException(_loc.get("cant-project-owned", vm));
        }
        Object val = HandlerStrategies.loadDataStore(vm, res, joins, cols);
        if (objectValueRequiresLoad) {
            return vm.getHandler().toObjectValue(vm, val, sm, store, fetch);
        }
        return vm.getHandler().toObjectValue(vm, val);
    }

    public static Object loadDataStore(ValueMapping vm, Result res, Joins joins, Column[] cols) throws SQLException {
        if (cols.length == 0) {
            return null;
        }
        if (cols.length == 1) {
            return res.getObject(cols[0], vm.getHandler().getResultArgument(vm), joins);
        }
        Object[] vals = new Object[cols.length];
        Object[] args = (Object[])vm.getHandler().getResultArgument(vm);
        for (int i = 0; i < cols.length; ++i) {
            vals[i] = res.getObject(cols[i], args == null ? null : args[i], joins);
        }
        return vals;
    }

    public static Object toDataStoreValue(ValueMapping vm, Object val, Column[] cols, JDBCStore store) {
        ValueHandler handler = vm.getHandler();
        val = handler.toDataStoreValue(vm, val, store);
        if (val == null) {
            if (cols.length > 1) {
                return new Object[cols.length];
            }
            return null;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isRelationId()) continue;
            if (!(handler instanceof RelationId)) break;
            if (cols.length == 1) {
                val = ((RelationId)((Object)handler)).toRelationDataStoreValue((OpenJPAStateManager)val, cols[i]);
                continue;
            }
            Object[] vals = (Object[])val;
            vals[i] = ((RelationId)((Object)handler)).toRelationDataStoreValue((OpenJPAStateManager)vals[i], cols[i]);
        }
        return val;
    }

    public static void assertJoinable(ValueMapping vm) {
        ClassMapping rel = vm.getTypeMapping();
        if (!(rel == null || rel.getTable() != null && rel.getTable().equals(vm.getFieldMapping().getTable()))) {
            throw RelationStrategies.unjoinable(vm);
        }
    }
}

