/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.bval.util.ObjectUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String capitalize(String str) {
        char newChar;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (firstChar == (newChar = Character.toTitleCase(firstChar))) {
            return str;
        }
        char[] newChars = new char[strLen];
        newChars[0] = newChar;
        str.getChars(1, strLen, newChars, 1);
        return String.valueOf(newChars);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> values, String joinToken) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "";
        }
        if (values.size() == 1) {
            return values.iterator().next().toString();
        }
        if (joinToken == null) {
            joinToken = "null";
        }
        StringBuilder sb = new StringBuilder(values.size() * (16 + joinToken.length()));
        Iterator<?> it = values.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(joinToken).append(it.next());
        }
        return sb.toString();
    }

    public static String joinArray(Object[] values, String joinToken) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return values[0].toString();
        }
        if (joinToken == null) {
            joinToken = "null";
        }
        StringBuilder sb = new StringBuilder(values.length * (16 + joinToken.length()));
        sb.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.append(joinToken).append(values[i]);
        }
        return sb.toString();
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null);
    }

    public static String[] split(String str, Character token) {
        if (str == null || str.length() == 0) {
            return ObjectUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(str.length());
        for (int pos = 0; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            if (token == null && Character.isWhitespace(c) || token != null && token.equals(Character.valueOf(c))) {
                if (sb.length() <= 0) continue;
                ret.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            ret.add(sb.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }
}

