/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.resolver;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.apache.bval.jsr303.resolver.CachingRelevant;
import org.apache.bval.jsr303.resolver.CachingTraversableResolver;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.util.PrivilegedActions;
import org.apache.commons.lang3.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private static final Logger log = Logger.getLogger(DefaultTraversableResolver.class.getName());
    private static final String PERSISTENCE_UTIL_CLASSNAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME = "org.apache.bval.jsr303.resolver.JPATraversableResolver";
    private TraversableResolver jpaTR;

    public DefaultTraversableResolver() {
        this.initJpa();
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void initJpa() {
        ClassLoader classLoader = DefaultTraversableResolver.getClassLoader();
        try {
            PrivilegedActions.getClass(classLoader, PERSISTENCE_UTIL_CLASSNAME);
            log.log(Level.FINEST, String.format("Found %s on classpath.", PERSISTENCE_UTIL_CLASSNAME));
        }
        catch (Exception e) {
            log.log(Level.FINEST, String.format("Cannot find %s on classpath. All properties will per default be traversable.", PERSISTENCE_UTIL_CLASSNAME));
            return;
        }
        try {
            Class<?> jpaAwareResolverClass = ClassUtils.getClass(classLoader, JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME, true);
            this.jpaTR = (TraversableResolver)jpaAwareResolverClass.newInstance();
            log.log(Level.FINEST, String.format("Instantiated an instance of %s.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME));
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Unable to load or instantiate JPA aware resolver %s. All properties will per default be traversable.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME, e));
        }
    }

    @Override
    public boolean needsCaching() {
        return this.jpaTR != null && CachingTraversableResolver.needsCaching(this.jpaTR);
    }

    private static ClassLoader getClassLoader() {
        return System.getSecurityManager() == null ? DefaultTraversableResolver.getClassLoader0() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return DefaultTraversableResolver.getClassLoader0();
            }
        });
    }

    private static ClassLoader getClassLoader0() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? loader : ClassHelper.class.getClassLoader();
    }
}

