/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.beans.Introspector;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.bval.util.AccessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAccess
extends AccessStrategy {
    private final Method method;
    private final String propertyName;

    public MethodAccess(Method method) {
        this(MethodAccess.getPropertyName(method), method);
    }

    public MethodAccess(String propertyName, final Method method) {
        this.method = method;
        this.propertyName = propertyName;
        if (!method.isAccessible()) {
            MethodAccess.run(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
    }

    public static String getPropertyName(Method member) {
        String name = null;
        String methodName = member.getName();
        if (methodName.startsWith("is")) {
            name = Introspector.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("get")) {
            name = Introspector.decapitalize(methodName.substring(3));
        }
        return name;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    @Override
    public Type getJavaType() {
        return this.method.getGenericReturnType();
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodAccess that = (MethodAccess)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    private static <T> T run(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

