/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.security.AccessController;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public enum JavaVendors {
    IBM("com.ibm.tools.attach.VirtualMachine"),
    SUN("com.sun.tools.attach.VirtualMachine"),
    OTHER("com.sun.tools.attach.VirtualMachine");

    private static final JavaVendors _vendor;
    private String _virtualMachineClass = null;

    private JavaVendors(String vmClass) {
        this._virtualMachineClass = vmClass;
    }

    public static JavaVendors getCurrentVendor() {
        return _vendor;
    }

    public boolean isIBM() {
        return _vendor == IBM;
    }

    public boolean isSun() {
        return _vendor == SUN;
    }

    public String getVirtualMachineClassName() {
        return this._virtualMachineClass;
    }

    static {
        String vendor = AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("java.vendor", "")).toUpperCase();
        _vendor = vendor.contains("SUN MICROSYSTEMS") ? SUN : (vendor.contains("IBM") ? IBM : OTHER);
    }
}

