/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmIsOf;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIsOf;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;

public class EdmIsOfImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmIsOf {
    private final Edm edm;
    private final CsdlIsOf isOf;
    private EdmExpression value;
    private EdmType type;

    public EdmIsOfImpl(Edm edm, CsdlIsOf isOf) {
        super(edm, "IsOf", (CsdlAnnotatable)isOf);
        this.edm = edm;
        this.isOf = isOf;
    }

    public Integer getMaxLength() {
        return this.isOf.getMaxLength();
    }

    public Integer getPrecision() {
        return this.isOf.getPrecision();
    }

    public Integer getScale() {
        return this.isOf.getScale();
    }

    public SRID getSrid() {
        return this.isOf.getSrid();
    }

    public EdmType getType() {
        if (this.type == null) {
            if (this.isOf.getType() == null) {
                throw new EdmException("Must specify a type for an IsOf expression.");
            }
            EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.isOf.getType()).build();
            this.type = typeInfo.getType();
        }
        return this.type;
    }

    public EdmExpression getValue() {
        if (this.value == null) {
            if (this.isOf.getValue() == null) {
                throw new EdmException("IsOf expressions require an expression value.");
            }
            this.value = EdmIsOfImpl.getExpression(this.edm, this.isOf.getValue());
        }
        return this.value;
    }

    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.IsOf;
    }
}

