/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlBindingTarget;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmNavigationPropertyBindingImpl;
import org.apache.olingo.commons.core.edm.Target;

public abstract class AbstractEdmBindingTarget
extends AbstractEdmNamed
implements EdmBindingTarget {
    private final CsdlBindingTarget target;
    private final EdmEntityContainer container;
    private List<EdmNavigationPropertyBinding> navigationPropertyBindings;

    public AbstractEdmBindingTarget(Edm edm, EdmEntityContainer container, CsdlBindingTarget target) {
        super(edm, target.getName(), (CsdlAnnotatable)target);
        this.container = container;
        this.target = target;
    }

    public List<EdmNavigationPropertyBinding> getNavigationPropertyBindings() {
        if (this.navigationPropertyBindings == null) {
            List providerBindings = this.target.getNavigationPropertyBindings();
            ArrayList<EdmNavigationPropertyBindingImpl> navigationPropertyBindingsLocal = new ArrayList<EdmNavigationPropertyBindingImpl>();
            if (providerBindings != null) {
                for (CsdlNavigationPropertyBinding binding : providerBindings) {
                    navigationPropertyBindingsLocal.add(new EdmNavigationPropertyBindingImpl(binding.getPath(), binding.getTarget()));
                }
                this.navigationPropertyBindings = Collections.unmodifiableList(navigationPropertyBindingsLocal);
            }
        }
        return this.navigationPropertyBindings;
    }

    public EdmEntityContainer getEntityContainer() {
        return this.container;
    }

    public EdmEntityType getEntityType() {
        EdmEntityType entityType = this.edm.getEntityType(this.target.getTypeFQN());
        if (entityType == null) {
            throw new EdmException("Can\u00b4t find entity type: " + this.target.getTypeFQN() + " for entity set or singleton: " + this.getName());
        }
        return entityType;
    }

    public EdmEntityType getEntityTypeWithAnnotations() {
        EdmEntityType entityType = ((AbstractEdm)this.edm).getEntityTypeWithAnnotations(this.target.getTypeFQN(), true);
        if (entityType == null) {
            throw new EdmException("Can\u00b4t find entity type: " + this.target.getTypeFQN() + " for entity set or singleton: " + this.getName());
        }
        return entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdmBindingTarget getRelatedBindingTarget(String path) {
        if (path == null) {
            return null;
        }
        EdmEntitySet bindingTarget = null;
        boolean found = false;
        Iterator<EdmNavigationPropertyBinding> itor = this.getNavigationPropertyBindings().iterator();
        while (itor.hasNext() && !found) {
            EdmNavigationPropertyBinding binding = itor.next();
            if (binding.getPath() == null || binding.getTarget() == null) {
                throw new EdmException("Path or Target in navigation property binding must not be null!");
            }
            if (!path.equals(binding.getPath())) continue;
            Target edmTarget = new Target(binding.getTarget(), this.container);
            EdmEntityContainer entityContainer = this.edm.getEntityContainer(edmTarget.getEntityContainer());
            if (entityContainer == null) {
                throw new EdmException("Cannot find entity container with name: " + edmTarget.getEntityContainer());
            }
            try {
                bindingTarget = entityContainer.getEntitySet(edmTarget.getTargetName());
                if (bindingTarget == null) {
                    throw new EdmException("Cannot find EntitySet " + edmTarget.getTargetName());
                }
                found = bindingTarget != null;
            }
            catch (EdmException e) {
                try {
                    bindingTarget = entityContainer.getSingleton(edmTarget.getTargetName());
                    if (bindingTarget == null) {
                        throw new EdmException("Cannot find Singleton " + edmTarget.getTargetName(), (Exception)((Object)e));
                    }
                    found = bindingTarget != null;
                }
                catch (Throwable throwable) {
                    found = bindingTarget != null;
                    throw throwable;
                }
            }
        }
        return bindingTarget;
    }

    public String getTitle() {
        return this.target.getTitle();
    }

    public EdmMapping getMapping() {
        return this.target.getMapping();
    }
}

