/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public final class FunctionMapKey {
    private final FullQualifiedName functionName;
    private final FullQualifiedName bindingParameterTypeName;
    private final Boolean isBindingParameterCollection;
    private final List<String> parameterNames;

    public FunctionMapKey(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        this.functionName = functionName;
        if (bindingParameterTypeName != null && isBindingParameterCollection == null) {
            throw new EdmException("Indicator that the bindingparameter is a collection must not be null if its an bound function.");
        }
        this.bindingParameterTypeName = bindingParameterTypeName;
        this.isBindingParameterCollection = isBindingParameterCollection;
        this.parameterNames = new ArrayList<String>();
        if (parameterNames != null) {
            this.parameterNames.addAll(parameterNames);
            Collections.sort(this.parameterNames);
        }
    }

    public int hashCode() {
        int result = this.functionName != null ? this.functionName.hashCode() : 0;
        result = 31 * result + (this.bindingParameterTypeName != null ? this.bindingParameterTypeName.hashCode() : 0);
        result = 31 * result + (this.isBindingParameterCollection != null ? this.isBindingParameterCollection.hashCode() : 0);
        result = 31 * result + this.parameterNames.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FunctionMapKey)) {
            return false;
        }
        FunctionMapKey other = (FunctionMapKey)obj;
        if (this.functionName.equals(other.functionName) && this.bindingParameterTypeName == null && other.bindingParameterTypeName == null || this.bindingParameterTypeName != null && this.bindingParameterTypeName.equals(other.bindingParameterTypeName) && this.isBindingParameterCollection == null && other.isBindingParameterCollection == null || this.isBindingParameterCollection != null && this.isBindingParameterCollection.equals(other.isBindingParameterCollection) && this.parameterNames.size() == other.parameterNames.size()) {
            for (String name : this.parameterNames) {
                if (other.parameterNames.contains(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

