/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;
import org.apache.olingo.server.core.debug.DebugTabBody;

public class DebugTabResponse
implements DebugTab {
    private final ODataResponse response;
    private final HttpStatusCode status;
    private final Map<String, List<String>> headers;

    public DebugTabResponse(ODataResponse applicationResponse) {
        this.response = applicationResponse;
        if (this.response != null) {
            this.status = HttpStatusCode.fromStatusCode((int)this.response.getStatusCode());
            this.headers = this.response.getAllHeaders();
        } else {
            this.status = HttpStatusCode.INTERNAL_SERVER_ERROR;
            this.headers = Collections.emptyMap();
        }
    }

    @Override
    public String getName() {
        return "Response";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        if (this.status != null) {
            gen.writeFieldName("status");
            gen.writeStartObject();
            gen.writeStringField("code", Integer.toString(this.status.getStatusCode()));
            gen.writeStringField("info", this.status.getInfo());
            gen.writeEndObject();
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            gen.writeFieldName("headers");
            DebugResponseHelperImpl.appendJsonTable(gen, this.map(this.headers));
        }
        gen.writeFieldName("body");
        if (this.response != null && this.response.getContent() != null) {
            new DebugTabBody(this.response).appendJson(gen);
        } else {
            gen.writeNull();
        }
        gen.writeEndObject();
    }

    private Map<String, String> map(Map<String, List<String>> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (entry.getValue().size() == 1) {
                result.put(entry.getKey(), entry.getValue().get(0));
                continue;
            }
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        writer.append("<h2>Status Code</h2>\n").append("<p>").append(Integer.toString(this.status.getStatusCode())).append(' ').append(this.status.getInfo()).append("</p>\n").append("<h2>Response Headers</h2>\n");
        DebugResponseHelperImpl.appendHtmlTable(writer, this.map(this.headers));
        writer.append("<h2>Response Body</h2>\n");
        if (this.response != null && this.response.getContent() != null) {
            new DebugTabBody(this.response).appendHtml(writer);
        } else {
            writer.append("<p>ODataLibrary: no response body</p>\n");
        }
    }
}

