/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.edm.xml.Edmx;
import org.apache.olingo.client.api.edm.xml.Reference;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmItem;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

public class ClientCsdlXMLMetadata
extends CsdlAbstractEdmItem
implements Serializable,
XMLMetadata {
    private static final long serialVersionUID = 6025723060298454901L;
    protected final Edmx edmx;
    private List<List<String>> schemaNameSpaces = null;

    public ClientCsdlXMLMetadata(Edmx edmx) {
        this.edmx = edmx;
    }

    public ClientCsdlXMLMetadata(Edmx edmx, List<List<String>> schemaNameSpaces) {
        this.edmx = edmx;
        this.schemaNameSpaces = schemaNameSpaces;
    }

    @Override
    public List<List<String>> getSchemaNamespaces() {
        return this.schemaNameSpaces;
    }

    @Override
    public List<CsdlSchema> getSchemas() {
        return this.edmx.getDataServices().getSchemas();
    }

    @Override
    public CsdlSchema getSchema(int index) {
        return this.getSchemas().get(index);
    }

    @Override
    public CsdlSchema getSchema(String key) {
        return this.getSchemaByNsOrAlias().get(key);
    }

    @Override
    public Map<String, CsdlSchema> getSchemaByNsOrAlias() {
        HashMap<String, CsdlSchema> schemaByNsOrAlias = new HashMap<String, CsdlSchema>();
        for (CsdlSchema schema : this.getSchemas()) {
            schemaByNsOrAlias.put(schema.getNamespace(), schema);
            if (!StringUtils.isNotBlank(schema.getAlias())) continue;
            schemaByNsOrAlias.put(schema.getAlias(), schema);
        }
        return schemaByNsOrAlias;
    }

    @Override
    public List<Reference> getReferences() {
        return this.edmx.getReferences();
    }

    @Override
    public String getEdmVersion() {
        return this.edmx.getVersion();
    }
}

