/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.aggregator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class EntityComplexPropertyInfo
extends EntityPropertyInfo {
    protected List<EntityPropertyInfo> entityPropertyInfo;

    EntityComplexPropertyInfo(String name, EdmType type, EdmFacets facets, EdmCustomizableFeedMappings customizableFeedMapping, List<EntityPropertyInfo> childEntityInfos) {
        super(name, type, facets, customizableFeedMapping, null, null);
        this.entityPropertyInfo = childEntityInfos;
    }

    static EntityComplexPropertyInfo create(EdmProperty property, List<String> propertyNames, Map<String, EntityPropertyInfo> childEntityInfos) throws EdmException {
        ArrayList<EntityPropertyInfo> childEntityInfoList = new ArrayList<EntityPropertyInfo>(childEntityInfos.size());
        for (String name : propertyNames) {
            childEntityInfoList.add(childEntityInfos.get(name));
        }
        EntityComplexPropertyInfo info = new EntityComplexPropertyInfo(property.getName(), property.getType(), property.getFacets(), property.getCustomizableFeedMappings(), childEntityInfoList);
        return info;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public List<EntityPropertyInfo> getPropertyInfos() {
        return Collections.unmodifiableList(this.entityPropertyInfo);
    }

    public EntityPropertyInfo getPropertyInfo(String name) {
        for (EntityPropertyInfo info : this.entityPropertyInfo) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (EntityPropertyInfo info : this.entityPropertyInfo) {
            if (sb.length() == 0) {
                sb.append(super.toString()).append("=>[").append(info.toString());
                continue;
            }
            sb.append(", ").append(info.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

