/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.commons;

import java.io.UnsupportedEncodingException;

public class Decoder {
    public static String decode(String value) throws IllegalArgumentException, NumberFormatException {
        if (value == null) {
            return value;
        }
        byte[] result = new byte[value.length()];
        int position = 0;
        int encodedPart = -2;
        for (char c : value.toCharArray()) {
            if (c <= '\u007f') {
                if (c == '%') {
                    if (encodedPart == -2) {
                        encodedPart = -1;
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                if (encodedPart == -1) {
                    encodedPart = (byte)c;
                    continue;
                }
                if (encodedPart >= 0) {
                    int i = Integer.parseInt(String.valueOf(new char[]{(char)encodedPart, c}), 16);
                    if (i < 0) {
                        throw new NumberFormatException();
                    }
                    result[position++] = (byte)i;
                    encodedPart = -2;
                    continue;
                }
                result[position++] = (byte)c;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (encodedPart >= 0) {
            throw new IllegalArgumentException();
        }
        try {
            return new String(result, 0, position, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

