/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.lang.reflect.AnnotatedElement;
import javax.persistence.Column;
import javax.persistence.metamodel.Attribute;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;

public class JPAEdmFacets {
    public static Facets createAndSet(Attribute<?, ?> jpaAttribute, SimpleProperty edmProperty) {
        EdmSimpleTypeKind edmTypeKind = edmProperty.getType();
        Facets facets = new Facets();
        edmProperty.setFacets((EdmFacets)facets);
        Column column = null;
        if (jpaAttribute.getJavaMember() instanceof AnnotatedElement) {
            column = ((AnnotatedElement)((Object)jpaAttribute.getJavaMember())).getAnnotation(Column.class);
        }
        if (column == null) {
            return facets;
        }
        JPAEdmFacets.setNullable(column, edmProperty);
        switch (edmTypeKind) {
            case Binary: {
                JPAEdmFacets.setMaxLength(column, edmProperty);
                break;
            }
            case DateTime: {
                JPAEdmFacets.setPrecision(column, edmProperty);
                break;
            }
            case DateTimeOffset: {
                JPAEdmFacets.setPrecision(column, edmProperty);
                break;
            }
            case Time: {
                JPAEdmFacets.setPrecision(column, edmProperty);
                break;
            }
            case Decimal: {
                JPAEdmFacets.setPrecision(column, edmProperty);
                JPAEdmFacets.setScale(column, edmProperty);
                break;
            }
            case String: {
                JPAEdmFacets.setMaxLength(column, edmProperty);
                break;
            }
        }
        return facets;
    }

    private static void setNullable(Column column, SimpleProperty edmProperty) {
        ((Facets)edmProperty.getFacets()).setNullable(Boolean.valueOf(column.nullable()));
    }

    private static void setMaxLength(Column column, SimpleProperty edmProperty) {
        if (column.length() > 0) {
            ((Facets)edmProperty.getFacets()).setMaxLength(Integer.valueOf(column.length()));
        }
    }

    private static void setPrecision(Column column, SimpleProperty edmProperty) {
        if (column.precision() > 0) {
            ((Facets)edmProperty.getFacets()).setPrecision(Integer.valueOf(column.precision()));
        }
    }

    private static void setScale(Column column, SimpleProperty edmProperty) {
        if (column.scale() > 0) {
            ((Facets)edmProperty.getFacets()).setScale(Integer.valueOf(column.scale()));
        }
    }
}

