/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;

public class EdmBoolean
extends AbstractSimpleType {
    private static final EdmBoolean instance = new EdmBoolean();

    public static EdmBoolean getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof EdmBoolean;
    }

    public Class<?> getDefaultType() {
        return Boolean.class;
    }

    @Override
    public boolean validate(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        return value == null ? facets == null || facets.isNullable() == null || facets.isNullable().booleanValue() : EdmBoolean.validateLiteral(value);
    }

    private static boolean validateLiteral(String value) {
        return "true".equals(value) || "1".equals(value) || "false".equals(value) || "0".equals(value);
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (EdmBoolean.validateLiteral(value)) {
            if (returnType.isAssignableFrom(Boolean.class)) {
                return returnType.cast("true".equals(value) || "1".equals(value));
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
    }
}

