/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.proprietaryStubs;

import java.util.List;
import java.util.Locale;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;
import org.flywaydb.core.internal.util.TelemetryUtils;

public class DeployCommandExtensionStub
implements CommandExtension {
    private static final String FEATURE_NAME = "Deploy";
    public static final String COMMAND = "Deploy".toLowerCase(Locale.ROOT);
    public static final String DESCRIPTION = "Executes a deployment script against a target database";

    @Override
    public boolean handlesCommand(String command) {
        return COMMAND.equals(command);
    }

    @Override
    public boolean handlesParameter(String parameter) {
        return false;
    }

    @Override
    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        return TelemetrySpan.trackSpan(new EventTelemetryModel(command, TelemetryUtils.getTelemetryManager(config)), telemetryModel -> {
            throw new FlywayRedgateEditionRequiredException(FEATURE_NAME);
        });
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

