/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleRunStatusEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRulesEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.NarDetailsEntity;
import org.apache.nifi.web.api.entity.NarSummariesEntity;
import org.apache.nifi.web.api.entity.NarSummaryEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportRequestEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportResponseEntity;

public class JerseyControllerClient
extends AbstractJerseyClient
implements ControllerClient {
    private static final String NAR_MANAGER_PATH = "nar-manager";
    private static final String NARS_PATH = "nar-manager/nars";
    private static final String NAR_UPLOAD_PATH = "nar-manager/nars/content";
    private final WebTarget controllerTarget;

    public JerseyControllerClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyControllerClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.controllerTarget = baseTarget.path("/controller");
    }

    @Override
    public FlowRegistryClientsEntity getRegistryClients() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving registry clients", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (FlowRegistryClientsEntity)this.getRequestBuilder(target).get(FlowRegistryClientsEntity.class);
        });
    }

    @Override
    public FlowRegistryClientEntity getRegistryClient(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Registry client id cannot be null");
        }
        WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)id);
        return (FlowRegistryClientEntity)this.getRequestBuilder(target).get(FlowRegistryClientEntity.class);
    }

    @Override
    public FlowRegistryClientEntity createRegistryClient(FlowRegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        return this.executeAction("Error creating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients");
            return (FlowRegistryClientEntity)this.getRequestBuilder(target).post(Entity.entity((Object)registryClient, (String)"application/json"), FlowRegistryClientEntity.class);
        });
    }

    @Override
    public FlowRegistryClientEntity updateRegistryClient(FlowRegistryClientEntity registryClient) throws NiFiClientException, IOException {
        if (registryClient == null) {
            throw new IllegalArgumentException("Registry client entity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)registryClient.getId())) {
            throw new IllegalArgumentException("Registry client entity must contain an id");
        }
        return this.executeAction("Error updating registry client", () -> {
            WebTarget target = this.controllerTarget.path("registry-clients/{id}").resolveTemplate("id", (Object)registryClient.getId());
            return (FlowRegistryClientEntity)this.getRequestBuilder(target).put(Entity.entity((Object)registryClient, (String)"application/json"), FlowRegistryClientEntity.class);
        });
    }

    @Override
    public NodeEntity deleteNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error deleting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).delete(NodeEntity.class);
        });
    }

    @Override
    public NodeEntity connectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error connecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity offloadNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error offloading node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity disconnectNode(String nodeId, NodeEntity nodeEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        if (nodeEntity == null) {
            throw new IllegalArgumentException("Node entity cannot be null");
        }
        return this.executeAction("Error disconnecting node", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).put(Entity.entity((Object)nodeEntity, (String)"application/json"), NodeEntity.class);
        });
    }

    @Override
    public NodeEntity getNode(String nodeId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster/nodes/" + nodeId);
            return (NodeEntity)this.getRequestBuilder(target).get(NodeEntity.class);
        });
    }

    @Override
    public ClusterEntity getNodes() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving node status", () -> {
            WebTarget target = this.controllerTarget.path("cluster");
            return (ClusterEntity)this.getRequestBuilder(target).get(ClusterEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(ControllerServiceEntity controllerService) throws NiFiClientException, IOException {
        if (controllerService == null) {
            throw new IllegalArgumentException("Controller service entity cannot be null");
        }
        return this.executeAction("Error creating controller service", () -> {
            WebTarget target = this.controllerTarget.path("controller-services");
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerService, (String)"application/json"), ControllerServiceEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity createReportingTask(ReportingTaskEntity reportingTask) throws NiFiClientException, IOException {
        if (reportingTask == null) {
            throw new IllegalArgumentException("Reporting task entity cannot be null");
        }
        return this.executeAction("Error creating reporting task", () -> {
            WebTarget target = this.controllerTarget.path("reporting-tasks");
            return (ReportingTaskEntity)this.getRequestBuilder(target).post(Entity.entity((Object)reportingTask, (String)"application/json"), ReportingTaskEntity.class);
        });
    }

    @Override
    public VersionedReportingTaskImportResponseEntity importReportingTasks(VersionedReportingTaskImportRequestEntity importRequestEntity) throws NiFiClientException, IOException {
        if (importRequestEntity == null) {
            throw new IllegalArgumentException("Import request entity cannot be null");
        }
        return this.executeAction("Error creating reporting task", () -> {
            WebTarget target = this.controllerTarget.path("reporting-tasks/import");
            return (VersionedReportingTaskImportResponseEntity)this.getRequestBuilder(target).post(Entity.entity((Object)importRequestEntity, (String)"application/json"), VersionedReportingTaskImportResponseEntity.class);
        });
    }

    @Override
    public FlowAnalysisRulesEntity getFlowAnalysisRules() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving flow analysis rules", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules");
            return (FlowAnalysisRulesEntity)this.getRequestBuilder(target).get(FlowAnalysisRulesEntity.class);
        });
    }

    @Override
    public FlowAnalysisRuleEntity getFlowAnalysisRule(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Flow analysis rule id cannot be null");
        }
        return this.executeAction("Error retrieving status of flow analysis rule", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}").resolveTemplate("id", (Object)id);
            return (FlowAnalysisRuleEntity)this.getRequestBuilder(target).get(FlowAnalysisRuleEntity.class);
        });
    }

    @Override
    public PropertyDescriptorEntity getFlowAnalysisRulePropertyDescriptor(String componentId, String propertyName, Boolean sensitive) throws NiFiClientException, IOException {
        Objects.requireNonNull(componentId, "Component ID required");
        Objects.requireNonNull(propertyName, "Property Name required");
        return this.executeAction("Error retrieving Flow Analysis Rule Property Descriptor", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}/descriptors").resolveTemplate("id", (Object)componentId).queryParam("propertyName", new Object[]{propertyName}).queryParam("sensitive", new Object[]{sensitive});
            return (PropertyDescriptorEntity)this.getRequestBuilder(target).get(PropertyDescriptorEntity.class);
        });
    }

    @Override
    public FlowAnalysisRuleEntity createFlowAnalysisRule(FlowAnalysisRuleEntity flowAnalysisRule) throws NiFiClientException, IOException {
        if (flowAnalysisRule == null) {
            throw new IllegalArgumentException("Flow analysis rule entity cannot be null");
        }
        return this.executeAction("Error creating flow analysis rule", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules");
            return (FlowAnalysisRuleEntity)this.getRequestBuilder(target).post(Entity.entity((Object)flowAnalysisRule, (String)"application/json"), FlowAnalysisRuleEntity.class);
        });
    }

    @Override
    public FlowAnalysisRuleEntity updateFlowAnalysisRule(FlowAnalysisRuleEntity flowAnalysisRuleEntity) throws NiFiClientException, IOException {
        if (flowAnalysisRuleEntity == null) {
            throw new IllegalArgumentException("Flow Analysis Rule cannot be null");
        }
        if (flowAnalysisRuleEntity.getComponent() == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        return this.executeAction("Error updating Flow Analysis Rule", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}").resolveTemplate("id", (Object)flowAnalysisRuleEntity.getId());
            return (FlowAnalysisRuleEntity)this.getRequestBuilder(target).put(Entity.entity((Object)flowAnalysisRuleEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), FlowAnalysisRuleEntity.class);
        });
    }

    @Override
    public FlowAnalysisRuleEntity activateFlowAnalysisRule(String id, FlowAnalysisRuleRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Flow analysis rule id cannot be null");
        }
        if (runStatusEntity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        return this.executeAction("Error enabling or disabling flow analysis rule", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}/run-status").resolveTemplate("id", (Object)id);
            return (FlowAnalysisRuleEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), FlowAnalysisRuleEntity.class);
        });
    }

    @Override
    public FlowAnalysisRuleEntity deleteFlowAnalysisRule(FlowAnalysisRuleEntity flowAnalysisRule) throws NiFiClientException, IOException {
        if (flowAnalysisRule == null) {
            throw new IllegalArgumentException("Flow Analysis Rule Entity cannot be null");
        }
        if (flowAnalysisRule.getId() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule ID cannot be null");
        }
        RevisionDTO revision = flowAnalysisRule.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Revision cannot be null");
        }
        return this.executeAction("Error deleting Flow Analysis Rule", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}").resolveTemplate("id", (Object)flowAnalysisRule.getId()).queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()});
            if (flowAnalysisRule.isDisconnectedNodeAcknowledged() == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (FlowAnalysisRuleEntity)this.getRequestBuilder(target).delete(FlowAnalysisRuleEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity submitFlowAnalysisRuleConfigVerificationRequest(VerifyConfigRequestEntity configRequestEntity) throws NiFiClientException, IOException {
        if (configRequestEntity == null) {
            throw new IllegalArgumentException("Config Request Entity cannot be null");
        }
        if (configRequestEntity.getRequest() == null) {
            throw new IllegalArgumentException("Config Request DTO cannot be null");
        }
        if (configRequestEntity.getRequest().getComponentId() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule ID cannot be null");
        }
        if (configRequestEntity.getRequest().getProperties() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule properties cannot be null");
        }
        return this.executeAction("Error submitting Flow Analysis Rule Config Verification Request", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}/config/verification-requests").resolveTemplate("id", (Object)configRequestEntity.getRequest().getComponentId());
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)configRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity getFlowAnalysisRuleConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Flow Analysis Rule Config Verification Request", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).get(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity deleteFlowAnalysisRuleConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error deleting Flow Analysis Rule Config Verification Request", () -> {
            WebTarget target = this.controllerTarget.path("flow-analysis-rules/{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).delete(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public ParameterProviderEntity createParamProvider(ParameterProviderEntity paramProvider) throws NiFiClientException, IOException {
        if (paramProvider == null) {
            throw new IllegalArgumentException("Parameter provider cannot be null or blank");
        }
        return this.executeAction("Error creating parameter provider", () -> {
            WebTarget target = this.controllerTarget.path("parameter-providers");
            return (ParameterProviderEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramProvider, (String)"application/json"), ParameterProviderEntity.class);
        });
    }

    @Override
    public ControllerConfigurationEntity getControllerConfiguration() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving controller configuration", () -> {
            WebTarget target = this.controllerTarget.path("config");
            return (ControllerConfigurationEntity)this.getRequestBuilder(target).get(ControllerConfigurationEntity.class);
        });
    }

    @Override
    public ControllerConfigurationEntity updateControllerConfiguration(ControllerConfigurationEntity controllerConfiguration) throws NiFiClientException, IOException {
        if (controllerConfiguration == null || controllerConfiguration.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        if (controllerConfiguration.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        return this.executeAction("Error updating controller configuration", () -> {
            WebTarget target = this.controllerTarget.path("config");
            return (ControllerConfigurationEntity)this.getRequestBuilder(target).put(Entity.entity((Object)controllerConfiguration, (String)"application/json"), ControllerConfigurationEntity.class);
        });
    }

    @Override
    public NarSummaryEntity uploadNar(String filename, InputStream narContentStream) throws NiFiClientException, IOException {
        if (narContentStream == null) {
            throw new IllegalArgumentException("NAR content stream is required");
        }
        return this.executeAction("Error uploading NAR", () -> {
            WebTarget target = this.controllerTarget.path(NAR_UPLOAD_PATH);
            return (NarSummaryEntity)this.getRequestBuilder(target).header("Filename", (Object)filename).post(Entity.entity((Object)narContentStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE), NarSummaryEntity.class);
        });
    }

    @Override
    public NarSummariesEntity getNarSummaries() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving NAR summaries", () -> {
            WebTarget target = this.controllerTarget.path(NARS_PATH);
            return (NarSummariesEntity)this.getRequestBuilder(target).get(NarSummariesEntity.class);
        });
    }

    @Override
    public NarSummaryEntity getNarSummary(String identifier) throws NiFiClientException, IOException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is required");
        }
        return this.executeAction("Error getting NAR summary", () -> {
            WebTarget target = this.controllerTarget.path("nar-manager/nars/{identifier}").resolveTemplate("identifier", (Object)identifier);
            return (NarSummaryEntity)this.getRequestBuilder(target).get(NarSummaryEntity.class);
        });
    }

    @Override
    public NarSummaryEntity deleteNar(String identifier, boolean forceDelete) throws NiFiClientException, IOException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is required");
        }
        return this.executeAction("Error deleting NAR", () -> {
            WebTarget target = this.controllerTarget.path("nar-manager/nars/{identifier}").resolveTemplate("identifier", (Object)identifier).queryParam("force", new Object[]{String.valueOf(forceDelete)});
            return (NarSummaryEntity)this.getRequestBuilder(target).delete(NarSummaryEntity.class);
        });
    }

    @Override
    public NarDetailsEntity getNarDetails(String identifier) throws NiFiClientException, IOException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is required");
        }
        return this.executeAction("Error getting NAR details", () -> {
            WebTarget target = this.controllerTarget.path("nar-manager/nars/{identifier}/details").resolveTemplate("identifier", (Object)identifier);
            return (NarDetailsEntity)this.getRequestBuilder(target).get(NarDetailsEntity.class);
        });
    }

    @Override
    public File downloadNar(String identifier, File outputDirectory) throws NiFiClientException, IOException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is required");
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException("Output directory is required");
        }
        return this.executeAction("Error downloading NAR", () -> {
            WebTarget target = this.controllerTarget.path("nar-manager/nars/{identifier}/content").resolveTemplate("identifier", (Object)identifier);
            Response response = this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
            String filename = this.getContentDispositionFilename(response);
            File narFile = new File(outputDirectory, filename);
            try (InputStream responseInputStream = (InputStream)response.readEntity(InputStream.class);){
                Files.copy(responseInputStream, narFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = narFile;
                return file;
            }
        });
    }
}

