/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;

@XmlType(name="registry")
public class FlowRegistryClientDTO {
    public static final String VALID = "VALID";
    public static final String INVALID = "INVALID";
    public static final String VALIDATING = "VALIDATING";
    private String id;
    private String name;
    private String description;
    private String type;
    private BundleDTO bundle;
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Set<String> sensitiveDynamicPropertyNames;
    private Boolean supportsSensitiveDynamicProperties;
    private Boolean supportsBranching;
    private Boolean restricted;
    private Boolean deprecated;
    private Boolean isExtensionMissing;
    private Boolean setMultipleVersionsAvailable;
    private Collection<String> validationErrors;
    private String validationStatus;
    private String annotationData;

    @Schema(description="The registry identifier")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The registry name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The registry description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The type of the registry client.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Schema(description="The details of the artifact that bundled this registry client type.")
    public BundleDTO getBundle() {
        return this.bundle;
    }

    public void setBundle(BundleDTO bundle) {
        this.bundle = bundle;
    }

    @Schema(description="The properties of the registry client.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Schema(description="The descriptors for the registry client properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @Schema(description="Set of sensitive dynamic property names")
    public Set<String> getSensitiveDynamicPropertyNames() {
        return this.sensitiveDynamicPropertyNames;
    }

    public void setSensitiveDynamicPropertyNames(Set<String> sensitiveDynamicPropertyNames) {
        this.sensitiveDynamicPropertyNames = sensitiveDynamicPropertyNames;
    }

    @Schema(description="Whether the registry client supports sensitive dynamic properties.")
    public Boolean getSupportsSensitiveDynamicProperties() {
        return this.supportsSensitiveDynamicProperties;
    }

    public void setSupportsSensitiveDynamicProperties(Boolean supportsSensitiveDynamicProperties) {
        this.supportsSensitiveDynamicProperties = supportsSensitiveDynamicProperties;
    }

    @Schema(description="Whether the registry client supports branching.")
    public Boolean getSupportsBranching() {
        return this.supportsBranching;
    }

    public void setSupportsBranching(Boolean supportsBranching) {
        this.supportsBranching = supportsBranching;
    }

    @Schema(description="Whether the registry client requires elevated privileges.")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @Schema(description="Whether the registry client has been deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Schema(description="Whether the underlying extension is missing.")
    public Boolean getExtensionMissing() {
        return this.isExtensionMissing;
    }

    public void setExtensionMissing(Boolean extensionMissing) {
        this.isExtensionMissing = extensionMissing;
    }

    @Schema(description="Whether the flow registry client has multiple versions available.")
    public Boolean getMultipleVersionsAvailable() {
        return this.setMultipleVersionsAvailable;
    }

    public void setMultipleVersionsAvailable(Boolean setMultipleVersionsAvailable) {
        this.setMultipleVersionsAvailable = setMultipleVersionsAvailable;
    }

    @Schema(description="The annotation data for the registry client. This is how the custom UI relays configuration to the registry client.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @Schema(description="Gets the validation errors from the registry client. These validation errors represent the problems with the registry client that must be resolved before it can be used for interacting with the flow registry.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @Schema(description="Indicates whether the Registry Client is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Registry Client is valid)", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"VALID, INVALID, VALIDATING"})
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }
}

