/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;

@XmlType(name="flowSnippet")
public class FlowSnippetDTO {
    private static final long LSB = 0L;
    private Set<ProcessGroupDTO> processGroups = new LinkedHashSet<ProcessGroupDTO>();
    private Set<RemoteProcessGroupDTO> remoteProcessGroups = new LinkedHashSet<RemoteProcessGroupDTO>();
    private Set<ProcessorDTO> processors = new LinkedHashSet<ProcessorDTO>();
    private Set<PortDTO> inputPorts = new LinkedHashSet<PortDTO>();
    private Set<PortDTO> outputPorts = new LinkedHashSet<PortDTO>();
    private Set<ConnectionDTO> connections = new LinkedHashSet<ConnectionDTO>();
    private Set<LabelDTO> labels = new LinkedHashSet<LabelDTO>();
    private Set<FunnelDTO> funnels = new LinkedHashSet<FunnelDTO>();
    private Set<ControllerServiceDTO> controllerServices = new LinkedHashSet<ControllerServiceDTO>();
    private final boolean newTemplate;
    private Set<String> convertedUuids = new HashSet<String>();

    public FlowSnippetDTO() {
        this(false);
    }

    public FlowSnippetDTO(boolean newTemplate) {
        this.newTemplate = newTemplate;
    }

    @Schema(description="The connections in this flow snippet.")
    public Set<ConnectionDTO> getConnections() {
        return this.connections;
    }

    public void setConnections(Set<ConnectionDTO> connections) {
        this.removeInstanceIdentifierIfNecessary(connections);
        this.connections = this.orderedById(connections);
    }

    @Schema(description="The input ports in this flow snippet.")
    public Set<PortDTO> getInputPorts() {
        return this.inputPorts;
    }

    public void setInputPorts(Set<PortDTO> inputPorts) {
        this.removeInstanceIdentifierIfNecessary(inputPorts);
        this.inputPorts = this.orderedById(inputPorts);
    }

    @Schema(description="The labels in this flow snippet.")
    public Set<LabelDTO> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<LabelDTO> labels) {
        this.removeInstanceIdentifierIfNecessary(labels);
        this.labels = this.orderedById(labels);
    }

    @Schema(description="The funnels in this flow snippet.")
    public Set<FunnelDTO> getFunnels() {
        return this.funnels;
    }

    public void setFunnels(Set<FunnelDTO> funnels) {
        this.removeInstanceIdentifierIfNecessary(funnels);
        this.funnels = this.orderedById(funnels);
    }

    @Schema(description="The output ports in this flow snippet.")
    public Set<PortDTO> getOutputPorts() {
        return this.outputPorts;
    }

    public void setOutputPorts(Set<PortDTO> outputPorts) {
        this.removeInstanceIdentifierIfNecessary(outputPorts);
        this.outputPorts = this.orderedById(outputPorts);
    }

    @Schema(description="The process groups in this flow snippet.")
    public Set<ProcessGroupDTO> getProcessGroups() {
        return this.processGroups;
    }

    public void setProcessGroups(Set<ProcessGroupDTO> processGroups) {
        this.removeInstanceIdentifierIfNecessary(processGroups);
        this.processGroups = this.orderedById(processGroups);
    }

    @Schema(description="The processors in this flow snippet.")
    public Set<ProcessorDTO> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Set<ProcessorDTO> processors) {
        this.removeInstanceIdentifierIfNecessary(processors);
        this.processors = this.orderedById(processors);
    }

    @Schema(description="The remote process groups in this flow snippet.")
    public Set<RemoteProcessGroupDTO> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public void setRemoteProcessGroups(Set<RemoteProcessGroupDTO> remoteProcessGroups) {
        this.removeInstanceIdentifierIfNecessary(remoteProcessGroups);
        this.remoteProcessGroups = this.orderedById(remoteProcessGroups);
    }

    @Schema(description="The controller services in this flow snippet.")
    public Set<ControllerServiceDTO> getControllerServices() {
        return this.controllerServices;
    }

    public void setControllerServices(Set<ControllerServiceDTO> controllerServices) {
        this.removeInstanceIdentifierIfNecessary(controllerServices);
        this.controllerServices = this.orderedById(controllerServices);
    }

    private <T extends ComponentDTO> Set<T> orderedById(Set<T> dtos) {
        TreeSet<ComponentDTO> components = new TreeSet<ComponentDTO>(new Comparator<ComponentDTO>(this){

            @Override
            public int compare(ComponentDTO c1, ComponentDTO c2) {
                return c1.getId().compareTo(c2.getId());
            }
        });
        components.addAll(dtos);
        return components;
    }

    private long generateMsb(String id) {
        UUID temp;
        if (this.convertedUuids.contains(id)) {
            temp = UUID.fromString(id);
        } else {
            temp = UUID.nameUUIDFromBytes(id.getBytes(StandardCharsets.UTF_8));
            this.convertedUuids.add(new UUID(temp.getMostSignificantBits(), 0L).toString());
        }
        return temp.getMostSignificantBits();
    }

    private void removeInstanceIdentifierIfNecessary(Set<? extends ComponentDTO> componentDtos) {
        if (this.newTemplate) {
            for (ComponentDTO componentDTO : componentDtos) {
                String value;
                String key;
                Map<String, String> props;
                Map<String, PropertyDescriptorDTO> map;
                UUID id = new UUID(this.generateMsb(componentDTO.getId()), 0L);
                componentDTO.setId(id.toString());
                id = new UUID(this.generateMsb(componentDTO.getParentGroupId()), 0L);
                componentDTO.setParentGroupId(id.toString());
                if (componentDTO instanceof ControllerServiceDTO) {
                    ControllerServiceDTO csDTO = (ControllerServiceDTO)componentDTO;
                    map = csDTO.getDescriptors();
                    props = csDTO.getProperties();
                    for (Map.Entry<String, PropertyDescriptorDTO> entry : map.entrySet()) {
                        if (entry.getValue().getIdentifiesControllerService() == null || props.get(entry.getKey()) == null) continue;
                        key = entry.getKey();
                        value = props.get(key);
                        id = new UUID(this.generateMsb(value), 0L);
                        props.put(key, id.toString());
                    }
                    continue;
                }
                if (componentDTO instanceof ProcessorDTO) {
                    ProcessorDTO processorDTO = (ProcessorDTO)componentDTO;
                    map = processorDTO.getConfig().getDescriptors();
                    props = processorDTO.getConfig().getProperties();
                    for (Map.Entry<String, PropertyDescriptorDTO> entry : map.entrySet()) {
                        if (entry.getValue().getIdentifiesControllerService() == null || props.get(entry.getKey()) == null) continue;
                        key = entry.getKey();
                        value = props.get(key);
                        id = new UUID(this.generateMsb(value), 0L);
                        props.put(key, id.toString());
                    }
                    continue;
                }
                if (componentDTO instanceof ConnectionDTO) {
                    ConnectionDTO connectionDTO = (ConnectionDTO)componentDTO;
                    ConnectableDTO cdto = connectionDTO.getSource();
                    if (!cdto.getType().equals("REMOTE_INPUT_PORT") && !cdto.getType().equals("REMOTE_OUTPUT_PORT")) {
                        id = new UUID(this.generateMsb(cdto.getId()), 0L);
                        cdto.setId(id.toString());
                    }
                    id = new UUID(this.generateMsb(cdto.getGroupId()), 0L);
                    cdto.setGroupId(id.toString());
                    cdto = connectionDTO.getDestination();
                    if (!cdto.getType().equals("REMOTE_INPUT_PORT") && !cdto.getType().equals("REMOTE_OUTPUT_PORT")) {
                        id = new UUID(this.generateMsb(cdto.getId()), 0L);
                        cdto.setId(id.toString());
                    }
                    id = new UUID(this.generateMsb(cdto.getGroupId()), 0L);
                    cdto.setGroupId(id.toString());
                    continue;
                }
                if (componentDTO instanceof ProcessGroupDTO) {
                    FlowSnippetDTO fsDTO = ((ProcessGroupDTO)componentDTO).getContents();
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getConnections());
                    fsDTO.connections = this.orderedById(fsDTO.getConnections());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getControllerServices());
                    fsDTO.controllerServices = this.orderedById(fsDTO.getControllerServices());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getFunnels());
                    fsDTO.funnels = this.orderedById(fsDTO.getFunnels());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getInputPorts());
                    fsDTO.inputPorts = this.orderedById(fsDTO.getInputPorts());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getLabels());
                    fsDTO.labels = this.orderedById(fsDTO.getLabels());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getOutputPorts());
                    fsDTO.outputPorts = this.orderedById(fsDTO.getOutputPorts());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getProcessGroups());
                    fsDTO.processGroups = this.orderedById(fsDTO.getProcessGroups());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getProcessors());
                    fsDTO.processors = this.orderedById(fsDTO.getProcessors());
                    this.removeInstanceIdentifierIfNecessary(fsDTO.getRemoteProcessGroups());
                    fsDTO.remoteProcessGroups = this.orderedById(fsDTO.getRemoteProcessGroups());
                    continue;
                }
                if (!(componentDTO instanceof RemoteProcessGroupDTO)) continue;
                RemoteProcessGroupContentsDTO contentsDTO = ((RemoteProcessGroupDTO)componentDTO).getContents();
                contentsDTO.setInputPorts(this.orderedRemotePortsById(contentsDTO.getInputPorts()));
                contentsDTO.setOutputPorts(this.orderedRemotePortsById(contentsDTO.getOutputPorts()));
            }
        }
    }

    private <T extends RemoteProcessGroupPortDTO> Set<T> orderedRemotePortsById(Set<T> dtos) {
        TreeSet<RemoteProcessGroupPortDTO> components = new TreeSet<RemoteProcessGroupPortDTO>(new Comparator<RemoteProcessGroupPortDTO>(this){

            @Override
            public int compare(RemoteProcessGroupPortDTO c1, RemoteProcessGroupPortDTO c2) {
                return UUID.fromString(c1.getId()).compareTo(UUID.fromString(c2.getId()));
            }
        });
        components.addAll(dtos);
        return components;
    }
}

