/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.VersionedRemoteResource;
import org.apache.nifi.remote.exception.HandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteResourceInitiator {
    public static final int RESOURCE_OK = 20;
    public static final int DIFFERENT_RESOURCE_VERSION = 21;
    public static final int ABORT = 255;
    private static final Logger logger = LoggerFactory.getLogger(RemoteResourceInitiator.class);

    public static VersionedRemoteResource initiateResourceNegotiation(VersionedRemoteResource resource, DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        logger.debug("Negotiating resource; proposal is {}", (Object)resource);
        dos.writeUTF(resource.getResourceName());
        VersionNegotiator negotiator = resource.getVersionNegotiator();
        dos.writeInt(negotiator.getVersion());
        dos.flush();
        logger.debug("Receiving response from remote instance");
        int statusCode = dis.read();
        switch (statusCode) {
            case 20: {
                logger.debug("Response was RESOURCE_OK");
                return resource;
            }
            case 21: {
                logger.debug("Response was DIFFERENT_RESOURCE_VERSION");
                int newVersion = dis.readInt();
                Integer newPreference = negotiator.getPreferredVersion(newVersion);
                if (newPreference == null) {
                    throw new HandshakeException("Could not agree on version for " + resource);
                }
                negotiator.setVersion(newPreference.intValue());
                return RemoteResourceInitiator.initiateResourceNegotiation(resource, dis, dos);
            }
            case 255: {
                logger.debug("Response was ABORT");
                throw new HandshakeException("Remote destination aborted connection with message: " + dis.readUTF());
            }
        }
        logger.debug("Response was {}; unable to negotiate codec", (Object)statusCode);
        return null;
    }
}

