/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.griffin.engine.union.AbstractUnionRecord;
import io.questdb.griffin.engine.union.UnionCastRecord;
import io.questdb.griffin.engine.union.UnionRecord;
import io.questdb.std.ObjList;

class UnionAllRecordCursor
extends AbstractSetRecordCursor
implements NoRandomAccessRecordCursor {
    private final NextMethod nextB = this::nextB;
    private final AbstractUnionRecord record;
    private NextMethod nextMethod;
    private final NextMethod nextA = this::nextA;

    public UnionAllRecordCursor(ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB) {
        if (castFunctionsA != null && castFunctionsB != null) {
            this.record = new UnionCastRecord(castFunctionsA, castFunctionsB);
        } else {
            assert (castFunctionsA == null && castFunctionsB == null);
            this.record = new UnionRecord();
        }
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        return this.nextMethod.next();
    }

    @Override
    public long size() {
        long sizeA = this.cursorA.size();
        long sizeB = this.cursorB.size();
        if (sizeA == -1L || sizeB == -1L) {
            return -1L;
        }
        return sizeA + sizeB;
    }

    @Override
    public void toTop() {
        this.record.setAb(true);
        this.nextMethod = this.nextA;
        this.cursorA.toTop();
        this.cursorB.toTop();
    }

    private boolean nextA() {
        return this.cursorA.hasNext() || this.switchToSlaveCursor();
    }

    private boolean nextB() {
        return this.cursorB.hasNext();
    }

    private boolean switchToSlaveCursor() {
        this.record.setAb(false);
        this.nextMethod = this.nextB;
        return this.nextMethod.next();
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        super.of(cursorA, cursorB, circuitBreaker);
        this.record.of(cursorA.getRecord(), cursorB.getRecord());
        this.toTop();
    }

    static interface NextMethod {
        public boolean next();
    }
}

