/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.Arrays;

public class KSumDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    private static final int COUNT_PADDING = 8;
    private static final int SUM_PADDING = 9;
    private final int columnIndex;
    private final long[] count;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final double[] sum;
    private final int workerCount;
    private int valueOffset;

    public KSumDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        this.sum = new double[workerCount * 9];
        this.count = new long[workerCount * 8];
        this.workerCount = workerCount;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourKSumDouble;
        } else {
            this.keyValueFunc = Rosti::keyedIntKSumDouble;
            this.distinctFunc = Rosti::keyedIntDistinct;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int columnSizeHint, int workerId) {
        double x;
        if (address != 0L && (x = Vect.sumDoubleKahan(address, addressSize / 8L)) == x) {
            int sumOffset = workerId * 9;
            double sum = this.sum[sumOffset];
            double y = x - this.sum[sumOffset + 1];
            double t = sum + y;
            this.sum[sumOffset + 1] = t - sum - y;
            this.sum[sumOffset] = t;
            int n = workerId * 8;
            this.count[n] = this.count[n] + 1L;
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int columnSizeShr, int workerId) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
    }

    @Override
    public void clear() {
        Arrays.fill(this.sum, 0.0);
        Arrays.fill(this.count, 0L);
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public double getDouble(Record rec) {
        double sum = 0.0;
        long count = 0L;
        double c = 0.0;
        for (int i = 0; i < this.workerCount; ++i) {
            double y = this.sum[i * 9] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
            count += this.count[i * 8];
        }
        return count > 0L ? sum : Double.NaN;
    }

    @Override
    public String getName() {
        return "ksum";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0.0);
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0.0);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 2), 0L);
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntKSumDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(10);
        types.add(10);
        types.add(6);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        double sum = 0.0;
        long count = 0L;
        double c = 0.0;
        for (int i = 0; i < this.workerCount; ++i) {
            double y = this.sum[i * 9] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
            count += this.count[i * 8];
        }
        return Rosti.keyedIntKSumDoubleWrapUp(pRosti, this.valueOffset, sum, count);
    }
}

