/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.ITreeCursorMutable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceMutable;
import jetbrains.exodus.tree.patricia.ChildReferenceTransient;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.MutableNodeSaveContext;
import jetbrains.exodus.tree.patricia.MutableRoot;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.PatriciaReclaimActualTraverser;
import jetbrains.exodus.tree.patricia.PatriciaReclaimSourceTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeForReclaim;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0003\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010#\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\u0000H\u0016J\u0010\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\nJ\u001e\u0010/\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010.\u001a\u00020-H\u0002J\b\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u00105\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u00106\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020 2\f\u00109\u001a\b\u0012\u0004\u0012\u00020 0:H\u0016J\b\u0010;\u001a\u00020\bH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006="}, d2={"Ljetbrains/exodus/tree/patricia/PatriciaTreeMutable;", "Ljetbrains/exodus/tree/patricia/PatriciaTreeBase;", "Ljetbrains/exodus/tree/ITreeMutable;", "log", "Ljetbrains/exodus/log/Log;", "structureId", "", "treeSize", "", "immutableRoot", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "(Ljetbrains/exodus/log/Log;IJLjetbrains/exodus/tree/patricia/ImmutableNode;)V", "expiredLoggables", "Ljetbrains/exodus/tree/ExpiredLoggableCollection;", "openCursors", "", "Ljetbrains/exodus/tree/ITreeCursorMutable;", "root", "Ljetbrains/exodus/tree/patricia/MutableRoot;", "useV1Format", "", "getUseV1Format", "()Z", "add", "key", "Ljetbrains/exodus/ByteIterable;", "value", "ln", "Ljetbrains/exodus/tree/INode;", "addExpiredLoggable", "", "sourceLoggable", "Ljetbrains/exodus/log/RandomAccessLoggable;", "cursorClosed", "cursor", "delete", "cursorToSkip", "deleteImpl", "getExpiredLoggables", "getMutableCopy", "getOpenCursors", "getRoot", "getRootAddress", "isAllowingDuplicates", "mutateNode", "Ljetbrains/exodus/tree/patricia/MutableNode;", "node", "mutateUp", "stack", "Ljava/util/Deque;", "Ljetbrains/exodus/tree/patricia/ChildReferenceTransient;", "openCursor", "Ljetbrains/exodus/tree/TreeCursorMutable;", "put", "putRight", "reclaim", "loggable", "loggables", "", "save", "Companion", "xodus-environment"})
public final class PatriciaTreeMutable
extends PatriciaTreeBase
implements ITreeMutable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MutableRoot root;
    @Nullable
    private ExpiredLoggableCollection expiredLoggables;
    @Nullable
    private Set<ITreeCursorMutable> openCursors;

    public PatriciaTreeMutable(@NotNull Log log, int structureId, long treeSize, @NotNull ImmutableNode immutableRoot) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)immutableRoot, (String)"immutableRoot");
        super(log, structureId);
        this.root = new MutableRoot(immutableRoot);
        this.size = treeSize;
        this.addExpiredLoggable(immutableRoot.getLoggable());
    }

    public final boolean getUseV1Format() {
        return this.log.getConfig().useV1Format();
    }

    @Override
    public long getRootAddress() {
        return -1L;
    }

    @Override
    @NotNull
    public PatriciaTreeMutable getMutableCopy() {
        return this;
    }

    @Override
    public boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteIterator it = key.iterator();
        MutableNode node = this.root;
        MutableNode prev = null;
        byte prevFirstByte = 0;
        while (true) {
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                MutableNode prefix = node.splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                if (NodeBase.MatchResult.hasNext(matchResult)) {
                    int n = NodeBase.MatchResult.getNextByte(matchResult);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    prefix.hang(n, it).setValue(value);
                } else {
                    prefix.setValue(value);
                }
                if (prev == null) {
                    this.root = new MutableRoot(prefix, this.root.getSourceAddress());
                } else {
                    prev.setChild(prevFirstByte, prefix);
                }
                ++this.size;
                return true;
            }
            if (!it.hasNext()) {
                ByteIterable oldValue = node.getValue();
                node.setValue(value);
                if (oldValue == null) {
                    ++this.size;
                    return true;
                }
                return !Intrinsics.areEqual((Object)oldValue, (Object)value);
            }
            byte nextByte = it.next();
            NodeBase child = node.getChild(this, nextByte);
            if (child == null) {
                if (node.hasChildren() || node.hasKey() || node.hasValue()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    node.hang(nextByte, it).setValue(value);
                } else {
                    node.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                    node.setValue(value);
                }
                ++this.size;
                return true;
            }
            prev = node;
            prevFirstByte = nextByte;
            MutableNode mutableChild = child.getMutableCopy(this);
            if (!child.isMutable()) {
                Intrinsics.checkNotNullExpressionValue((Object)mutableChild, (String)"mutableChild");
                node.setChild(nextByte, mutableChild);
            }
            Intrinsics.checkNotNullExpressionValue((Object)mutableChild, (String)"mutableChild");
            node = mutableChild;
        }
    }

    @Override
    public void putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteIterator it = key.iterator();
        MutableNode node = this.root;
        MutableNode prev = null;
        byte prevFirstByte = 0;
        while (true) {
            String string;
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                if (!NodeBase.MatchResult.hasNext(matchResult)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                MutableNode prefix = node.splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                int n = NodeBase.MatchResult.getNextByte(matchResult);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                prefix.hangRight(n, it).setValue(value);
                if (prev == null) {
                    this.root = new MutableRoot(prefix, this.root.getSourceAddress());
                } else {
                    prev.setChild(prevFirstByte, prefix);
                }
                ++this.size;
                break;
            }
            if (!it.hasNext()) {
                if (!(!node.hasChildren() && !node.hasValue())) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                node.setValue(value);
                ++this.size;
                break;
            }
            byte nextByte = it.next();
            NodeBase child = node.getRightChild(this, nextByte);
            if (child == null) {
                if (node.hasChildren() || node.hasKey() || node.hasValue()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    node.hangRight(nextByte, it).setValue(value);
                } else {
                    node.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                    node.setValue(value);
                }
                ++this.size;
                break;
            }
            prev = node;
            prevFirstByte = nextByte;
            MutableNode mutableChild = child.getMutableCopy(this);
            if (!child.isMutable()) {
                Intrinsics.checkNotNullExpressionValue((Object)mutableChild, (String)"mutableChild");
                node.setRightChild(nextByte, mutableChild);
            }
            Intrinsics.checkNotNullExpressionValue((Object)mutableChild, (String)"mutableChild");
            node = mutableChild;
        }
    }

    @Override
    public boolean add(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteIterator it = key.iterator();
        NodeBase node = this.root;
        MutableNode mutableNode = null;
        ArrayDeque<ChildReferenceTransient> stack = new ArrayDeque<ChildReferenceTransient>();
        while (true) {
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                MutableNode prefix = node.getMutableCopy(this).splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                if (NodeBase.MatchResult.hasNext(matchResult)) {
                    int n = NodeBase.MatchResult.getNextByte(matchResult);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    prefix.hang(n, it).setValue(value);
                } else {
                    prefix.setValue(value);
                }
                if (stack.isEmpty()) {
                    this.root = new MutableRoot(prefix, this.root.getSourceAddress());
                    break;
                }
                ChildReferenceTransient parent = (ChildReferenceTransient)stack.pop();
                mutableNode = parent.mutate(this);
                mutableNode.setChild(parent.firstByte, prefix);
                break;
            }
            if (!it.hasNext()) {
                if (node.hasValue()) {
                    return false;
                }
                mutableNode = node.getMutableCopy(this);
                mutableNode.setValue(value);
                break;
            }
            byte nextByte = it.next();
            NodeBase child = node.getChild(this, nextByte);
            if (child == null) {
                mutableNode = node.getMutableCopy(this);
                if (mutableNode.hasChildren() || mutableNode.hasKey() || mutableNode.hasValue()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    mutableNode.hang(nextByte, it).setValue(value);
                    break;
                }
                mutableNode.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                mutableNode.setValue(value);
                break;
            }
            stack.push(new ChildReferenceTransient(nextByte, node));
            node = child;
        }
        ++this.size;
        MutableNode mutableNode2 = mutableNode;
        if (mutableNode2 != null) {
            MutableNode it2 = mutableNode2;
            boolean bl = false;
            this.mutateUp((Deque<ChildReferenceTransient>)stack, mutableNode);
        }
        return true;
    }

    @Override
    public boolean delete(@NotNull ByteIterable key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.deleteImpl(key);
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value, @Nullable ITreeCursorMutable cursorToSkip) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            if (this.deleteImpl(key)) {
                TreeCursorMutable.notifyCursors(this, cursorToSkip);
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException("Patricia tree doesn't support duplicates!");
    }

    @Override
    public void put(@NotNull INode ln) {
        Intrinsics.checkNotNullParameter((Object)ln, (String)"ln");
        ByteIterable byteIterable = ln.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"ln.key");
        this.put(byteIterable, Companion.getNotNullValue(ln));
    }

    @Override
    public void putRight(@NotNull INode ln) {
        Intrinsics.checkNotNullParameter((Object)ln, (String)"ln");
        ByteIterable byteIterable = ln.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"ln.key");
        this.putRight(byteIterable, Companion.getNotNullValue(ln));
    }

    @Override
    public boolean add(@NotNull INode ln) {
        Intrinsics.checkNotNullParameter((Object)ln, (String)"ln");
        ByteIterable byteIterable = ln.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"ln.key");
        return this.add(byteIterable, Companion.getNotNullValue(ln));
    }

    @Override
    public long save() {
        ArrayDeque<ChildReferenceMutable> arrayDeque;
        MutableNodeSaveContext context = new MutableNodeSaveContext(CompressedUnsignedLongByteIterable.getIterable(this.size));
        ArrayDeque<ChildReferenceMutable> $this$save_u24lambda_u2d1 = arrayDeque = new ArrayDeque<ChildReferenceMutable>();
        boolean bl2 = false;
        $this$save_u24lambda_u2d1.push(new ChildReferenceMutable(this.root));
        ArrayDeque<ChildReferenceMutable> stack = arrayDeque;
        while (true) {
            ChildReferenceMutable ref = (ChildReferenceMutable)stack.peek();
            MutableNode bl2 = ref.child;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"ref.child");
            MutableNode node = bl2;
            boolean childPushed = false;
            Sequence children = node.hasChildren() ? SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)node.getChildren())) : SequencesKt.emptySequence();
            for (ChildReference r : children) {
                if (!r.isMutable() || r.suffixAddress != -1L) continue;
                childPushed = true;
                stack.push((ChildReferenceMutable)r);
            }
            if (childPushed) continue;
            long savedAddress = node.save(this, context);
            stack.pop();
            if (stack.isEmpty()) {
                return savedAddress;
            }
            ref.suffixAddress = savedAddress;
        }
    }

    @Override
    @NotNull
    public ExpiredLoggableCollection getExpiredLoggables() {
        ExpiredLoggableCollection expiredLoggableCollection = this.expiredLoggables;
        if (expiredLoggableCollection == null) {
            expiredLoggableCollection = ExpiredLoggableCollection.Companion.getEMPTY();
        }
        return expiredLoggableCollection;
    }

    @Override
    @NotNull
    public TreeCursorMutable openCursor() {
        Set set;
        TreeCursorMutable treeCursorMutable;
        TreeCursorMutable result = treeCursorMutable = new TreeCursorMutable(this, new PatriciaTraverser(this, this.root), this.root.hasValue());
        boolean bl = false;
        Set set2 = this.openCursors;
        if (set2 == null) {
            HashSet hashSet;
            HashSet it = hashSet = new HashSet();
            boolean bl2 = false;
            this.openCursors = (Set)it;
            set = (Set)hashSet;
        } else {
            set = set2;
        }
        set.add((ITreeCursorMutable)result);
        return treeCursorMutable;
    }

    @Override
    public void cursorClosed(@NotNull ITreeCursorMutable cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        ((Set)KodusKt.getNotNull(this.openCursors)).remove(cursor);
    }

    public boolean reclaim(@NotNull RandomAccessLoggable loggable, @NotNull Iterator<? extends RandomAccessLoggable> loggables) {
        Intrinsics.checkNotNullParameter((Object)loggable, (String)"loggable");
        Intrinsics.checkNotNullParameter(loggables, (String)"loggables");
        RandomAccessLoggable l = loggable;
        long minAddress = l.getAddress();
        while (true) {
            byte type;
            if ((type = l.getType()) < 12 || type > 43) {
                if (type != 0) {
                    throw new ExodusException(Intrinsics.stringPlus((String)"Unexpected loggable type ", (Object)l.getType()));
                }
            } else {
                if (l.getStructureId() != this.structureId) {
                    throw new ExodusException(Intrinsics.stringPlus((String)"Unexpected structure id ", (Object)l.getStructureId()));
                }
                if (PatriciaTreeBase.nodeIsRoot(type)) break;
            }
            if (!loggables.hasNext()) {
                return false;
            }
            l = loggables.next();
        }
        long maxAddress = l.getAddress();
        PatriciaTreeForReclaim sourceTree = new PatriciaTreeForReclaim(this.log, maxAddress, this.structureId);
        ImmutableNode sourceRoot = sourceTree.getRoot();
        long backRef = sourceTree.getBackRef();
        if (backRef > 0L) {
            long treeStartAddress = sourceTree.getRootAddress() - backRef;
            if (!(treeStartAddress <= minAddress)) {
                boolean bl = false;
                String string = "Wrong back reference!";
                throw new IllegalStateException(string.toString());
            }
            if (!this.log.hasAddressRange(treeStartAddress, maxAddress)) {
                return false;
            }
            minAddress = treeStartAddress;
        }
        PatriciaReclaimActualTraverser actual = new PatriciaReclaimActualTraverser(this);
        PatriciaTreeMutable.Companion.reclaim(new PatriciaReclaimSourceTraverser(sourceTree, sourceRoot, minAddress), actual);
        return actual.wasReclaim || sourceRoot.getAddress() == this.root.getSourceAddress();
    }

    @Override
    @NotNull
    public MutableRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isAllowingDuplicates() {
        return false;
    }

    @Nullable
    public Set<ITreeCursorMutable> getOpenCursors() {
        return this.openCursors;
    }

    @NotNull
    public final MutableNode mutateNode(@NotNull ImmutableNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.addExpiredLoggable(node.getLoggable());
        return new MutableNode(node);
    }

    private final void addExpiredLoggable(RandomAccessLoggable sourceLoggable) {
        if (sourceLoggable != null && sourceLoggable.getAddress() != -1L) {
            ExpiredLoggableCollection expiredLoggables = this.expiredLoggables;
            if (expiredLoggables == null) {
                this.expiredLoggables = expiredLoggables = new ExpiredLoggableCollection(null, null, null, false, 15, null);
            }
            expiredLoggables.add(sourceLoggable);
        }
    }

    private final boolean deleteImpl(ByteIterable key) {
        Object object;
        ByteIterator it = key.iterator();
        NodeBase node = this.root;
        Deque stack = new ArrayDeque();
        while (true) {
            if (node == null || NodeBase.MatchResult.getMatchingLength(node.matchesKeySequence(it)) < 0) {
                return false;
            }
            if (!it.hasNext()) break;
            byte nextByte = it.next();
            stack.push(new ChildReferenceTransient(nextByte, node));
            node = node.getChild(this, nextByte);
        }
        if (!node.hasValue()) {
            return false;
        }
        this.size += -1L;
        MutableNode mutableNode = node.getMutableCopy(this);
        ChildReferenceTransient parent = (ChildReferenceTransient)stack.peek();
        boolean hasChildren = mutableNode.hasChildren();
        if (!hasChildren && parent != null) {
            stack.pop();
            mutableNode = parent.mutate(this);
            mutableNode.removeChild(parent.firstByte);
            if (!mutableNode.hasValue() && mutableNode.getChildrenCount() == 1) {
                mutableNode.mergeWithSingleChild(this);
            }
        } else {
            mutableNode.setValue(null);
            if (!hasChildren) {
                object = ByteIterable.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EMPTY");
                mutableNode.setKeySequence((ByteIterable)object);
            } else if (mutableNode.getChildrenCount() == 1) {
                mutableNode.mergeWithSingleChild(this);
            }
        }
        object = mutableNode;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mutableNode");
        this.mutateUp(stack, (MutableNode)object);
        return true;
    }

    private final void mutateUp(Deque<ChildReferenceTransient> stack, MutableNode node) {
        MutableNode n = node;
        while (!stack.isEmpty()) {
            ChildReferenceTransient parent = stack.pop();
            MutableNode mutableParent = parent.mutate(this);
            mutableParent.setChild(parent.firstByte, n);
            Intrinsics.checkNotNullExpressionValue((Object)mutableParent, (String)"mutableParent");
            n = mutableParent;
        }
    }

    @JvmStatic
    @NotNull
    public static final ByteIterable getNotNullValue(@NotNull INode ln) {
        return Companion.getNotNullValue(ln);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/tree/patricia/PatriciaTreeMutable$Companion;", "", "()V", "getNotNullValue", "Ljetbrains/exodus/ByteIterable;", "ln", "Ljetbrains/exodus/tree/INode;", "reclaim", "", "source", "Ljetbrains/exodus/tree/patricia/PatriciaReclaimSourceTraverser;", "actual", "Ljetbrains/exodus/tree/patricia/PatriciaReclaimActualTraverser;", "reclaimActualChildren", "upAndRight", "matches", "", "ReclaimFrame", "xodus-environment"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteIterable getNotNullValue(@NotNull INode ln) {
            Intrinsics.checkNotNullParameter((Object)ln, (String)"ln");
            ByteIterable byteIterable = ln.getValue();
            if (byteIterable == null) {
                throw new ExodusException("Value can't be null");
            }
            return byteIterable;
        }

        /*
         * Exception decompiling
         */
        private final void reclaim(PatriciaReclaimSourceTraverser source, PatriciaReclaimActualTraverser actual) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final boolean matches(PatriciaReclaimSourceTraverser $this$matches, PatriciaReclaimActualTraverser actual) {
            return $this$matches.currentNode.getAddress() == actual.currentNode.getAddress();
        }

        private final void reclaimActualChildren(PatriciaReclaimSourceTraverser source, PatriciaReclaimActualTraverser actual) {
            actual.currentNode = actual.currentNode.getMutableCopy(actual.mainTree);
            actual.getItr();
            actual.wasReclaim = true;
            int depth = 1;
            while (true) {
                if (actual.isValidPos()) {
                    ChildReference actualChild = actual.currentChild;
                    long suffixAddress = actualChild.suffixAddress;
                    if (source.isAddressReclaimable(suffixAddress)) {
                        actual.moveDown();
                        actual.currentNode = actual.currentNode.getMutableCopy(actual.mainTree);
                        actual.getItr();
                        actual.wasReclaim = true;
                        int n = depth;
                        depth = n + 1;
                        continue;
                    }
                    actual.moveRight();
                    continue;
                }
                if (--depth == 0) break;
                actual.popAndMutate();
                actual.moveRight();
            }
        }

        private final void upAndRight(PatriciaReclaimSourceTraverser source, PatriciaReclaimActualTraverser actual) {
            actual.popAndMutate();
            source.moveUp();
            source.moveRight();
            actual.moveRight();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/tree/patricia/PatriciaTreeMutable$Companion$ReclaimFrame;", "", "()V", "actPushes", "", "getActPushes", "()I", "setActPushes", "(I)V", "srcPushes", "getSrcPushes", "setSrcPushes", "xodus-environment"})
        private static final class ReclaimFrame {
            private int srcPushes;
            private int actPushes;

            public final int getSrcPushes() {
                return this.srcPushes;
            }

            public final void setSrcPushes(int n) {
                this.srcPushes = n;
            }

            public final int getActPushes() {
                return this.actPushes;
            }

            public final void setActPushes(int n) {
                this.actPushes = n;
            }
        }
    }
}

