/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.btree.BTreeMetaInfo;
import jetbrains.exodus.tree.patricia.PatriciaMetaInfo;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class TreeMetaInfo {
    public static final TreeMetaInfo EMPTY = new Empty(0);
    protected static final int DUPLICATES_BIT = 1;
    protected static final int KEY_PREFIXING_BIT = 2;
    public final boolean duplicates;
    public final int structureId;
    public final Log log;

    protected TreeMetaInfo(Log log, boolean duplicates, int structureId) {
        this.log = log;
        this.duplicates = duplicates;
        this.structureId = structureId;
    }

    public boolean hasDuplicates() {
        return this.duplicates;
    }

    public abstract boolean isKeyPrefixing();

    public int getStructureId() {
        return this.structureId;
    }

    public ByteIterable toByteIterable() {
        byte flags = (byte)(this.duplicates ? 1 : 0);
        if (this.isKeyPrefixing()) {
            flags = (byte)(flags + 2);
        }
        LightOutputStream output = new LightOutputStream(10);
        output.write((int)flags);
        CompressedUnsignedLongByteIterable.fillBytes(0L, output);
        CompressedUnsignedLongByteIterable.fillBytes(this.structureId, output);
        return output.asArrayByteIterable();
    }

    public abstract TreeMetaInfo clone(int var1);

    public static StoreConfig toConfig(@NotNull TreeMetaInfo metaInfo) {
        if (metaInfo.getStructureId() < 0) {
            return StoreConfig.TEMPORARY_EMPTY;
        }
        return StoreConfig.getStoreConfig((boolean)metaInfo.duplicates, (boolean)metaInfo.isKeyPrefixing());
    }

    public static TreeMetaInfo load(@NotNull EnvironmentImpl environment, boolean duplicates, boolean keyPrefixing, int structureId) {
        if (keyPrefixing) {
            return new PatriciaMetaInfo(environment.getLog(), duplicates, structureId);
        }
        return new BTreeMetaInfo(environment, duplicates, structureId);
    }

    public static TreeMetaInfo load(@NotNull EnvironmentImpl environment, @NotNull ByteIterable iterable) {
        ByteIterator it = iterable.iterator();
        byte flagsByte = it.next();
        if ((flagsByte & 2) == 0) {
            return BTreeMetaInfo.load(environment, flagsByte, it);
        }
        return PatriciaMetaInfo.load(environment, flagsByte, it);
    }

    @NotNull
    public static ExpiredLoggableCollection getTreeLoggables(@NotNull ITree tree) {
        if (tree.getSize() > 100000L) {
            return ExpiredLoggableCollection.getFROM_SCRATCH();
        }
        ExpiredLoggableCollection result = new ExpiredLoggableCollection();
        LongIterator it = tree.addressIterator();
        Log log = tree.getLog();
        while (it.hasNext()) {
            long nextAddress = it.next();
            result.add(log.readNotNull(tree.getDataIterator(nextAddress), nextAddress));
        }
        return result;
    }

    private static final class Empty
    extends TreeMetaInfo {
        private Empty(int structureId) {
            super(null, false, structureId);
        }

        @Override
        public boolean isKeyPrefixing() {
            return false;
        }

        @Override
        public TreeMetaInfo clone(int newStructureId) {
            return new Empty(newStructureId);
        }
    }
}

