/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NotNull;

public class StringBinding
extends ComparableBinding {
    public static final StringBinding BINDING;

    private StringBinding() {
    }

    public String readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readString(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeString((String)((Object)object));
    }

    public static String entryToString(@NotNull ByteIterable entry) {
        return (String)((Object)BINDING.entryToObject(entry));
    }

    public static ArrayByteIterable stringToEntry(@NotNull String object) {
        return BINDING.objectToEntry((Comparable)((Object)object));
    }

    static {
        String interner = System.getProperty("exodus.bindings.interner");
        BINDING = "java".equalsIgnoreCase(interner) ? new StringBindingWithJavaInterner() : ("xodus".equalsIgnoreCase(interner) ? new StringBindingWithXodusInterner() : new StringBinding());
    }

    private static class StringBindingWithJavaInterner
    extends StringBinding {
        private StringBindingWithJavaInterner() {
        }

        @Override
        public String readObject(@NotNull ByteArrayInputStream stream) {
            return super.readObject(stream).intern();
        }
    }

    private static class StringBindingWithXodusInterner
    extends StringBinding {
        private StringBindingWithXodusInterner() {
        }

        @Override
        public String readObject(@NotNull ByteArrayInputStream stream) {
            return StringInterner.intern((String)super.readObject(stream));
        }
    }
}

