/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompoundByteIteratorBase
extends ByteIterator {
    @Nullable
    private ByteIterator current;

    protected CompoundByteIteratorBase(@NotNull ByteIterator current) {
        this.current = current;
    }

    protected CompoundByteIteratorBase() {
        this(ByteIterable.EMPTY_ITERATOR);
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        if (this.current.hasNext()) {
            return true;
        }
        this.current = this.nextIterator();
        return this.hasNext();
    }

    @Override
    public long skip(long length) {
        long skipped = 0L;
        while (this.current != null && (skipped += this.current.skip(length - skipped)) < length && this.hasNext()) {
        }
        return skipped;
    }

    @Override
    public byte next() {
        this.hasNext();
        return this.current.next();
    }

    @NotNull
    protected ByteIterator getCurrent() {
        if (this.current == null) {
            throw new ExodusException("Can't get current ByteIterator, hasNext() == false");
        }
        return this.current;
    }

    protected abstract ByteIterator nextIterator();
}

