/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.client.ItemsClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.field.Fields;

public class JerseyItemsClient
extends AbstractJerseyClient
implements ItemsClient {
    private final WebTarget itemsTarget;

    public JerseyItemsClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyItemsClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.itemsTarget = baseTarget.path("/items");
    }

    @Override
    public List<BucketItem> getAll() throws NiFiRegistryException, IOException {
        return this.executeAction("", () -> {
            WebTarget target = this.itemsTarget;
            BucketItem[] bucketItems = (BucketItem[])this.getRequestBuilder(target).get(BucketItem[].class);
            return bucketItems == null ? Collections.emptyList() : Arrays.asList(bucketItems);
        });
    }

    @Override
    public List<BucketItem> getByBucket(String bucketId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        return this.executeAction("", () -> {
            WebTarget target = this.itemsTarget.path("/{bucketId}").resolveTemplate("bucketId", (Object)bucketId);
            BucketItem[] bucketItems = (BucketItem[])this.getRequestBuilder(target).get(BucketItem[].class);
            return bucketItems == null ? Collections.emptyList() : Arrays.asList(bucketItems);
        });
    }

    @Override
    public Fields getFields() throws NiFiRegistryException, IOException {
        return this.executeAction("", () -> {
            WebTarget target = this.itemsTarget.path("/fields");
            return (Fields)this.getRequestBuilder(target).get(Fields.class);
        });
    }
}

