/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.provenance.NamedSearchableField;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.provenance.search.SearchableFieldType;

public class SearchableFields {
    public static final SearchableField Identifier = new NamedSearchableField("Identifier", "identifier", "Identifier", false);
    public static final SearchableField EventTime = new NamedSearchableField("EventTime", "time", "Event Time", false, SearchableFieldType.DATE);
    public static final SearchableField FlowFileUUID = new NamedSearchableField("FlowFileUUID", "uuid", "FlowFile UUID", false);
    public static final SearchableField Filename = new NamedSearchableField("Filename", "filename", "Filename", false);
    public static final SearchableField EventType = new NamedSearchableField("EventType", "eventType", "Event Type", false);
    public static final SearchableField TransitURI = new NamedSearchableField("TransitURI", "transitUri", "Transit URI", false);
    public static final SearchableField ComponentID = new NamedSearchableField("ProcessorID", "processorId", "Component ID", false);
    public static final SearchableField AlternateIdentifierURI = new NamedSearchableField("AlternateIdentifierURI", "alternateIdentifierUri", "Alternate Identifier URI", false);
    public static final SearchableField FileSize = new NamedSearchableField("FileSize", "fileSize", "File Size", false, SearchableFieldType.DATA_SIZE);
    public static final SearchableField Details = new NamedSearchableField("Details", "details", "Details", false, SearchableFieldType.STRING);
    public static final SearchableField Relationship = new NamedSearchableField("Relationship", "relationship", "Relationship", false, SearchableFieldType.STRING);
    public static final SearchableField LineageStartDate = new NamedSearchableField("LineageStartDate", "lineageStartDate", "Lineage Start Date", false, SearchableFieldType.DATE);
    public static final SearchableField LineageIdentifier = new NamedSearchableField("LineageIdentifiers", "lineageIdentifier", "Lineage Identifier", false, SearchableFieldType.STRING);
    public static final SearchableField ContentClaimSection = new NamedSearchableField("ContentClaimSection", "contentClaimSection", "Content Claim Section", false, SearchableFieldType.STRING);
    public static final SearchableField ContentClaimContainer = new NamedSearchableField("ContentClaimContainer", "contentClaimContainer", "Content Claim Container", false, SearchableFieldType.STRING);
    public static final SearchableField ContentClaimIdentifier = new NamedSearchableField("ContentClaimIdentifier", "contentClaimIdentifier", "Content Claim Identifier", false, SearchableFieldType.STRING);
    public static final SearchableField ContentClaimOffset = new NamedSearchableField("ContentClaimOffset", "contentClaimOffset", "Content Claim Offset", false, SearchableFieldType.LONG);
    public static final SearchableField SourceQueueIdentifier = new NamedSearchableField("SourceQueueIdentifier", "sourceQueueIdentifier", "Source Queue Identifier", false, SearchableFieldType.STRING);
    private static final Map<String, SearchableField> standardFields;

    private SearchableFields() {
    }

    public static Collection<SearchableField> getStandardFields() {
        return standardFields.values();
    }

    public static SearchableField getSearchableField(String fieldIdentifier) {
        return standardFields.get(fieldIdentifier);
    }

    public static SearchableField newSearchableAttribute(String attributeName) {
        return new NamedSearchableField(attributeName, attributeName, attributeName, true);
    }

    static {
        SearchableField[] searchableFields = new SearchableField[]{EventTime, FlowFileUUID, Filename, EventType, TransitURI, ComponentID, AlternateIdentifierURI, FileSize, Relationship, Details, LineageStartDate, LineageIdentifier, ContentClaimSection, ContentClaimContainer, ContentClaimIdentifier, ContentClaimOffset, SourceQueueIdentifier};
        HashMap<String, SearchableField> fields = new HashMap<String, SearchableField>();
        for (SearchableField field : searchableFields) {
            fields.put(field.getIdentifier(), field);
        }
        standardFields = Collections.unmodifiableMap(fields);
    }
}

