/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.io.IOException;
import org.netbeans.modules.openide.loaders.UIException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class AskEditorQuestions {
    private AskEditorQuestions() {
    }

    public static IOException throwableIsReadOnly(FileObject fo) {
        IOException e = new IOException("File is read-only: " + fo);
        UIException.annotateUser(e, null, NbBundle.getMessage(AskEditorQuestions.class, "MSG_FileReadOnlySaving", new Object[]{fo.getNameExt()}), null, null);
        return e;
    }

    public static void notifyChangedToReadOnly(String fileName) {
        DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(AskEditorQuestions.class, "MSG_FileReadOnlyChanging", new Object[]{fileName}), 2));
    }

    public static boolean askUserQuestionExceptionOnSave(String localizedMessage) {
        String ask = NbBundle.getMessage(AskEditorQuestions.class, "ASK_OnSaving");
        if ("yes".equals(ask)) {
            return true;
        }
        if ("no".equals(ask)) {
            return false;
        }
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)localizedMessage, 0);
        Object res = DialogDisplayer.getDefault().notify(nd);
        return NotifyDescriptor.OK_OPTION.equals(res);
    }

    public static boolean askFileReadOnlyOnClose(String fileName) {
        String ask = NbBundle.getMessage(AskEditorQuestions.class, "ASK_OnClosing");
        if ("yes".equals(ask)) {
            return true;
        }
        if ("no".equals(ask)) {
            return false;
        }
        Object result = DialogDisplayer.getDefault().notify(new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(AskEditorQuestions.class, "MSG_FileReadOnlyClosing", new Object[]{fileName}), 2, 2));
        return result == NotifyDescriptor.OK_OPTION;
    }
}

