/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.Tree;
import org.openide.util.Parameters;

public abstract class Trigger {
    private static final String[] NO_OPTIONS = new String[0];
    private Set<String> options = Collections.emptySet();

    Trigger() {
    }

    public boolean hasOption(String opt) {
        return this.options.contains(opt);
    }

    public void setOptions(String[] opts) {
        this.options = opts == null || opts.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(opts));
    }

    public String[] getOptions() {
        return this.options.isEmpty() ? NO_OPTIONS : this.options.toArray(new String[0]);
    }

    public static final class PatternDescription
    extends Trigger {
        private final String pattern;
        private final Map<String, String> constraints;
        private final Iterable<? extends String> imports;

        private PatternDescription(String pattern, Map<String, String> constraints, String ... imports) {
            this.pattern = pattern;
            this.constraints = constraints;
            this.imports = Arrays.asList(imports);
        }

        public static PatternDescription create(String pattern, Map<String, String> constraints, String ... imports) {
            Parameters.notNull("pattern", pattern);
            Parameters.notNull("constraints", constraints);
            Parameters.notNull("imports", imports);
            return new PatternDescription(pattern, constraints, imports);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternDescription other = (PatternDescription)obj;
            if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
                return false;
            }
            return this.constraints == other.constraints || this.constraints != null && this.constraints.equals(other.constraints);
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
            hash = 71 * hash + (this.constraints != null ? this.constraints.hashCode() : 0);
            return hash;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Map<String, String> getConstraints() {
            return this.constraints;
        }

        public Iterable<? extends String> getImports() {
            return this.imports;
        }

        public String toString() {
            return this.pattern;
        }
    }

    public static final class Kinds
    extends Trigger {
        private final Set<Tree.Kind> kinds;

        public Kinds(Set<Tree.Kind> kinds) {
            this.kinds = kinds;
        }

        public Iterable<? extends Tree.Kind> getKinds() {
            return this.kinds;
        }

        public String toString() {
            return this.kinds.toString();
        }
    }
}

