/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class ShowJavadocAction
extends NodeAction {
    private static final Logger LOG = Logger.getLogger(ShowJavadocAction.class.getName());

    ShowJavadocAction() {
    }

    @Override
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return;
        }
        JavadocProvider jd = activatedNodes[0].getLookup().lookup(JavadocProvider.class);
        if (jd == null) {
            return;
        }
        jd.showJavadoc();
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        JavadocProvider jd = activatedNodes[0].getLookup().lookup(JavadocProvider.class);
        if (jd == null) {
            return false;
        }
        return jd.hasJavadoc();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ShowJavadocAction.class, "CTL_ShowJavadoc");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowJavadocAction.class);
    }

    @Override
    public boolean asynchronous() {
        return false;
    }

    static void showJavaDoc(URL javadoc, String displayName) {
        if (javadoc != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(javadoc);
        } else {
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getMessage(ShowJavadocAction.class, "TXT_NoJavadoc"), displayName));
        }
    }

    static URL findJavadoc(String resource, URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String base = urls[i].toExternalForm();
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            try {
                URL u = new URL(base + resource);
                if (u.getProtocol().startsWith("http")) {
                    try {
                        InputStream in = u.openStream();
                        in.close();
                        return u;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Ignoring non existent URL: ", u.toExternalForm());
                        continue;
                    }
                }
                FileObject fo = URLMapper.findFileObject(u);
                if (fo == null) continue;
                return u;
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, "Cannot create URL for " + base + resource + ". " + ex.toString());
            }
        }
        return null;
    }

    public static interface JavadocProvider {
        public boolean hasJavadoc();

        public void showJavadoc();
    }
}

