/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.analysis.AnalysisResult;
import org.netbeans.modules.analysis.DescriptionReader;
import org.netbeans.modules.analysis.RunAnalysis;
import org.netbeans.modules.analysis.RunAnalysisPanel;
import org.netbeans.modules.analysis.ui.Bundle;
import org.netbeans.modules.analysis.ui.NextError;
import org.netbeans.modules.analysis.ui.Nodes;
import org.netbeans.modules.analysis.ui.PreviousError;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="AnalysisResultTopComponent", persistenceType=0)
public final class AnalysisResultTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    static final String PREFERRED_ID = "AnalysisResultTopComponent";
    private final ExplorerManager manager = new ExplorerManager();
    private Lookup context;
    private RunAnalysisPanel.DialogState dialogState;
    private BeanTreeView btv;
    private JPanel btvHolder;
    private JToggleButton byCategory;
    private JEditorPane descriptionPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JButton nextError;
    private JButton previousError;
    private JButton refreshButton;
    boolean selectOnEnable;
    final PreviousError prevAction;
    final NextError nextAction;
    AnalysisResult analysisResult;

    public AnalysisResultTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_AnalysisResultTopComponent());
        this.setToolTipText(Bundle.HINT_AnalysisResultTopComponent());
        this.btv = new BeanTreeView();
        this.btvHolder.setLayout(new BorderLayout());
        this.btvHolder.add((Component)this.btv, "Center");
        this.btv.setRootVisible(false);
        this.prevAction = new PreviousError(this);
        this.nextAction = new NextError(this);
        PCLImpl l = new PCLImpl();
        this.prevAction.addPropertyChangeListener(l);
        this.nextAction.addPropertyChangeListener(l);
        this.previousError.setEnabled(this.prevAction.isEnabled());
        this.nextError.setEnabled(this.nextAction.isEnabled());
        this.setData(Lookup.EMPTY, null, new AnalysisResult(Collections.emptyMap(), Collections.emptyMap(), new RunAnalysisPanel.FutureWarnings(), Collections.emptyList()));
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        HTMLEditorKit hek = new HTMLEditorKit();
        StyleSheet styleSheet = hek.getStyleSheet();
        styleSheet.addRule("body { font-family: Verdana, \"Verdana CE\",  Arial, \"Arial CE\", \"Lucida Grande CE\", lucida, \"Helvetica CE\", sans-serif; }");
        styleSheet.addRule("h1 { font-weight: bold; font-size: 100% }");
        hek.setStyleSheet(styleSheet);
        this.descriptionPanel.setEditorKit(hek);
        this.descriptionPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] selectedNodes = AnalysisResultTopComponent.this.manager.getSelectedNodes();
                if (selectedNodes.length == 1) {
                    DescriptionReader rd = selectedNodes[0].getLookup().lookup(DescriptionReader.class);
                    CharSequence description = rd != null ? rd.getDescription() : null;
                    AnalysisResultTopComponent.this.descriptionPanel.setText(description != null ? description.toString() : null);
                }
                AnalysisResultTopComponent.this.selectOnEnable = false;
            }
        });
        this.descriptionPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                    if (e.getURL().getRef() == null) {
                        FileObject file = URLMapper.findFileObject(e.getURL());
                        if (file != null) {
                            EditCookie ec = file.getLookup().lookup(EditCookie.class);
                            if (ec != null) {
                                ec.edit();
                                return;
                            }
                            OpenCookie oc = file.getLookup().lookup(OpenCookie.class);
                            if (oc != null) {
                                oc.open();
                                return;
                            }
                        }
                    } else {
                        try {
                            DataObject dobj;
                            URL url;
                            int line = e.getURL().getRef().startsWith("line") ? Integer.parseInt(e.getURL().getRef().substring(4)) : Integer.parseInt(e.getURL().getRef());
                            String s = e.getURL().toExternalForm();
                            if (s.indexOf("#") > 0) {
                                s = s.substring(0, s.indexOf("#"));
                                url = new URL(s);
                            } else {
                                url = e.getURL();
                            }
                            FileObject file = URLMapper.findFileObject(url);
                            if (file != null && (dobj = DataObject.find(file)) != null) {
                                NbDocument.openDocument(dobj, line - 1, 0, Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                                return;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            // empty catch block
                        }
                    }
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.btvHolder = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPanel = new JEditorPane();
        this.jToolBar1 = new JToolBar();
        this.refreshButton = new JButton();
        this.previousError = new JButton();
        this.nextError = new JButton();
        this.byCategory = new JToggleButton();
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                AnalysisResultTopComponent.this.jSplitPane1ComponentResized(evt);
            }
        });
        GroupLayout btvHolderLayout = new GroupLayout(this.btvHolder);
        this.btvHolder.setLayout(btvHolderLayout);
        btvHolderLayout.setHorizontalGroup(btvHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 369, Short.MAX_VALUE));
        btvHolderLayout.setVerticalGroup(btvHolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.btvHolder);
        this.jScrollPane1.setBorder(null);
        this.descriptionPanel.setEditable(false);
        this.descriptionPanel.setContentType(NbBundle.getMessage(AnalysisResultTopComponent.class, "AnalysisResultTopComponent.descriptionPanel.contentType"));
        this.descriptionPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.jScrollPane1.setViewportView(this.descriptionPanel);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jToolBar1.setBorder(new VariableRightBorder());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/analysis/ui/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getBundle(AnalysisResultTopComponent.class).getString("AnalysisResultTopComponent.refreshButton.toolTipText"));
        this.refreshButton.setBorderPainted(false);
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisResultTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.refreshButton);
        this.previousError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/analysis/ui/resources/prevmatch.png")));
        this.previousError.setToolTipText(NbBundle.getBundle(AnalysisResultTopComponent.class).getString("AnalysisResultTopComponent.previousError.toolTipText"));
        this.previousError.setBorderPainted(false);
        this.previousError.setFocusable(false);
        this.previousError.setHorizontalTextPosition(0);
        this.previousError.setMaximumSize(new Dimension(24, 24));
        this.previousError.setMinimumSize(new Dimension(24, 24));
        this.previousError.setPreferredSize(new Dimension(24, 24));
        this.previousError.setVerticalTextPosition(3);
        this.previousError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisResultTopComponent.this.previousErrorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.previousError);
        this.nextError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/analysis/ui/resources/nextmatch.png")));
        this.nextError.setToolTipText(NbBundle.getBundle(AnalysisResultTopComponent.class).getString("AnalysisResultTopComponent.nextError.toolTipText"));
        this.nextError.setBorderPainted(false);
        this.nextError.setFocusable(false);
        this.nextError.setHorizontalTextPosition(0);
        this.nextError.setMaximumSize(new Dimension(24, 24));
        this.nextError.setMinimumSize(new Dimension(24, 24));
        this.nextError.setPreferredSize(new Dimension(24, 24));
        this.nextError.setVerticalTextPosition(3);
        this.nextError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisResultTopComponent.this.nextErrorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.nextError);
        this.byCategory.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/analysis/ui/resources/categorize.png")));
        Mnemonics.setLocalizedText(this.byCategory, NbBundle.getMessage(AnalysisResultTopComponent.class, "AnalysisResultTopComponent.byCategory.text"));
        this.byCategory.setToolTipText(NbBundle.getMessage(AnalysisResultTopComponent.class, "BTN_Categorize"));
        this.byCategory.setBorderPainted(false);
        this.byCategory.setFocusable(false);
        this.byCategory.setHorizontalTextPosition(0);
        this.byCategory.setMaximumSize(new Dimension(24, 24));
        this.byCategory.setMinimumSize(new Dimension(24, 24));
        this.byCategory.setPreferredSize(new Dimension(24, 24));
        this.byCategory.setVerticalTextPosition(3);
        this.byCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisResultTopComponent.this.byCategoryActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.byCategory);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, 556, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        RunAnalysis.showDialogAndRunAnalysis(this.context, this.dialogState);
    }

    private void nextErrorActionPerformed(ActionEvent evt) {
        this.nextAction.actionPerformed(null);
    }

    private void previousErrorActionPerformed(ActionEvent evt) {
        this.prevAction.actionPerformed(null);
    }

    private void byCategoryActionPerformed(ActionEvent evt) {
        this.manager.setRootContext(Nodes.constructSemiLogicalView(this.analysisResult, this.byCategory.isSelected()));
        this.updatePrevNextButtonsForNewRootContext();
    }

    private void jSplitPane1ComponentResized(ComponentEvent evt) {
        this.jSplitPane1.setDividerLocation(0.5);
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void setData(Lookup context, RunAnalysisPanel.DialogState dialogState, AnalysisResult analysisResult) {
        this.context = context;
        this.dialogState = dialogState;
        this.analysisResult = analysisResult;
        this.manager.setRootContext(Nodes.constructSemiLogicalView(analysisResult, this.byCategory.isSelected()));
        if (this.btv != null) {
            this.btv.expandAll();
        }
        this.refreshButton.setEnabled(context != Lookup.EMPTY);
        this.updatePrevNextButtonsForNewRootContext();
    }

    private void updatePrevNextButtonsForNewRootContext() {
        this.descriptionPanel.setText(null);
        this.selectOnEnable = !this.analysisResult.provider2Hints.isEmpty() && !this.byCategory.isSelected();
    }

    public static synchronized AnalysisResultTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win instanceof AnalysisResultTopComponent) {
            return (AnalysisResultTopComponent)win;
        }
        if (win == null) {
            Logger.getLogger(AnalysisResultTopComponent.class.getName()).warning("Cannot find AnalysisResultTopComponent component. It will not be located properly in the window system.");
        } else {
            Logger.getLogger(AnalysisResultTopComponent.class.getName()).warning("There seem to be multiple components with the 'AnalysisResultTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        }
        AnalysisResultTopComponent result = new AnalysisResultTopComponent();
        Mode outputMode = WindowManager.getDefault().findMode("output");
        if (outputMode != null) {
            outputMode.dockInto(result);
        }
        return result;
    }

    private class PCLImpl
    implements PropertyChangeListener {
        private PCLImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == null || "enabled".equals(name)) {
                AnalysisResultTopComponent.this.previousError.setEnabled(AnalysisResultTopComponent.this.prevAction.isEnabled());
                AnalysisResultTopComponent.this.nextError.setEnabled(AnalysisResultTopComponent.this.nextAction.isEnabled());
                if (AnalysisResultTopComponent.this.selectOnEnable && evt.getSource() == AnalysisResultTopComponent.this.nextAction && AnalysisResultTopComponent.this.nextAction.isEnabled()) {
                    AnalysisResultTopComponent.this.selectOnEnable = false;
                    AnalysisResultTopComponent.this.nextAction.actionPerformed(null);
                }
                AnalysisResultTopComponent.this.selectOnEnable = false;
            }
        }
    }

    private class VariableRightBorder
    implements Border {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            g.setColor(this.getColor());
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
            g.setColor(old);
        }

        public Color getColor() {
            if (Utilities.isMac()) {
                Color c1 = UIManager.getColor("controlShadow");
                Color c2 = UIManager.getColor("control");
                return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
            }
            return UIManager.getColor("controlShadow");
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

