/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.openide.nodes.CookieSet;
import org.openide.nodes.CookieSetLkp;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;

final class NodeLookup
extends AbstractLookup {
    static final ThreadLocal<Node> NO_COOKIE_CHANGE = new ThreadLocal();
    private final AggregatingExecutor EXECUTOR = new AggregatingExecutor();
    private Collection<Class> queriedCookieClasses = new ArrayList<Class>();
    private Node node;

    public NodeLookup(Node n) {
        this.node = n;
        this.addPair(new CookieSetLkp.SimpleItem<Node>(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void addCookie(Node node, Class<?> c, Collection<AbstractLookup.Pair> collection, Map<AbstractLookup.Pair, Class> fromPairToClass) {
        Collection<AbstractLookup.Pair> pairs;
        Object res;
        Object prev = CookieSet.entryQueryMode(c);
        try {
            Class<?> fake = c;
            res = node.getCookie(fake);
        }
        finally {
            pairs = CookieSet.exitQueryMode(prev);
        }
        if (pairs == null) {
            void var8_12;
            if (res == null) {
                return;
            }
            CookieSetLkp.SimpleItem orig = new CookieSetLkp.SimpleItem(res);
            if (res instanceof Node) {
                CookieSetLkp.SimpleItem simpleItem = orig;
            } else {
                CookieSet.PairWrap pairWrap = new CookieSet.PairWrap(orig);
            }
            pairs = Collections.singleton(var8_12);
        }
        collection.addAll(pairs);
        for (AbstractLookup.Pair pair : pairs) {
            Class oldClazz = fromPairToClass.get(pair);
            if (oldClazz != null && !c.isAssignableFrom(oldClazz)) continue;
            fromPairToClass.put(pair, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template template) {
        Class type = template.getType();
        Set<Node> nds = Node.blockEvents();
        try {
            this.blockingBeforeLookup(type);
        }
        finally {
            Node.unblockEvents(nds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingBeforeLookup(Class<?> type) {
        if (type == Object.class) {
            Set all;
            Object prev = null;
            try {
                prev = CookieSet.entryAllClassesMode();
                Node.Cookie cookie = this.node.getCookie(Node.Cookie.class);
            }
            finally {
                all = CookieSet.exitAllClassesMode(prev);
            }
            for (Class c : all) {
                this.updateLookupAsCookiesAreChanged(c);
            }
            if (!this.queriedCookieClasses.contains(Node.Cookie.class)) {
                this.updateLookupAsCookiesAreChanged(Node.Cookie.class);
            }
        }
        if (!this.queriedCookieClasses.contains(type)) {
            this.updateLookupAsCookiesAreChanged(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookupAsCookiesAreChanged(Class toAdd) {
        Iterator<Class> it;
        LinkedHashMap<AbstractLookup.Pair, Class> fromPairToQueryClass;
        LinkedHashSet<AbstractLookup.Pair> instances;
        NodeLookup nodeLookup = this;
        synchronized (nodeLookup) {
            if (toAdd != null) {
                if (this.queriedCookieClasses.contains(toAdd)) {
                    return;
                }
                this.queriedCookieClasses.add(toAdd);
            }
            instances = new LinkedHashSet<AbstractLookup.Pair>(this.queriedCookieClasses.size());
            fromPairToQueryClass = new LinkedHashMap<AbstractLookup.Pair, Class>();
            it = new ArrayList<Class>(this.queriedCookieClasses).iterator();
            CookieSetLkp.SimpleItem<Node> nodePair = new CookieSetLkp.SimpleItem<Node>(this.node);
            instances.add(nodePair);
            fromPairToQueryClass.put(nodePair, Node.class);
        }
        while (it.hasNext()) {
            Class c = it.next();
            NodeLookup.addCookie(this.node, c, instances, fromPairToQueryClass);
        }
        final LinkedHashMap<AbstractLookup.Pair, Class> m = fromPairToQueryClass;
        ArrayList<AbstractLookup.Pair> list = new ArrayList<AbstractLookup.Pair>(instances);
        class Cmp
        implements Comparator<AbstractLookup.Pair> {
            Cmp() {
            }

            @Override
            public int compare(AbstractLookup.Pair p1, AbstractLookup.Pair p2) {
                Class c1 = (Class)m.get(p1);
                Class c2 = (Class)m.get(p2);
                assert (c1 != null) : p1 + " not in " + m;
                assert (c2 != null) : p2 + " not in " + m;
                if (c1 == c2) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(p2.getType())) {
                    return -1;
                }
                if (c2.isAssignableFrom(p1.getType())) {
                    return 1;
                }
                return 0;
            }
        }
        list.sort(new Cmp());
        if (toAdd == null) {
            this.setPairs(list);
        } else {
            Node prev = NO_COOKIE_CHANGE.get();
            try {
                NO_COOKIE_CHANGE.set(this.node);
                this.setPairs(list, this.EXECUTOR);
            }
            finally {
                NO_COOKIE_CHANGE.set(prev);
            }
        }
    }

    private static class AggregatingExecutor
    implements Executor,
    Runnable {
        ArrayList<Runnable> list = new ArrayList();
        private boolean scheduled = false;

        private AggregatingExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            if (EventQueue.isDispatchThread()) {
                this.list.add(command);
                if (!this.scheduled) {
                    this.scheduled = true;
                    EventQueue.invokeLater(this);
                }
            } else {
                command.run();
            }
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            for (Runnable r : this.list) {
                r.run();
            }
            this.list = new ArrayList();
            this.scheduled = false;
        }
    }
}

