/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints.support;

import java.util.Collections;
import java.util.Set;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.Parameters;

public final class FixFactory {
    private FixFactory() {
    }

    public static final Fix addModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, String text) {
        Parameters.notNull("compilationInfo", compilationInfo);
        Parameters.notNull("treePath", treePath);
        Parameters.notNull("toAdd", toAdd);
        Parameters.notNull("text", text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, toAdd, Collections.emptySet(), text);
    }

    public static final Fix removeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toRemove, String text) {
        Parameters.notNull("compilationInfo", compilationInfo);
        Parameters.notNull("treePath", treePath);
        Parameters.notNull("toRemove", toRemove);
        Parameters.notNull("text", text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, Collections.emptySet(), toRemove, text);
    }

    public static final Fix changeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
        Parameters.notNull("compilationInfo", compilationInfo);
        Parameters.notNull("treePath", treePath);
        Parameters.notNull("toAdd", toAdd);
        Parameters.notNull("toRemove", toRemove);
        Parameters.notNull("text", text);
        if (treePath.getLeaf().getKind() != Tree.Kind.MODIFIERS) {
            return null;
        }
        return new ChangeModifiersFixImpl(TreePathHandle.create(treePath, compilationInfo), toAdd, toRemove, text).toEditorFix();
    }

    private static final class ChangeModifiersFixImpl
    extends JavaFix {
        private final TreePathHandle modsHandle;
        private final Set<Modifier> toAdd;
        private final Set<Modifier> toRemove;
        private final String text;

        public ChangeModifiersFixImpl(TreePathHandle modsHandle, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
            super(modsHandle);
            this.modsHandle = modsHandle;
            this.toAdd = toAdd;
            this.toRemove = toRemove;
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            TreeMaker make = wc.getTreeMaker();
            ModifiersTree newMods = (ModifiersTree)path.getLeaf();
            for (Modifier a : this.toAdd) {
                newMods = make.addModifiersModifier(newMods, a);
            }
            for (Modifier r : this.toRemove) {
                newMods = make.removeModifiersModifier(newMods, r);
            }
            wc.rewrite(path.getLeaf(), newMods);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChangeModifiersFixImpl other = (ChangeModifiersFixImpl)obj;
            if (!(this.modsHandle == other.modsHandle || this.modsHandle != null && this.modsHandle.equals(other.modsHandle))) {
                return false;
            }
            if (!(this.toAdd == other.toAdd || this.toAdd != null && this.toAdd.equals(other.toAdd))) {
                return false;
            }
            return this.toRemove == other.toRemove || this.toRemove != null && this.toRemove.equals(other.toRemove);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + (this.modsHandle != null ? this.modsHandle.hashCode() : 0);
            hash = 71 * hash + (this.toAdd != null ? this.toAdd.hashCode() : 0);
            hash = 71 * hash + (this.toRemove != null ? this.toRemove.hashCode() : 0);
            return hash;
        }
    }
}

