/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.impl.indexing.implspi.CacheFolderProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class DefaultCacheFolderProvider
extends CacheFolderProvider {
    private static final int SLIDING_WINDOW = 500;
    private static final String SEGMENTS_FILE = "segments";
    private static final String SLICE_PREFIX = "s";
    private static final Logger LOG = Logger.getLogger(DefaultCacheFolderProvider.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DefaultCacheFolderProvider.class.getName(), 1, false, false);
    private static final DefaultCacheFolderProvider INSTANCE = new DefaultCacheFolderProvider();
    private final RequestProcessor.Task saver = RP.create(new Saver());
    private FileObject cacheFolder;
    private Properties segments;
    private Map<String, String> invertedSegments;
    private int index = 0;

    private DefaultCacheFolderProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    protected FileObject findCacheFolderForRoot(@NonNull URL root, @NonNull Set<CacheFolderProvider.Kind> kinds, @NonNull CacheFolderProvider.Mode mode) throws IOException {
        Object slice;
        String rootName = root.toExternalForm();
        FileObject _cacheFolder = this.getCacheFolder();
        DefaultCacheFolderProvider defaultCacheFolderProvider = this;
        synchronized (defaultCacheFolderProvider) {
            this.loadSegments(_cacheFolder);
            slice = this.invertedSegments.get(rootName);
            if (slice == null) {
                if (mode == CacheFolderProvider.Mode.EXISTENT) {
                    return null;
                }
                slice = SLICE_PREFIX + ++this.index;
                while (this.segments.getProperty((String)slice) != null) {
                    slice = SLICE_PREFIX + ++this.index;
                }
                this.segments.put(slice, rootName);
                this.invertedSegments.put(rootName, (String)slice);
                this.saver.schedule(500);
            }
        }
        assert (slice != null);
        if (mode == CacheFolderProvider.Mode.EXISTENT) {
            return this.cacheFolder.getFileObject((String)slice);
        }
        return FileUtil.createFolder(_cacheFolder, (String)slice);
    }

    @Override
    @CheckForNull
    protected synchronized URL findRootForCacheFolder(FileObject folder) throws IOException {
        FileObject segFolder = folder.getParent();
        if (segFolder == null || !segFolder.equals(this.cacheFolder)) {
            return null;
        }
        String source = this.segments.getProperty(folder.getName());
        if (source != null) {
            return new URL(source);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectRootsInFolder(@NonNull URL folder, @NonNull Collection<? super URL> collector) throws IOException {
        HashMap<String, String> isdc;
        String prefix = folder.toExternalForm();
        DefaultCacheFolderProvider defaultCacheFolderProvider = this;
        synchronized (defaultCacheFolderProvider) {
            FileObject fileObject = this.getCacheFolder();
            this.loadSegments(fileObject);
            isdc = new HashMap<String, String>(this.invertedSegments);
        }
        for (Map.Entry entry : isdc.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            collector.add(new URL((String)entry.getKey()));
        }
    }

    public static DefaultCacheFolderProvider getInstance() {
        return INSTANCE;
    }

    @NonNull
    synchronized FileObject getCacheFolder() {
        if (this.cacheFolder == null) {
            File cache = Places.getCacheSubdirectory("index");
            if (!cache.isDirectory()) {
                throw new IllegalStateException("Indices cache folder " + cache.getAbsolutePath() + " is not a folder");
            }
            if (!cache.canRead()) {
                throw new IllegalStateException("Can't read from indices cache folder " + cache.getAbsolutePath());
            }
            if (!cache.canWrite()) {
                throw new IllegalStateException("Can't write to indices cache folder " + cache.getAbsolutePath());
            }
            this.cacheFolder = FileUtil.toFileObject(cache);
            if (this.cacheFolder == null) {
                throw new IllegalStateException("Can't convert indices cache folder " + cache.getAbsolutePath() + " to FileObject");
            }
        }
        return this.cacheFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCacheFolder(@NonNull FileObject folder) {
        this.saver.schedule(0);
        this.saver.waitFinished();
        DefaultCacheFolderProvider defaultCacheFolderProvider = this;
        synchronized (defaultCacheFolderProvider) {
            assert (folder != null && folder.canRead() && folder.canWrite());
            this.cacheFolder = folder;
            this.segments = null;
            this.invertedSegments = null;
            this.index = 0;
        }
    }

    @SuppressWarnings(value={"LI_LAZY_INIT_UPDATE_STATIC"}, justification="Caller already holds a monitor")
    private void loadSegments(@NonNull FileObject folder) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.segments == null) {
            assert (folder != null);
            this.segments = new Properties();
            this.invertedSegments = new HashMap<String, String>();
            FileObject segmentsFile = folder.getFileObject(SEGMENTS_FILE);
            if (segmentsFile != null) {
                try (InputStream in = segmentsFile.getInputStream();){
                    this.segments.load(in);
                }
            }
            for (Map.Entry<Object, Object> entry : this.segments.entrySet()) {
                String segment = (String)entry.getKey();
                String root = (String)entry.getValue();
                this.invertedSegments.put(root, segment);
                try {
                    this.index = Math.max(this.index, Integer.parseInt(segment.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.FINE, null, nfe);
                }
            }
        }
    }

    private void storeSegments(@NonNull FileObject folder) throws IOException {
        assert (Thread.holdsLock(this));
        assert (folder != null);
        File _file = FileUtil.toFile(folder);
        assert (_file != null);
        FileObject segmentsFile = FileUtil.createData(new File(_file, SEGMENTS_FILE));
        try (OutputStream out = segmentsFile.getOutputStream();){
            this.segments.store(out, null);
        }
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        @Override
        public void run() {
            try {
                final FileObject cf = DefaultCacheFolderProvider.this.getCacheFolder();
                cf.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws IOException {
                        DefaultCacheFolderProvider defaultCacheFolderProvider = DefaultCacheFolderProvider.this;
                        synchronized (defaultCacheFolderProvider) {
                            if (DefaultCacheFolderProvider.this.segments == null) {
                                return;
                            }
                            DefaultCacheFolderProvider.this.storeSegments(cf);
                        }
                    }
                });
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
        }
    }
}

