/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TypeParameterTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.TypeParameterElement;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import jpt30.tools.Diagnostic;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.suggestions.NameAndPackagePanel;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CreateSubclass {
    static String[] overrideNameAndPackage;

    public static ErrorDescription check(HintContext context) {
        ClassPath cp;
        FileObject root;
        TypeElement typeElement;
        TreePath tp = context.getPath();
        ClassTree cls = (ClassTree)tp.getLeaf();
        CompilationInfo info = context.getInfo();
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        long startPos = sourcePositions.getStartPosition(tp.getCompilationUnit(), cls);
        if (startPos > Integer.MAX_VALUE) {
            return null;
        }
        int[] bodySpan = info.getTreeUtilities().findBodySpan(cls);
        if (bodySpan == null || (long)bodySpan[0] <= startPos) {
            return null;
        }
        int caret = context.getCaretLocation();
        if (startPos < 0L || caret < 0 || (long)caret < startPos || caret >= bodySpan[0]) {
            return null;
        }
        List<Diagnostic> errors = info.getDiagnostics();
        if (!errors.isEmpty()) {
            for (Diagnostic d : errors) {
                if (d.getKind() != Diagnostic.Kind.ERROR || startPos > d.getStartPosition() || d.getStartPosition() > (long)bodySpan[0]) continue;
                return null;
            }
        }
        if ((typeElement = (TypeElement)info.getTrees().getElement(tp)) == null || typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        Element outer = typeElement.getEnclosingElement();
        if (outer != null && outer.getKind() != ElementKind.PACKAGE && outer.getKind() != ElementKind.INTERFACE) {
            if (outer.getKind() != ElementKind.CLASS && outer.getKind() != ElementKind.ENUM) {
                return null;
            }
            if (!typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
                return null;
            }
        }
        if ((root = (cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE)).findOwnerRoot(info.getFileObject())) == null) {
            return null;
        }
        PackageElement packageElement = (PackageElement)info.getElementUtilities().outermostTypeElement(typeElement).getEnclosingElement();
        CreateSubclassFix fix = new CreateSubclassFix(info, root, packageElement.getQualifiedName().toString(), typeElement.getSimpleName().toString() + "Impl", typeElement);
        return ErrorDescriptionFactory.forTree(context, context.getPath(), NbBundle.getMessage(CreateSubclass.class, typeElement.getKind() == ElementKind.CLASS ? (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT) ? "ERR_ImplementAbstractClass" : "ERR_CreateSubclass") : "ERR_ImplementInterface"), fix);
    }

    private static final class CreateSubclassFix
    implements Fix,
    PropertyChangeListener {
        private FileObject targetSourceRoot;
        private String packageName;
        private String simpleName;
        private ElementHandle<TypeElement> superType;
        private boolean isAbstract;
        private boolean hasNonDefaultConstructor = false;
        private FileObject target = null;

        public CreateSubclassFix(CompilationInfo info, FileObject targetSourceRoot, String packageName, String simpleName, TypeElement typeElement) {
            this.targetSourceRoot = targetSourceRoot;
            this.packageName = packageName;
            this.simpleName = simpleName;
            this.isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
            this.superType = ElementHandle.create(typeElement);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(CreateSubclass.class, this.superType.getKind() == ElementKind.CLASS ? (this.isAbstract ? "FIX_ImplementAbstractClass" : "FIX_CreateSubclass") : "FIX_ImplementInterface");
        }

        @Override
        public ChangeInfo implement() throws Exception {
            return IndexingManager.getDefault().runProtected(new Callable<ChangeInfo>(){

                @Override
                public ChangeInfo call() throws Exception {
                    if (overrideNameAndPackage == null) {
                        NameAndPackagePanel panel = new NameAndPackagePanel(targetSourceRoot, superType, simpleName, packageName);
                        final DialogDescriptor desc = new DialogDescriptor(panel, this.getText());
                        final NotificationLineSupport nls = desc.createNotificationLineSupport();
                        panel.setErrorListener(new NameAndPackagePanel.ErrorListener(){

                            @Override
                            public void setErrorMessage(String errorMessage) {
                                nls.setErrorMessage(errorMessage);
                                desc.setValid(errorMessage == null);
                            }
                        });
                        panel.checkValid();
                        if (DialogDisplayer.getDefault().notify(desc) != DialogDescriptor.OK_OPTION) {
                            return null;
                        }
                        simpleName = panel.getClassName();
                        packageName = panel.getPackageName();
                    } else {
                        simpleName = overrideNameAndPackage[0];
                        packageName = overrideNameAndPackage[1];
                    }
                    EditorRegistry.addPropertyChangeListener(this);
                    final String path = packageName.replace('.', '/') + "/" + simpleName + ".java";
                    target = targetSourceRoot.getFileObject(path);
                    JavaSource js = target != null ? JavaSource.forFileObject(target) : JavaSource.create(ClasspathInfo.create(targetSourceRoot), new FileObject[0]);
                    ModificationResult result = js.runModificationTask(new Task<WorkingCopy>(){

                        @Override
                        public void run(WorkingCopy parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement superTypeElement = superType.resolve(parameter);
                            if (superTypeElement != null) {
                                TreeMaker make = parameter.getTreeMaker();
                                ArrayList<TypeParameterTree> typeParameters = new ArrayList<TypeParameterTree>();
                                TypeElement jlObjectElement = parameter.getElements().getTypeElement("java.lang.Object");
                                TypeMirror jlObjectType = jlObjectElement != null ? jlObjectElement.asType() : null;
                                for (TypeParameterElement typeParameterElement : superTypeElement.getTypeParameters()) {
                                    ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
                                    for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                                        if (jlObjectType != null && parameter.getTypes().isSameType(typeMirror, jlObjectType)) continue;
                                        bounds.add((ExpressionTree)make.Type(typeMirror));
                                    }
                                    typeParameters.add(make.TypeParameter(typeParameterElement.getSimpleName(), bounds));
                                }
                                CompilationUnitTree cut = parameter.getFileObject() != null ? parameter.getCompilationUnit() : GeneratorUtilities.get(parameter).createFromTemplate(targetSourceRoot, path, ElementKind.CLASS);
                                ClassTree classTree = (ClassTree)cut.getTypeDecls().get(0);
                                if (superTypeElement.getKind() == ElementKind.CLASS) {
                                    Element el = parameter.getTrees().getElement(TreePath.getPath(cut, (Tree)classTree));
                                    if (el instanceof TypeElement) {
                                        TypeMirror sup = ((TypeElement)el).getSuperclass();
                                        if (!parameter.getTypes().isSubtype(superTypeElement.asType(), sup)) {
                                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CreateSubclass.class, "ERR_IncompatibleSupertype", el.getSimpleName()));
                                            Toolkit.getDefaultToolkit().beep();
                                            return;
                                        }
                                    }
                                    parameter.rewrite(classTree, make.Class(classTree.getModifiers(), simpleName, typeParameters, make.Type(superTypeElement.asType()), classTree.getImplementsClause(), classTree.getPermitsClause(), classTree.getMembers()));
                                    for (ExecutableElement executableElement : ElementFilter.constructorsIn(superTypeElement.getEnclosedElements())) {
                                        if (executableElement.getParameters().isEmpty()) continue;
                                        hasNonDefaultConstructor = true;
                                        break;
                                    }
                                } else {
                                    List<? extends Tree> impls = classTree.getImplementsClause();
                                    ArrayList<? extends Tree> newImpls = new ArrayList<Tree>(impls.size() + 1);
                                    newImpls.addAll(impls);
                                    newImpls.add(make.Type(superTypeElement.asType()));
                                    parameter.rewrite(classTree, make.Class(classTree.getModifiers(), classTree.getSimpleName(), typeParameters, classTree.getExtendsClause(), newImpls, classTree.getPermitsClause(), classTree.getMembers()));
                                }
                                if (parameter.getFileObject() == null) {
                                    parameter.rewrite(null, cut);
                                }
                            }
                        }
                    });
                    result.commit();
                    if (!hasNonDefaultConstructor && !isAbstract) {
                        EditorRegistry.removePropertyChangeListener(this);
                    }
                    if (target == null) {
                        Iterator<File> it = result.getNewFiles().iterator();
                        target = it.hasNext() ? FileUtil.toFileObject(it.next()) : null;
                    }
                    return target != null ? new ChangeInfo(target, null, null) : null;
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FileObject fo;
            final JTextComponent component = EditorRegistry.focusedComponent();
            FileObject fileObject = fo = component != null ? NbEditorUtilities.getFileObject(component.getDocument()) : null;
            if (this.target == null || this.target != fo) {
                return;
            }
            EditorRegistry.removePropertyChangeListener(this);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaSource js = JavaSource.forDocument(component.getDocument());
                        js.runModificationTask(new Task<WorkingCopy>(){

                            @Override
                            public void run(WorkingCopy parameter) throws Exception {
                                parameter.toPhase(JavaSource.Phase.RESOLVED);
                                CompilationUnitTree cut = parameter.getCompilationUnit();
                                if (!cut.getTypeDecls().isEmpty()) {
                                    TreePath path = TreePath.getPath(cut, cut.getTypeDecls().get(0));
                                    if (isAbstract) {
                                        GeneratorUtils.generateAllAbstractMethodImplementations(parameter, path);
                                    }
                                    if (hasNonDefaultConstructor) {
                                        ConstructorGenerator.Factory factory = new ConstructorGenerator.Factory();
                                        Iterator<? extends CodeGenerator> generators = factory.create(Lookups.fixed(component, parameter, path)).iterator();
                                        if (generators.hasNext()) {
                                            generators.next().invoke();
                                        }
                                    }
                                }
                            }
                        }).commit();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

