/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BindingPatternTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.ConditionalExpressionTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.PatternCaseLabelTree;
import jpt.sun.source.tree.SwitchExpressionTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ThrowableNotThrown {
    public static ErrorDescription newThrowable(HintContext ctx) {
        TreePath enclosingMethodPath = ThrowableNotThrown.findEnclosingMethodPath(ctx.getPath());
        if (enclosingMethodPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
            return null;
        }
        ThrowableTracer tracer = new ThrowableTracer(ctx.getInfo(), enclosingMethodPath);
        if (!tracer.traceThrowable(ctx.getPath())) {
            return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_ThrowableNotThrown(), new Fix[0]);
        }
        return null;
    }

    private static TreePath findEnclosingMethodPath(TreePath path) {
        Tree.Kind kind;
        TreePath enclosingMethodPath = path;
        TreePath nextPath = enclosingMethodPath.getParentPath();
        do {
            Tree leaf = nextPath.getLeaf();
            enclosingMethodPath = nextPath;
            nextPath = nextPath.getParentPath();
            kind = leaf.getKind();
        } while (nextPath != null && kind != Tree.Kind.METHOD && kind != Tree.Kind.CLASS);
        return enclosingMethodPath;
    }

    public static ErrorDescription methodInvocation(HintContext ctx) {
        TreePath p = ctx.getPath();
        if (p.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(p);
        TypeElement el = ctx.getInfo().getElements().getTypeElement("java.lang.Throwable");
        if (el == null || !Utilities.isValidType(tm)) {
            return null;
        }
        TypeMirror b = el.asType();
        if (!Utilities.isValidType(b) || !ctx.getInfo().getTypes().isAssignable(tm, b)) {
            return null;
        }
        ExecutableElement initCause = (ExecutableElement)ctx.getInfo().getElementUtilities().findElement("java.lang.Throwable.initCause(java.lang.Throwable)");
        if (initCause != null) {
            Element e = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$m"));
            if (e == null || e.getKind() != ElementKind.CONSTRUCTOR && e.getKind() != ElementKind.METHOD) {
                return null;
            }
            ExecutableElement thisMethod = (ExecutableElement)e;
            if (thisMethod == initCause || ctx.getInfo().getElements().overrides(thisMethod, initCause, el)) {
                return null;
            }
        }
        TreePath enclosingMethodPath = ThrowableNotThrown.findEnclosingMethodPath(ctx.getPath());
        ThrowableTracer tracer = new ThrowableTracer(ctx.getInfo(), enclosingMethodPath);
        if (!tracer.traceThrowable(ctx.getPath())) {
            return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_ThrowableValueNotThrown(), new Fix[0]);
        }
        return null;
    }

    private static class ThrowableTracer {
        private final CompilationInfo info;
        private Flow.FlowResult flowResult;
        private final TreePath enclosingMethodPath;
        private Set<Tree> varAssignments = new HashSet<Tree>();
        private Set<Tree> processedVariables = new HashSet<Tree>();

        public ThrowableTracer(CompilationInfo info, TreePath enclosingMethodPath) {
            this.info = info;
            this.enclosingMethodPath = enclosingMethodPath;
        }

        private Collection<Tree> getNewAssignments() {
            if (this.processedVariables.isEmpty()) {
                Set<Tree> x = this.processedVariables;
                this.processedVariables = this.varAssignments;
                this.varAssignments = x;
                return this.processedVariables;
            }
            HashSet<Tree> nue = new HashSet<Tree>(this.varAssignments);
            nue.removeAll(this.processedVariables);
            this.processedVariables.addAll(this.varAssignments);
            this.varAssignments.clear();
            return nue;
        }

        private Boolean processVariables() {
            Collection<Tree> vars = this.getNewAssignments();
            if (vars.isEmpty()) {
                return Boolean.FALSE;
            }
            Flow.FlowResult r = this.getFlowResult();
            for (Tree t : vars) {
                Collection<Tree> usages = r.getValueUsers(t);
                if (usages == null) continue;
                for (Tree u : usages) {
                    Boolean result;
                    TreePath pu = r.findPath(u, this.info.getCompilationUnit());
                    if (pu == null || (result = this.processEnclosingStatement(pu)) != Boolean.TRUE) continue;
                    return result;
                }
            }
            return null;
        }

        private Flow.FlowResult getFlowResult() {
            if (this.flowResult == null) {
                this.flowResult = Flow.assignmentsForUse(this.info, this.enclosingMethodPath, new AtomicBoolean(false));
            }
            return this.flowResult;
        }

        boolean traceThrowable(TreePath path) {
            Boolean b = this.processEnclosingStatement(path);
            if (b != null) {
                return b;
            }
            while ((b = this.processVariables()) == null) {
            }
            return b;
        }

        Boolean processEnclosingStatement(TreePath excPath) {
            boolean process;
            Tree prevLeaf = excPath.getLeaf();
            do {
                excPath = excPath.getParentPath();
                Tree leaf = excPath.getLeaf();
                Tree.Kind kind = leaf.getKind();
                process = false;
                switch (kind) {
                    case THROW: {
                        return true;
                    }
                    case FOR_LOOP: {
                        if (prevLeaf != ((ForLoopTree)leaf).getCondition()) break;
                        return true;
                    }
                    case IF: 
                    case WHILE_LOOP: 
                    case DO_WHILE_LOOP: 
                    case RETURN: {
                        return true;
                    }
                    case LAMBDA_EXPRESSION: {
                        process = true;
                        break;
                    }
                    case VARIABLE: {
                        VariableTree var = (VariableTree)leaf;
                        Element el = this.info.getTrees().getElement(new TreePath(excPath, var));
                        if (el == null || el.getKind() == ElementKind.FIELD) {
                            return true;
                        }
                        if (el.getKind() == ElementKind.LOCAL_VARIABLE) {
                            this.varAssignments.add(var.getInitializer());
                        }
                        process = true;
                        break;
                    }
                    case AND_ASSIGNMENT: 
                    case OR_ASSIGNMENT: 
                    case XOR_ASSIGNMENT: 
                    case ASSIGNMENT: {
                        AssignmentTree as = (AssignmentTree)leaf;
                        ExpressionTree var = as.getVariable();
                        Element el = this.info.getTrees().getElement(new TreePath(excPath, var));
                        if (el == null || el.getKind() == ElementKind.FIELD) {
                            return true;
                        }
                        if (Flow.LOCAL_VARIABLES.contains((Object)el.getKind())) {
                            this.varAssignments.add(as.getExpression());
                        }
                        process = true;
                        break;
                    }
                    case MEMBER_SELECT: {
                        Element el = this.info.getTrees().getElement(excPath);
                        if (el == null) {
                            return true;
                        }
                        if (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR) {
                            ExecutableElement xel = (ExecutableElement)el;
                            TypeMirror tm = xel.getReturnType();
                            if (!Utilities.isValidType(tm) || tm.getKind() == TypeKind.VOID) {
                                return true;
                            }
                            Tree.Kind k = excPath.getParentPath().getLeaf().getKind();
                            if (k == Tree.Kind.NEW_CLASS || k == Tree.Kind.METHOD_INVOCATION) {
                                return true;
                            }
                        }
                        process = true;
                        break;
                    }
                    case METHOD_INVOCATION: {
                        MethodInvocationTree invTree = (MethodInvocationTree)leaf;
                        return invTree.getArguments().contains(prevLeaf);
                    }
                    case NEW_CLASS: {
                        NewClassTree nct = (NewClassTree)leaf;
                        return nct.getArguments().contains(prevLeaf);
                    }
                    case LOGICAL_COMPLEMENT: 
                    case CONDITIONAL_AND: 
                    case CONDITIONAL_OR: 
                    case EQUAL_TO: 
                    case NOT_EQUAL_TO: 
                    case INSTANCE_OF: 
                    case PARENTHESIZED: 
                    case TYPE_CAST: {
                        process = true;
                        break;
                    }
                    case CONDITIONAL_EXPRESSION: {
                        ConditionalExpressionTree cond = (ConditionalExpressionTree)leaf;
                        process = cond.getTrueExpression() == prevLeaf || cond.getFalseExpression() == prevLeaf;
                        break;
                    }
                    case SWITCH: {
                        Tree st = (SwitchTree)leaf;
                        if (st.getExpression() != prevLeaf) break;
                        this.collectCaseBindings(st.getCases());
                        break;
                    }
                    case SWITCH_EXPRESSION: {
                        Tree st = (SwitchExpressionTree)leaf;
                        if (st.getExpression() != prevLeaf) break;
                        this.collectCaseBindings(st.getCases());
                        process = true;
                        break;
                    }
                }
                prevLeaf = excPath.getLeaf();
            } while (process);
            return this.varAssignments.isEmpty() ? Boolean.FALSE : null;
        }

        private void collectCaseBindings(List<? extends CaseTree> cases) {
            cases.stream().flatMap(cse -> cse.getLabels().stream()).filter(label -> label.getKind() == Tree.Kind.PATTERN_CASE_LABEL).map(label -> ((PatternCaseLabelTree)label).getPattern()).filter(pattern -> pattern.getKind() == Tree.Kind.BINDING_PATTERN).map(pattern -> ((BindingPatternTree)pattern).getVariable()).filter(var -> !var.getName().isEmpty()).forEach(this.varAssignments::add);
        }
    }
}

