/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.cache;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.style.Selector;
import org.apache.myfaces.trinidad.style.Style;
import org.apache.myfaces.trinidad.style.Styles;
import org.apache.myfaces.trinidad.util.Args;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SkinProperties;
import org.apache.myfaces.trinidadinternal.share.expl.Coercions;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleSheetNamingStrategy;
import org.apache.myfaces.trinidadinternal.style.UnmodifiableStyle;
import org.apache.myfaces.trinidadinternal.style.util.CSSGenerationUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.util.StableNameUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleWriterFactory;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public class FileSystemStyleCache
implements StyleProvider {
    private final String _targetPath;
    private StyleSheetDocument _document;
    private ConcurrentMap<UnmodifiableStyle, UnmodifiableStyle> _reusableStyleMap;
    private ConcurrentMap<String, Selector> _reusableSelectorMap;
    private ConcurrentMap<Key, Future<Entry>> _cache;
    private ConcurrentMap<Object, Entry> _entryCache;
    private Map<String, String> _shortStyleClassMap;
    private String[] _namespacePrefixes;
    private static final char _NAME_SEPARATOR = '-';
    private static final String _COMPRESSED = "cmp";
    private static final String _PORTLET = "prtl";
    private static final String _SECURE = "s";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _UTF8_ENCODING = "UTF8";
    private static final StyleSheetDocument _EMPTY_DOCUMENT = new StyleSheetDocument(null, null, -1L);
    private static final String _SHORT_CLASS_PREFIX = "x";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileSystemStyleCache.class);
    private static final Map<String, String> _STYLE_KEY_MAP = new HashMap<String, String>();
    private static final StyleSheetNode[] _EMPTY_STYLE_SHEET_NODE_ARRAY;
    private static final String[] _EMPTY_STRING_ARRAY;

    @Override
    public String getContentStyleType(StyleContext context) {
        return "text/css";
    }

    protected FileSystemStyleCache(String target) {
        File targetDirectory = new File(target);
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        this._targetPath = target;
    }

    @Override
    public List<String> getStyleSheetURIs(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return Collections.emptyList();
        }
        return entry.uris;
    }

    @Override
    public Styles getStyles(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.styles;
    }

    @Override
    public ConcurrentMap<Object, Object> getSkinProperties(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.skinProperties;
    }

    @Override
    public ConcurrentMap<String, Icon> getIcons(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.icons;
    }

    @Override
    public Map<String, String> getShortStyleClasses(StyleContext context) {
        return this._shortStyleClassMap;
    }

    protected StyleSheetDocument createStyleSheetDocument(StyleContext context) {
        return null;
    }

    protected boolean hasSourceDocumentChanged(StyleContext context) {
        return this._document == null;
    }

    protected String getTargetStyleSheetName(StyleContext context, StyleSheetDocument document) {
        boolean compressedStyles;
        if (context.getNamingStrategy() == StyleSheetNamingStrategy.STABLE) {
            return StableNameUtils.getContextName(context, document);
        }
        StringBuilder buffer = new StringBuilder();
        String contextName = NameUtils.getContextName(context, document);
        if (contextName != null && contextName.length() > 0) {
            buffer.append(contextName);
        }
        if (compressedStyles = this._isCompressStyles(context)) {
            if (contextName != null) {
                buffer.append('-');
            }
            buffer.append(_COMPRESSED);
        }
        if (context.isPortletMode()) {
            if (contextName != null || compressedStyles) {
                buffer.append('-');
            }
            buffer.append(_PORTLET);
        }
        if (context.isRequestSecure()) {
            buffer.append('-');
            buffer.append(_SECURE);
        }
        buffer.append(_CSS_EXTENSION);
        return buffer.toString();
    }

    protected ClearOnDirty getClearOnDirty() {
        return ClearOnDirty.ALL;
    }

    StyleSheetDocument __getStyleSheetDocument() {
        return this._document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry _getEntry(StyleContext context) {
        Entry entry;
        ConcurrentMap<Key, Future<Entry>> cache = null;
        ConcurrentMap<Object, Entry> entryCache = null;
        StyleSheetDocument document = null;
        Map<String, String> shortStyleClassMap = null;
        String[] namespacePrefixes = null;
        boolean isDirty = context.isDirty();
        boolean checkModified = context.checkStylesModified();
        FileSystemStyleCache fileSystemStyleCache = this;
        synchronized (fileSystemStyleCache) {
            if (isDirty || checkModified && this.hasSourceDocumentChanged(context)) {
                this._cache = null;
                this._entryCache = null;
                if (!isDirty || this.getClearOnDirty() == ClearOnDirty.ALL) {
                    this._document = null;
                    this._reusableStyleMap = null;
                    this._reusableSelectorMap = null;
                    this._shortStyleClassMap = null;
                    this._namespacePrefixes = null;
                } else {
                    isDirty = false;
                }
            }
            if (this._cache == null) {
                this._cache = new ConcurrentHashMap<Key, Future<Entry>>();
            }
            if (this._entryCache == null) {
                this._entryCache = new ConcurrentHashMap<Object, Entry>(19);
            }
            if (this._reusableStyleMap == null) {
                this._reusableStyleMap = new ConcurrentHashMap<UnmodifiableStyle, UnmodifiableStyle>();
            }
            if (this._reusableSelectorMap == null) {
                this._reusableSelectorMap = new ConcurrentHashMap<String, Selector>();
            }
            cache = this._cache;
            entryCache = this._entryCache;
            document = this._getStyleSheetDocument(context);
            if (document == null) {
                return null;
            }
            shortStyleClassMap = this._shortStyleClassMap;
            namespacePrefixes = this._namespacePrefixes;
        }
        Key key = new Key(context);
        if (_LOG.isFinest()) {
            _LOG.finest("FileSystemStyleCache's Key's hashCode is ", (Object)key.hashCode());
        }
        if ((entry = this._getEntry(context, document, cache, key, checkModified)) != null) {
            return entry;
        }
        DerivationKey derivationKey = this._getDerivationKey(context, document);
        entry = this._getCompatibleEntry(cache, key, derivationKey, entryCache, checkModified);
        if (entry != null) {
            return entry;
        }
        entry = this._createEntrySafely(context, document, cache, key, shortStyleClassMap, namespacePrefixes, checkModified, isDirty);
        entryCache.put(derivationKey, entry);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        Skin skin = arc.getSkin();
        skin.setDirty(false);
        return entry;
    }

    private Entry _getEntry(StyleContext context, StyleSheetDocument document, ConcurrentMap<Key, Future<Entry>> cache, Key key, boolean checkModified) {
        Future f = (Future)cache.get(key);
        Entry entry = this._getEntryFromFuture(context, document, cache, key, f);
        if (entry != null && !this._validateEntry(entry, checkModified)) {
            cache.remove(key, f);
            entry = null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry _getEntryFromFuture(StyleContext context, StyleSheetDocument document, ConcurrentMap<Key, Future<Entry>> cache, Key key, Future<Entry> f) {
        if (f == null) {
            return null;
        }
        boolean interrupted = Thread.interrupted();
        try {
            Entry entry = this._getEntryFromFutureWithRetry(f, 1);
            return entry;
        }
        catch (InterruptedException ie) {
            this._logAndRethrowEntryGetFailure(context, document, ie, "STYLE_ENTRY_RETRIEVAL_INTERRUPTED");
        }
        catch (ExecutionException ee) {
            cache.remove(key, f);
            this._logAndRethrowEntryGetFailure(context, document, ee, "STYLE_ENTRY_CREATION_FAILED");
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private Entry _getEntryFromFutureWithRetry(Future<Entry> f, int retryCount) throws InterruptedException, ExecutionException {
        Args.notNull(f, (String)"f");
        try {
            return f.get();
        }
        catch (InterruptedException ie) {
            if (retryCount > 0) {
                return this._getEntryFromFutureWithRetry(f, retryCount - 1);
            }
            throw ie;
        }
    }

    private void _logAndRethrowEntryGetFailure(StyleContext context, StyleSheetDocument document, Exception e, String message) {
        Args.notNull((Object)context, (String)"context");
        Args.notNull((Object)document, (String)"document");
        Args.notNull((Object)e, (String)"e");
        Args.notNull((Object)message, (String)"message");
        String targetName = this.getTargetStyleSheetName(context, document);
        _LOG.severe(message, (Object)targetName);
        _LOG.fine((Throwable)e);
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof Exception) {
            throw new IllegalStateException(cause);
        }
        throw new IllegalStateException(message);
    }

    private boolean _validateEntry(Entry entry, boolean checkModified) {
        Args.notNull((Object)entry, (String)"entry");
        boolean valid = true;
        if (checkModified) {
            List<String> uris = entry.uris;
            assert (uris != null && !uris.isEmpty());
            LinkedList<File> existing = new LinkedList<File>();
            for (String name : uris) {
                File file = new File(this._targetPath, name);
                if (file.exists()) {
                    existing.add(file);
                    continue;
                }
                valid = false;
            }
            if (!valid) {
                this._deleteAll(existing);
            }
        }
        return valid;
    }

    private Entry _createEntrySafely(final StyleContext context, final StyleSheetDocument document, ConcurrentMap<Key, Future<Entry>> cache, Key key, final Map<String, String> shortStyleClassMap, final String[] namespacePrefixes, final boolean checkModified, final boolean isDirty) {
        Callable<Entry> entryCreator = new Callable<Entry>(){

            @Override
            public Entry call() {
                return FileSystemStyleCache.this._createEntry(context, document, shortStyleClassMap, namespacePrefixes, checkModified, isDirty);
            }
        };
        FutureTask<Entry> ft = new FutureTask<Entry>(entryCreator);
        FutureTask<Entry> f = cache.putIfAbsent(key, ft);
        if (f == null) {
            f = ft;
            ft.run();
        }
        return this._getEntryFromFuture(context, document, cache, key, f);
    }

    private Selector _getSelector(String selectorString) {
        Selector cachedSelector = (Selector)this._reusableSelectorMap.get(selectorString);
        if (cachedSelector != null) {
            return cachedSelector;
        }
        Selector selectorCreated = Selector.createSelector((String)selectorString);
        this._reusableSelectorMap.put(selectorString, selectorCreated);
        return selectorCreated;
    }

    private Entry _createEntry(StyleContext context, StyleSheetDocument document, Map<String, String> shortStyleClassMap, String[] namespacePrefixes, boolean checkModified, boolean isDirty) {
        List<StyleNode> styleNodes = this._getStyleContextResolvedStyles(context, document);
        if (styleNodes.isEmpty()) {
            this._throwEmptyStyleNodes(context, document);
        }
        ConcurrentHashMap<Selector, Style> resolvedSelectorStyleMap = null;
        for (StyleNode styleNode : styleNodes) {
            String selectorString = styleNode.getSelector();
            if (selectorString == null) continue;
            Style style = this._convertStyleNodeToStyle(styleNode, this._reusableStyleMap);
            if (resolvedSelectorStyleMap == null) {
                resolvedSelectorStyleMap = new ConcurrentHashMap<Selector, Style>();
            }
            Selector selector = this._getSelector(selectorString);
            resolvedSelectorStyleMap.put(selector, style);
        }
        List<String> uris = this._createStyleSheetFiles(context, document, styleNodes, shortStyleClassMap, namespacePrefixes, checkModified, isDirty);
        _LOG.fine("Finished processing stylesheet {0}", uris);
        ConcurrentMap<String, Icon> icons = this._getStyleContextResolvedIcons(context, document);
        ConcurrentMap<Object, Object> skinProperties = this._getStyleContextResolvedSkinProperties(styleNodes);
        StylesImpl styles = new StylesImpl(namespacePrefixes, _STYLE_KEY_MAP, shortStyleClassMap, this._isCompressStyles(context), resolvedSelectorStyleMap);
        return new Entry(uris, styles, icons, skinProperties);
    }

    private void _throwEmptyStyleNodes(StyleContext context, StyleSheetDocument document) {
        String targetName = this.getTargetStyleSheetName(context, document);
        String message = _LOG.getMessage("STYLE_ENTRY_CREATION_FAILED_NO_STYLES", new Object[]{targetName});
        throw new IllegalStateException(message);
    }

    private Entry _getCompatibleEntry(ConcurrentMap<Key, Future<Entry>> cache, Key key, DerivationKey derivationKey, ConcurrentMap<Object, Entry> entryCache, boolean checkModified) {
        Entry entry = (Entry)entryCache.get(derivationKey);
        if (entry != null && !this._validateEntry(entry, checkModified)) {
            entryCache.remove(derivationKey, entry);
            entry = null;
        }
        if (entry != null) {
            cache.putIfAbsent(key, new ResolvedFuture<Entry>(entry));
        }
        return entry;
    }

    private DerivationKey _getDerivationKey(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleSheetNode> e = document.getStyleSheets(context);
        StyleSheetNode[] styleSheets = e.hasNext() ? (StyleSheetNode[])CollectionUtils.toArray(e, StyleSheetNode.class) : _EMPTY_STYLE_SHEET_NODE_ARRAY;
        return new DerivationKey(context, styleSheets);
    }

    private StyleSheetDocument _getStyleSheetDocument(StyleContext context) {
        StyleSheetDocument document = this._document;
        if (document != null) {
            return document;
        }
        document = this.createStyleSheetDocument(context);
        if (document == null) {
            document = _EMPTY_DOCUMENT;
        }
        if (this._document == null) {
            this._document = document;
        }
        this._namespacePrefixes = FileSystemStyleCache._getNamespacePrefixes(context, this._document);
        this._shortStyleClassMap = FileSystemStyleCache._getShortStyleClassMap(this._document, this._namespacePrefixes);
        return document;
    }

    private List<StyleNode> _getStyleContextResolvedStyles(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleNode> styleNodes = document.getStyles(context);
        if (styleNodes == null || !styleNodes.hasNext()) {
            if (_LOG.isWarning()) {
                _LOG.warning("NO_STYLES_FOUND_CONTEXT", (Object)context);
            }
            return Collections.emptyList();
        }
        return CollectionUtils.arrayList(styleNodes);
    }

    private ConcurrentMap<Object, Object> _getStyleContextResolvedSkinProperties(List<StyleNode> styleNodes) {
        ConcurrentHashMap<Object, Object> skinPropertiesMap = new ConcurrentHashMap<Object, Object>();
        StringBuilder keyBuilder = new StringBuilder();
        for (StyleNode styleNode : styleNodes) {
            if (styleNode.hasClientRule()) continue;
            Collection<PropertyNode> skinPropertyNodes = styleNode.getSkinProperties();
            for (PropertyNode node : skinPropertyNodes) {
                String value;
                Object propValueObj;
                String key;
                block8: {
                    String selectorName = styleNode.getSelector();
                    if (selectorName == null) {
                        keyBuilder.append('.').append(styleNode.getName()).append(":alias");
                    } else {
                        keyBuilder.append(selectorName);
                    }
                    String name = node.getName();
                    keyBuilder.append(name);
                    key = keyBuilder.toString();
                    keyBuilder.setLength(0);
                    Class<?> type = SkinProperties.PROPERTY_CLASS_TYPE_MAP.get(key);
                    propValueObj = null;
                    value = node.getValue();
                    if (type != null) {
                        try {
                            propValueObj = Coercions.coerce(null, value, type);
                        }
                        catch (IllegalArgumentException ex) {
                            if (!_LOG.isWarning()) break block8;
                            _LOG.warning((Throwable)ex);
                        }
                    }
                }
                if (propValueObj != null) {
                    skinPropertiesMap.put(key, propValueObj);
                    continue;
                }
                if (value == null) continue;
                skinPropertiesMap.put(key, value);
            }
        }
        return skinPropertiesMap;
    }

    private ConcurrentMap<String, Icon> _getStyleContextResolvedIcons(StyleContext context, StyleSheetDocument document) {
        Iterator<IconNode> iconNodeIterator = document.getIcons(context);
        ConcurrentHashMap<String, Icon> iconMap = new ConcurrentHashMap<String, Icon>();
        while (iconNodeIterator.hasNext()) {
            IconNode iconNode = iconNodeIterator.next();
            iconMap.put(iconNode.getIconName(), iconNode.getIcon());
        }
        return iconMap;
    }

    private List<String> _createStyleSheetFiles(StyleContext context, StyleSheetDocument document, List<StyleNode> styleNodes, Map<String, String> shortStyleClassMap, String[] namespacePrefixes, boolean checkModified, boolean isDirty) {
        File outputDir;
        List<File> outputFiles = this._getOutputFiles(context, document);
        if (!outputFiles.isEmpty()) {
            if (checkModified || isDirty) {
                if (!isDirty && checkModified && !this._checkSourceModified(document, outputFiles.get(0))) {
                    return this._getFileNames(outputFiles);
                }
                this._deleteAll(outputFiles);
            } else {
                return this._getFileNames(outputFiles);
            }
        }
        if (!(outputDir = new File(this._targetPath)).exists()) {
            outputDir.mkdirs();
        }
        RenderingContext arc = RenderingContext.getCurrentInstance();
        Skin skin = arc.getSkin();
        boolean compressStyles = this._isCompressStyles(context);
        StyleWriterFactoryImpl writerFactory = new StyleWriterFactoryImpl(this._targetPath, this.getTargetStyleSheetName(context, document));
        CSSGenerationUtils.writeCSS(context, skin.getStyleSheetName(), styleNodes, writerFactory, compressStyles, shortStyleClassMap, namespacePrefixes, _STYLE_KEY_MAP);
        return this._getFileNames(writerFactory.getFiles());
    }

    private File _getOutputFile(String name, int number) {
        assert (number >= 1);
        if (number == 1) {
            return new File(this._targetPath, name);
        }
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return new File(this._targetPath, name + number);
        }
        return new File(this._targetPath, new StringBuilder(name.length() + 2).append(name.substring(0, index)).append(number).append(name.substring(index)).toString());
    }

    private void _deleteAll(Iterable<File> files) {
        for (File file : files) {
            boolean success;
            if (!file.exists() || (success = file.delete()) || !_LOG.isInfo()) continue;
            _LOG.info("COULD_NOT_DELETE_FILE", (Object)file.getName());
        }
    }

    private boolean _isCompressStyles(StyleContext sContext) {
        return !sContext.isDisableStyleCompression();
    }

    private List<String> _getFileNames(List<File> files) {
        ArrayList<String> names = new ArrayList<String>(files.size());
        for (File file : files) {
            names.add(file.getName());
        }
        return Collections.unmodifiableList(names);
    }

    private List<File> _getOutputFiles(StyleContext context, StyleSheetDocument document) {
        File f;
        LinkedList<File> files = new LinkedList<File>();
        String name = this.getTargetStyleSheetName(context, document);
        int i = 1;
        while ((f = this._getOutputFile(name, i)).exists()) {
            files.add(f);
            ++i;
        }
        return files;
    }

    private PrintWriter _getWriter(File file) {
        PrintWriter out;
        block6: {
            out = null;
            try {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter writer = null;
                try {
                    writer = new OutputStreamWriter((OutputStream)fos, _UTF8_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    assert (false);
                    writer = new OutputStreamWriter(fos);
                }
                out = new PrintWriter(new BufferedWriter(writer));
            }
            catch (IOException e) {
                if (!_LOG.isInfo()) break block6;
                _LOG.info("IOEXCEPTION_OPENNING_FILE", (Object)file);
            }
        }
        return out;
    }

    private boolean _checkSourceModified(StyleSheetDocument document, File outputFile) {
        assert (outputFile != null);
        return document.getDocumentTimestamp() > outputFile.lastModified();
    }

    private static String[] _getNamespacePrefixes(StyleContext context, StyleSheetDocument document) {
        assert (document != null);
        Iterator<StyleSheetNode> styleSheets = document.getStyleSheets(context);
        assert (styleSheets != null);
        HashSet<String> namespacePrefixesSet = new HashSet<String>();
        while (styleSheets.hasNext()) {
            StyleSheetNode styleSheet = styleSheets.next();
            Collection<StyleNode> styles = styleSheet.getStyles();
            assert (styles != null);
            for (StyleNode style : styles) {
                String selector = style.getSelector();
                if (selector == null) continue;
                CSSGenerationUtils.getNamespacePrefixes(namespacePrefixesSet, selector);
            }
        }
        return namespacePrefixesSet.toArray(_EMPTY_STRING_ARRAY);
    }

    private static Map<String, String> _getShortStyleClassMap(StyleSheetDocument document, String[] namespacePrefixes) {
        HashMap<String, String> map = new HashMap<String, String>();
        assert (document != null);
        Iterator<StyleSheetNode> styleSheets = document.getStyleSheets();
        assert (styleSheets != null);
        HashSet<String> emptySelectors = new HashSet<String>();
        HashSet<String> nonEmptySelectors = new HashSet<String>(512);
        while (styleSheets.hasNext()) {
            StyleSheetNode styleSheet = styleSheets.next();
            Collection<StyleNode> styles = styleSheet.getStyles();
            assert (styles != null);
            for (StyleNode style : styles) {
                String selector = style.getSelector();
                if (selector == null) continue;
                if (CSSGenerationUtils.isSingleStyleClassSelector(selector)) {
                    String styleClass = selector.substring(1);
                    FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                    if (styleClass != null && !styleClass.startsWith("p_AF") && !map.containsKey(styleClass)) {
                        map.put(styleClass, FileSystemStyleCache._getShortStyleClass(map.size()));
                    }
                    if (style.isEmpty()) {
                        emptySelectors.add(styleClass);
                        continue;
                    }
                    nonEmptySelectors.add(styleClass);
                    continue;
                }
                Iterator<String> styleClasses = CSSGenerationUtils.getNonNamespacedStyleClasses(selector);
                if (styleClasses != null) {
                    while (styleClasses.hasNext()) {
                        String styleClass = styleClasses.next();
                        FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                        nonEmptySelectors.add(styleClass);
                    }
                }
                for (String nsPrefix : namespacePrefixes) {
                    Iterator<String> afSelectors = CSSGenerationUtils.getNamespacedSelectors(selector, nsPrefix, _STYLE_KEY_MAP);
                    if (afSelectors == null) continue;
                    boolean isFirst = true;
                    while (afSelectors.hasNext()) {
                        String styleClass = afSelectors.next();
                        FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                        if (isFirst && !afSelectors.hasNext() && style.isEmpty()) {
                            emptySelectors.add(styleClass);
                        } else {
                            nonEmptySelectors.add(styleClass);
                        }
                        isFirst = false;
                    }
                }
            }
        }
        emptySelectors.removeAll(nonEmptySelectors);
        for (String emptyKey : emptySelectors) {
            map.put(emptyKey, "");
        }
        return Collections.unmodifiableMap(map);
    }

    private static void _putStyleClassInShortMap(String styleClass, Map<String, String> map) {
        if (styleClass != null && !styleClass.startsWith("p_AF") && !map.containsKey(styleClass)) {
            String shortStyleClass = FileSystemStyleCache._getShortStyleClass(map.size());
            map.put(styleClass, shortStyleClass);
        }
    }

    private static String _getShortStyleClass(int count) {
        return _SHORT_CLASS_PREFIX + Integer.toString(count, 36);
    }

    private Map<String, String> _styleNodeToMap(StyleNode styleNode) {
        Collection<PropertyNode> propertyNodeList = styleNode.getProperties();
        int propertyCount = propertyNodeList.size();
        ArrayMap styleProperties = new ArrayMap(propertyCount);
        for (PropertyNode property : propertyNodeList) {
            String name = property.getName();
            String value = property.getValue();
            if (name == null || value == null) continue;
            styleProperties.put(name, value);
        }
        return styleProperties;
    }

    private UnmodifiableStyle _styleMapToUnmodifiableStyle(Map<String, String> styleProperties, Map<UnmodifiableStyle, UnmodifiableStyle> reusableStyleMap) {
        UnmodifiableStyle style = new UnmodifiableStyle(styleProperties);
        UnmodifiableStyle cachedStyle = reusableStyleMap.get((Object)style);
        if (cachedStyle != null) {
            return cachedStyle;
        }
        reusableStyleMap.put(style, style);
        return style;
    }

    private Style _convertStyleNodeToStyle(StyleNode styleNode, Map<UnmodifiableStyle, UnmodifiableStyle> reusableStyleMap) {
        Map<String, String> styleProperties = this._styleNodeToMap(styleNode);
        return this._styleMapToUnmodifiableStyle(styleProperties, reusableStyleMap);
    }

    static {
        _STYLE_KEY_MAP.put("af|body", "BODY");
        _STYLE_KEY_MAP.put("af|panelHeader::level-one", "H1.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-two", "H2.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-three", "H3.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-four", "H4.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-five", "H5.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-six", "H6.af|panelHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-one", "H1.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-two", "H2.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-three", "H3.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-four", "H4.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-five", "H5.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-six", "H6.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|menuTabs::selected-link", "af|menuTabs::selected A");
        _STYLE_KEY_MAP.put("af|menuTabs::enabled-link", "af|menuTabs::enabled A");
        _STYLE_KEY_MAP.put("af|menuBar::enabled-link", "af|menuBar::enabled A");
        _STYLE_KEY_MAP.put("af|menuBar::selected-link", "af|menuBar::selected A");
        _STYLE_KEY_MAP.put("OraLinkEnabledLink", "OraLinkEnabled A:link");
        _STYLE_KEY_MAP.put("OraLinkSelectedLink", "OraLinkSelected A:link");
        _STYLE_KEY_MAP.put("OraLinkEnabledActive", "OraLinkEnabled A:active");
        _STYLE_KEY_MAP.put("OraLinkSelectedActive", "OraLinkSelected A:active");
        _STYLE_KEY_MAP.put("OraLinkEnabledVisited", "OraLinkEnabled A:visited");
        _STYLE_KEY_MAP.put("OraLinkSelectedVisited", "OraLinkSelected A:visited");
        _STYLE_KEY_MAP.put("af|panelPage::about-link", "af|panelPage::about A");
        _STYLE_KEY_MAP.put("af|panelPage::copyright-link", "af|panelPage::copyright A");
        _STYLE_KEY_MAP.put("af|panelPage::privacy-link", "af|panelPage::privacy A");
        _STYLE_KEY_MAP.put("af|panelList::link", "af|panelList A");
        _STYLE_KEY_MAP.put("af|panelList::unordered-list", "af|panelList UL");
        _STYLE_KEY_MAP.put("af|inputDate::nav-link", "af|inputDate::nav A");
        _STYLE_KEY_MAP.put("af|inputDate::content-link", "af|inputDate::content A");
        _STYLE_KEY_MAP.put("af|inputDate::disabled-link", "af|inputDate::disabled A");
        _STYLE_KEY_MAP.put("af|chooseDate::nav-link", "af|chooseDate::nav A");
        _STYLE_KEY_MAP.put("af|chooseDate::content-link", "af|chooseDate::content A");
        _STYLE_KEY_MAP.put("af|showManyAccordion::title-link", "A.af|showManyAccordion::title-link");
        _STYLE_KEY_MAP.put("af|showManyAccordion::title-disabled-link", "A.af|showManyAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|showOneAccordion::title-link", "A.af|showOneAccordion::title-link");
        _STYLE_KEY_MAP.put("af|showOneAccordion::title-disabled-link", "A.af|showOneAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|panelAccordion::title-link", "A.af|panelAccordion::title-link");
        _STYLE_KEY_MAP.put("af|panelAccordion::title-disabled-link", "A.af|panelAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|panelTabbed::tab-link", "af|panelTabbed::tab A");
        _STYLE_KEY_MAP.put("af|panelTabbed::tab-selected-link", "af|panelTabbed::tab-selected A");
        _EMPTY_STYLE_SHEET_NODE_ARRAY = new StyleSheetNode[0];
        _EMPTY_STRING_ARRAY = new String[0];
    }

    private static final class ResolvedFuture<V>
    implements Future<V> {
        private final V _value;

        public ResolvedFuture(V value) {
            this._value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this._value;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private class StyleWriterFactoryImpl
    implements StyleWriterFactory {
        private final String _outputDirectory;
        private final String _baseFilename;
        private final List<File> _files = new LinkedList<File>();

        StyleWriterFactoryImpl(String outputDirectory, String baseName) {
            this._outputDirectory = outputDirectory;
            this._baseFilename = baseName;
        }

        List<File> getFiles() {
            return this._files;
        }

        @Override
        public PrintWriter createWriter() {
            File outputFile = FileSystemStyleCache.this._getOutputFile(this._baseFilename, this._files.size() + 1);
            outputFile.setReadOnly();
            this._files.add(outputFile);
            return FileSystemStyleCache.this._getWriter(outputFile);
        }
    }

    private static final class StylesImpl
    extends Styles {
        private final Map<Selector, Style> _unmodifiableResolvedSelectorStyleMap;
        private final Map<String, String> _afSelectorMap;
        private final String[] _namespacePrefixArray;
        private final Map<String, String> _shortStyleClassMap;
        private final boolean _compress;

        public StylesImpl(String[] namespacePrefixArray, Map<String, String> afSelectorMap, Map<String, String> shortStyleClassMap, boolean compress, Map<Selector, Style> resolvedSelectorStyleMap) {
            this._namespacePrefixArray = namespacePrefixArray;
            this._afSelectorMap = afSelectorMap;
            this._shortStyleClassMap = shortStyleClassMap;
            this._compress = compress;
            this._unmodifiableResolvedSelectorStyleMap = resolvedSelectorStyleMap != null ? Collections.unmodifiableMap(resolvedSelectorStyleMap) : Collections.emptyMap();
        }

        public Map<Selector, Style> getSelectorStyleMap() {
            return this._unmodifiableResolvedSelectorStyleMap;
        }

        public String getNativeSelectorString(Selector selector) {
            if (selector == null) {
                throw new IllegalArgumentException("selector cannot be null");
            }
            String mappedSelector = CSSGenerationUtils.getMappedSelector(this._afSelectorMap, this._namespacePrefixArray, selector.toString());
            if (this._compress) {
                mappedSelector = CSSGenerationUtils.getShortSelector(this._shortStyleClassMap, this._namespacePrefixArray, mappedSelector);
            }
            return CSSGenerationUtils.getValidFullNameSelector(mappedSelector, this._namespacePrefixArray);
        }
    }

    private static class DerivationKey {
        private boolean _noHash = false;
        private int _hashCode;
        private StyleSheetNode[] _styleSheets;
        private boolean _portlet;
        private boolean _short;
        private boolean _secureRequest;

        public DerivationKey(StyleContext context, StyleSheetNode[] styleSheets) {
            this._styleSheets = new StyleSheetNode[styleSheets.length];
            System.arraycopy(styleSheets, 0, this._styleSheets, 0, styleSheets.length);
            this._short = !context.isDisableStyleCompression();
            this._portlet = context.isPortletMode();
            this._secureRequest = context.isRequestSecure();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.hashCode() == this.hashCode() && o instanceof DerivationKey) {
                DerivationKey key = (DerivationKey)o;
                if (this._short != key._short || this._portlet != key._portlet || this._secureRequest != key._secureRequest || this._styleSheets.length != key._styleSheets.length) {
                    return false;
                }
                for (int i = this._styleSheets.length - 1; i >= 0; --i) {
                    if (this._styleSheets[i].equals(key._styleSheets[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this._noHash) {
                this._hashCode = Arrays.hashCode(this._styleSheets) ^ (this._short ? 1 : 0) ^ (this._portlet ? 1 : 0) ^ (this._secureRequest ? 1 : 0) << 3;
                this._noHash = false;
            }
            return this._hashCode;
        }
    }

    private static class Entry {
        public final List<String> uris;
        public final Styles styles;
        public final ConcurrentMap<String, Icon> icons;
        public final ConcurrentMap<Object, Object> skinProperties;

        public Entry(List<String> uris, Styles styles, ConcurrentMap<String, Icon> icons, ConcurrentMap<Object, Object> skinProperties) {
            this.uris = uris;
            this.styles = styles;
            this.icons = icons;
            this.skinProperties = skinProperties;
        }
    }

    private static class Key {
        private boolean _noHash = true;
        private int _hashCode;
        private Locale _locale;
        private int _direction;
        private TrinidadAgent.Application _browser;
        private String _version;
        private int _platform;
        private boolean _short;
        private AccessibilityProfile _accProfile;
        private boolean _portlet;
        private boolean _secureRequest;

        public Key(StyleContext context) {
            TrinidadAgent agent = context.getAgent();
            LocaleContext localeContext = context.getLocaleContext();
            AccessibilityProfile accProfile = context.getAccessibilityProfile();
            this._init(localeContext.getTranslationLocale(), LocaleUtils.getReadingDirection(localeContext), agent.getAgentApplication(), agent.getAgentVersion(), agent.getAgentOS(), !context.isDisableStyleCompression(), accProfile, context.isPortletMode(), context.isRequestSecure());
        }

        public int hashCode() {
            if (this._noHash) {
                this._hashCode = this._direction ^ this._browser.ordinal() << 2 ^ this._platform << 8 ^ (this._short ? 1 : 0) ^ (this._portlet ? 1 : 0) << 1 ^ (this._secureRequest ? 1 : 0) << 3;
                if (this._locale != null) {
                    this._hashCode ^= this._locale.hashCode();
                }
                if (this._accProfile != null) {
                    this._hashCode ^= this._accProfile.hashCode();
                }
                if (this._version != null) {
                    this._hashCode ^= this._version.hashCode();
                }
                this._noHash = false;
            }
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.hashCode() == this.hashCode() && o instanceof Key) {
                Key key = (Key)o;
                if (this._short == key._short && this._portlet == key._portlet && this._direction == key._direction && this._browser == key._browser && this._platform == key._platform && this._secureRequest == key._secureRequest && (this._version == null || this._version.equals(key._version)) && (this._locale == null || this._locale.equals(key._locale))) {
                    return this._accProfile == null || this._accProfile.equals((Object)key._accProfile);
                }
            }
            return false;
        }

        private void _init(Locale locale, int direction, TrinidadAgent.Application browser, String version, int platform, boolean useShort, AccessibilityProfile accessibilityProfile, boolean portlet, boolean secure) {
            this._locale = locale == null ? Locale.getDefault() : locale;
            this._direction = direction == 0 ? LocaleUtils.getReadingDirectionForLocale(this._locale) : direction;
            this._browser = browser;
            this._version = version;
            this._platform = platform;
            this._short = useShort;
            this._accProfile = accessibilityProfile;
            this._portlet = portlet;
            this._secureRequest = secure;
        }
    }

    protected static enum ClearOnDirty {
        ENTRIES,
        ALL;

    }
}

