/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.AddChildComponentChange;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.BaseChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.MoveChildComponentChange;
import org.apache.myfaces.trinidad.change.SetFacetChildComponentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.w3c.dom.Document;

public class SessionChangeManager
extends BaseChangeManager {
    private static final ChangesForView _EMPTY_CHANGES = new ChangesForView(false);
    private static final String _COMPONENT_CHANGES_MAP_FOR_SESSION_KEY = "org.apache.myfaces.trinidadinternal.ComponentChangesMapForSession";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SessionChangeManager.class);

    @Override
    public void applyComponentChangesForCurrentView(FacesContext context) {
        this._applyComponentChanges(context, null);
    }

    @Override
    public void applyComponentChangesForSubtree(FacesContext context, NamingContainer root) {
        String rootId = null;
        if (root != null) {
            if (!(root instanceof UIComponent)) {
                throw new IllegalArgumentException(_LOG.getMessage("INVALID_TYPE", root));
            }
            rootId = ComponentUtils.getScopedIdForComponent((UIComponent)root, (UIComponent)context.getViewRoot());
        }
        this._applyComponentChanges(context, rootId);
    }

    @Override
    public void applySimpleComponentChanges(FacesContext context, UIComponent component) {
        String sessionKey;
        ChangesForView changesForView;
        if (!this._isStateRestored(context) && (changesForView = this._getChangesForView(context, sessionKey = this._getSessionKey(context), false)) != null) {
            changesForView.applySimpleComponentChanges(context, component);
        }
    }

    @Override
    protected void addComponentChangeImpl(FacesContext context, UIComponent targetComponent, ComponentChange componentChange) {
        if (componentChange instanceof AttributeComponentChange) {
            this._replaceAttributeChange(context, targetComponent, (AttributeComponentChange)componentChange, false);
        } else {
            String sessionKey = this._getSessionKey(context);
            ChangesForView changesForView = this._getChangesForView(context, sessionKey, true);
            String scopedIdForTargetComponent = ComponentUtils.getScopedIdForComponent(targetComponent, (UIComponent)context.getViewRoot());
            String logicalScopedIdForTargetComponent = ComponentUtils.getLogicalScopedIdForComponent(targetComponent, (UIComponent)context.getViewRoot());
            this._insertComponentChange(changesForView, scopedIdForTargetComponent, logicalScopedIdForTargetComponent, componentChange);
            context.getExternalContext().getSessionMap().put(sessionKey, changesForView);
        }
    }

    @Override
    public AttributeComponentChange replaceAttributeChangeIfPresent(FacesContext context, UIComponent component, AttributeComponentChange attributeComponentChange) {
        return this._replaceAttributeChange(context, component, attributeComponentChange, true);
    }

    @Override
    protected Document getDocument(FacesContext context) {
        return null;
    }

    private AttributeComponentChange _replaceAttributeChange(FacesContext context, UIComponent component, AttributeComponentChange attributeComponentChange, boolean onlyIfPresent) {
        String scopedIdForTargetComponent = ComponentUtils.getScopedIdForComponent(component, (UIComponent)context.getViewRoot());
        String sessionKey = this._getSessionKey(context);
        ChangesForView changesForView = this._getChangesForView(context, sessionKey, true);
        AttributeComponentChange replaced = this._extractAttributeChange(changesForView, scopedIdForTargetComponent, attributeComponentChange);
        if (!onlyIfPresent || replaced != null) {
            String logicalScopedIdForTargetComponent = ComponentUtils.getLogicalScopedIdForComponent(component, (UIComponent)context.getViewRoot());
            this._insertComponentChange(changesForView, scopedIdForTargetComponent, logicalScopedIdForTargetComponent, attributeComponentChange);
            context.getExternalContext().getSessionMap().put(sessionKey, changesForView);
        }
        return replaced;
    }

    private AttributeComponentChange _extractAttributeChange(ChangesForView changesForView, String scopedIdForTargetComponent, AttributeComponentChange attributeChange) {
        String currTargetScopedId;
        MoveChildComponentChange nextRenameChange;
        AttributeComponentChange extracted = null;
        String attributeName = attributeChange.getAttributeName();
        Iterator<QualifiedComponentChange> changes = changesForView.getComponentChangesForView().iterator();
        Iterator<MoveChildComponentChange> renameChanges = changesForView.getRenameChanges(scopedIdForTargetComponent);
        if (renameChanges.hasNext()) {
            nextRenameChange = renameChanges.next();
            currTargetScopedId = nextRenameChange.getSourceScopedId();
        } else {
            nextRenameChange = null;
            currTargetScopedId = scopedIdForTargetComponent;
        }
        while (changes.hasNext()) {
            AttributeComponentChange currAttributeChange;
            ComponentChange currChange;
            QualifiedComponentChange currQualifiedChange = changes.next();
            if (currQualifiedChange.getComponentChange() == nextRenameChange) {
                currTargetScopedId = nextRenameChange.getDestinationScopedId();
                nextRenameChange = renameChanges.hasNext() ? renameChanges.next() : null;
                continue;
            }
            if (!currQualifiedChange.getTargetComponentScopedId().equals(currTargetScopedId) || !((currChange = currQualifiedChange.getComponentChange()) instanceof AttributeComponentChange) || !attributeName.equals((currAttributeChange = (AttributeComponentChange)currChange).getAttributeName())) continue;
            changes.remove();
            extracted = currAttributeChange;
            break;
        }
        return extracted;
    }

    private void _insertComponentChange(ChangesForView changesForView, String scopedIdForTargetComponent, String logicalScopedIdForTargetComponent, ComponentChange componentChange) {
        QualifiedComponentChange newQualifiedChange = new QualifiedComponentChange(scopedIdForTargetComponent, logicalScopedIdForTargetComponent, componentChange);
        changesForView.addChange(newQualifiedChange);
    }

    private void _applyComponentChanges(FacesContext context, String rootId) {
        ChangesForView changesForView = this._getReadOnlyChangesForView(context);
        UIViewRoot viewRoot = context.getViewRoot();
        boolean isStateRestored = this._isStateRestored(context);
        HashSet<String> attributeForcedComponents = new HashSet<String>();
        for (QualifiedComponentChange qualifiedChange : changesForView.getComponentChangesForView()) {
            String addedComponentId;
            UIComponent addedComponent;
            ComponentChange componentChange = qualifiedChange.getComponentChange();
            String targetComponentScopedId = qualifiedChange.getTargetComponentScopedId();
            if (isStateRestored && componentChange instanceof AttributeComponentChange && !attributeForcedComponents.contains(targetComponentScopedId) || !this._acceptChange(qualifiedChange, rootId)) continue;
            UIComponent targetComponent = viewRoot.findComponent(targetComponentScopedId);
            if (targetComponent == null) {
                _LOG.info(this.getClass().getName(), "applyComponentChangesForCurrentView", "TARGET_COMPONENT_MISSING_CHANGE_FAILED", targetComponentScopedId);
                continue;
            }
            componentChange.changeComponent(targetComponent);
            if (componentChange instanceof MoveChildComponentChange) {
                String destinationScopedId = ((MoveChildComponentChange)componentChange).getDestinationScopedId();
                attributeForcedComponents.remove(targetComponentScopedId);
                attributeForcedComponents.add(destinationScopedId);
                continue;
            }
            if (componentChange instanceof SetFacetChildComponentChange) {
                String facetName = ((SetFacetChildComponentChange)componentChange).getFacetName();
                UIComponent facetComponent = targetComponent.getFacet(facetName);
                if (facetComponent == null) continue;
                String facetScopedId = ComponentUtils.getScopedIdForComponent(facetComponent, (UIComponent)viewRoot);
                attributeForcedComponents.add(facetScopedId);
                continue;
            }
            if (!(componentChange instanceof AddChildComponentChange) || (addedComponent = ComponentUtils.findRelativeComponent(targetComponent, addedComponentId = ((AddChildComponentChange)componentChange).getComponent().getId())) == null) continue;
            String addedChildComponentScopedId = ComponentUtils.getScopedIdForComponent(addedComponent, (UIComponent)viewRoot);
            attributeForcedComponents.add(addedChildComponentScopedId);
        }
    }

    private boolean _isStateRestored(FacesContext facesContext) {
        return false;
    }

    private boolean _acceptChange(QualifiedComponentChange qualifiedChange, String rootId) {
        if (rootId != null) {
            String id = qualifiedChange.getTargetComponentScopedId();
            return id.startsWith(rootId) && id.length() != rootId.length();
        }
        return true;
    }

    private ChangesForView _getReadOnlyChangesForView(FacesContext context) {
        String sessionKey = this._getSessionKey(context);
        return this._getChangesForView(context, sessionKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangesForView _getChangesForView(FacesContext context, String sessionKey, boolean createIfNecessary) {
        ExternalContext extContext = context.getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        Object changes = sessionMap.get(sessionKey);
        if (changes == null) {
            if (createIfNecessary) {
                Object session;
                Object object = session = extContext.getSession(true);
                synchronized (object) {
                    changes = sessionMap.get(sessionKey);
                    if (changes == null) {
                        ChangesForView changesForView = new ChangesForView(true);
                        sessionMap.put(sessionKey, changesForView);
                        return changesForView;
                    }
                    return (ChangesForView)changes;
                }
            }
            return _EMPTY_CHANGES;
        }
        return (ChangesForView)changes;
    }

    private String _getSessionKey(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        StringBuilder builder = new StringBuilder(viewId.length() + _COMPONENT_CHANGES_MAP_FOR_SESSION_KEY.length());
        return builder.append(_COMPONENT_CHANGES_MAP_FOR_SESSION_KEY).append(viewId).toString();
    }

    private static class QualifiedComponentChange
    implements Serializable {
        private final String _targetComponentScopedId;
        private final String _targetComponentLogicalScopedId;
        private final ComponentChange _componentChange;
        private static final long serialVersionUID = 1L;

        public QualifiedComponentChange(String targetComponentScopedId, String targetComponentLogicalScopedId, ComponentChange componentChange) {
            if (targetComponentScopedId == null || componentChange == null) {
                throw new IllegalArgumentException("Target component scoped id and component change is required");
            }
            this._targetComponentScopedId = targetComponentScopedId;
            this._targetComponentLogicalScopedId = targetComponentScopedId.equals(targetComponentLogicalScopedId) ? null : targetComponentLogicalScopedId;
            this._componentChange = componentChange;
        }

        public String getTargetComponentScopedId() {
            return this._targetComponentScopedId;
        }

        public String getTargetComponentLogicalScopedId() {
            return this._targetComponentLogicalScopedId != null ? this._targetComponentLogicalScopedId : this._targetComponentScopedId;
        }

        public ComponentChange getComponentChange() {
            return this._componentChange;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedComponentChange)) {
                return false;
            }
            QualifiedComponentChange other = (QualifiedComponentChange)o;
            return this.getTargetComponentLogicalScopedId().equals(other.getTargetComponentLogicalScopedId()) && this._componentChange.equals(other._componentChange);
        }

        public int hashCode() {
            return this.getTargetComponentLogicalScopedId().hashCode() + 37 * this._componentChange.hashCode();
        }

        public String toString() {
            return super.toString() + "[target=" + this._targetComponentScopedId + " logical_target=" + this.getTargetComponentLogicalScopedId() + " change=" + this._componentChange + "]";
        }
    }

    private static final class ChangesForView
    implements Serializable {
        private final Queue<QualifiedComponentChange> _componentChangesForView;
        private final List<MoveChildComponentChange> _renameChanges;
        private final ConcurrentMap<String, ConcurrentMap<String, ComponentChange>> _attrChanges = new ConcurrentHashMap<String, ConcurrentMap<String, ComponentChange>>();
        private final ConcurrentMap<String, String> _renameMap = new ConcurrentHashMap<String, String>();
        private static final long serialVersionUID = 1L;

        protected ChangesForView(boolean rw) {
            if (rw) {
                this._componentChangesForView = new ConcurrentLinkedQueue<QualifiedComponentChange>();
                this._renameChanges = new CopyOnWriteArrayList<MoveChildComponentChange>();
            } else {
                this._componentChangesForView = CollectionUtils.emptyQueue();
                this._renameChanges = Collections.emptyList();
            }
        }

        public String toString() {
            return super.toString() + "[componentChange=" + this._componentChangesForView + " renameChanges=" + this._renameChanges + "]";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangesForView)) {
                return false;
            }
            ChangesForView other = (ChangesForView)o;
            return this._componentChangesForView.equals(other._componentChangesForView) && this._renameChanges.equals(other._renameChanges);
        }

        public int hashCode() {
            return this._componentChangesForView.hashCode() + 37 * this._renameChanges.hashCode();
        }

        protected Iterable<QualifiedComponentChange> getComponentChangesForView() {
            return this._componentChangesForView;
        }

        protected void addChange(QualifiedComponentChange qualifiedChange) {
            MoveChildComponentChange moveComponentChange;
            this._componentChangesForView.add(qualifiedChange);
            ComponentChange componentChange = qualifiedChange.getComponentChange();
            if (componentChange instanceof AttributeComponentChange) {
                this._updateAttributeChange(this._attrChanges, this._renameMap, qualifiedChange);
            } else if (componentChange instanceof MoveChildComponentChange && !(moveComponentChange = (MoveChildComponentChange)componentChange).getSourceScopedId().equals(moveComponentChange.getDestinationScopedId())) {
                this._renameChanges.add(moveComponentChange);
                this._updateRenameMap(this._renameMap, moveComponentChange);
            }
        }

        protected Iterator<MoveChildComponentChange> getRenameChanges(String targetScopedId) {
            if (!this._renameChanges.isEmpty()) {
                String currTargetScopedId = targetScopedId;
                ArrayList<MoveChildComponentChange> renameChanges = null;
                ListIterator<MoveChildComponentChange> moveChanges = this._renameChanges.listIterator(this._renameChanges.size());
                while (moveChanges.hasPrevious()) {
                    MoveChildComponentChange currMoveChange = moveChanges.previous();
                    if (!currTargetScopedId.equals(currMoveChange.getDestinationScopedId())) continue;
                    if (renameChanges == null) {
                        renameChanges = new ArrayList<MoveChildComponentChange>();
                    }
                    renameChanges.add(currMoveChange);
                    currTargetScopedId = currMoveChange.getSourceScopedId();
                }
                if (renameChanges != null) {
                    if (renameChanges.size() > 1) {
                        Collections.reverse(renameChanges);
                    }
                    return renameChanges.iterator();
                }
            }
            return CollectionUtils.emptyIterator();
        }

        protected void applySimpleComponentChanges(FacesContext context, UIComponent component) {
            String scopedId = ComponentUtils.getLogicalScopedIdForComponent(component, (UIComponent)context.getViewRoot());
            ConcurrentMap componentChanges = (ConcurrentMap)this._attrChanges.get(scopedId);
            if (componentChanges != null) {
                for (ComponentChange change : componentChanges.values()) {
                    change.changeComponent(component);
                }
            }
        }

        private void _updateAttributeChange(ConcurrentMap<String, ConcurrentMap<String, ComponentChange>> attrChanges, ConcurrentMap<String, String> renameMap, QualifiedComponentChange qAttrChange) {
            ConcurrentHashMap<String, AttributeComponentChange> changesForComponent;
            String currScopedId = qAttrChange.getTargetComponentLogicalScopedId();
            String originalScopedId = (String)renameMap.get(currScopedId);
            if (originalScopedId == null) {
                originalScopedId = currScopedId;
            }
            if ((changesForComponent = (ConcurrentHashMap<String, AttributeComponentChange>)attrChanges.get(originalScopedId)) == null) {
                changesForComponent = new ConcurrentHashMap<String, AttributeComponentChange>();
                attrChanges.put(originalScopedId, changesForComponent);
            }
            AttributeComponentChange attrChange = (AttributeComponentChange)qAttrChange.getComponentChange();
            String attrName = attrChange.getAttributeName();
            changesForComponent.put(attrName, attrChange);
        }

        private void _updateRenameMap(ConcurrentMap<String, String> renameMap, MoveChildComponentChange moveChange) {
            String destinationScopedId;
            String sourceScopedId = moveChange.getSourceLogicalScopedId();
            if (!sourceScopedId.equals(destinationScopedId = moveChange.getDestinationLogicalScopedId())) {
                String originalScodeId = (String)renameMap.remove(sourceScopedId);
                if (originalScodeId == null) {
                    originalScodeId = sourceScopedId;
                }
                renameMap.put(destinationScopedId, originalScodeId);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("proxy required");
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private static class SerializationProxy
        implements Serializable {
            private final List<QualifiedComponentChange> _componentChangesForView;
            private final boolean _rw;
            private static final long serialVersionUID = 1L;

            SerializationProxy(ChangesForView changesForView) {
                this._componentChangesForView = new ArrayList<QualifiedComponentChange>(changesForView._componentChangesForView);
                this._rw = changesForView._renameChanges != Collections.EMPTY_LIST;
            }

            private Object readResolve() {
                ChangesForView changesForView = new ChangesForView(this._rw);
                for (QualifiedComponentChange qualifiedChange : this._componentChangesForView) {
                    changesForView.addChange(qualifiedChange);
                }
                return changesForView;
            }
        }
    }
}

