/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.simple.desktop;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.CoreSkinUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.simple.desktop.SimpleDesktopConstants;

@Deprecated
public class MessageBoxRenderer
extends org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.MessageBoxRenderer
implements SimpleDesktopConstants {
    private static final Object _ICONS_KEY = new Object();

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "table";
    }

    @Override
    protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
        super.renderAttributes(context, node);
        MessageBoxRenderer.renderLayoutTableAttributes(context, "0", "100%");
    }

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        super.prerender(context, node);
        IconData icons = this._getIconData(context);
        int columnCount = this._getColumnCount(icons);
        FacesContext fContext = context.getFacesContext();
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (this._hasTopRow(icons)) {
            this._renderTopRow(fContext, arc, icons, columnCount);
        }
        this._startContentsRow(context, fContext, arc, icons, columnCount);
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        IconData icons = this._getIconData(context);
        int columnCount = this._getColumnCount(icons);
        FacesContext fContext = context.getFacesContext();
        RenderingContext arc = RenderingContext.getCurrentInstance();
        this._endContentsRow(fContext, arc, icons);
        if (this._hasBottomRow(icons)) {
            this._renderBottomRow(fContext, arc, icons, columnCount);
        }
        super.postrender(context, node);
    }

    private void _startContentsRow(UIXRenderingContext context, FacesContext fContext, RenderingContext arc, IconData icons, int columnCount) throws IOException {
        ResponseWriter writer = fContext.getResponseWriter();
        writer.startElement("tr", null);
        if (icons.startBackground != null) {
            writer.startElement("td", null);
            CoreSkinUtils.__renderBackgroundIcon(fContext, arc, icons.startBackground);
            writer.endElement("td");
        }
        writer.startElement("td", null);
        MessageBoxRenderer.renderStyleClassAttribute(context, "af|messages::body");
        Integer bodyColumnCount = MessageBoxRenderer._getBodyColumnCount(icons, columnCount);
        writer.writeAttribute("colspan", (Object)bodyColumnCount, null);
    }

    private void _endContentsRow(FacesContext fContext, RenderingContext arc, IconData icons) throws IOException {
        ResponseWriter writer = fContext.getResponseWriter();
        writer.endElement("td");
        if (icons.endBackground != null) {
            writer.startElement("td", null);
            CoreSkinUtils.__renderBackgroundIcon(fContext, arc, icons.endBackground);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private boolean _hasBottomRow(IconData icons) {
        return icons.bottomStart != null || icons.bottomEnd != null;
    }

    private void _renderBottomRow(FacesContext fContext, RenderingContext arc, IconData icons, int columnCount) throws IOException {
        ResponseWriter writer = fContext.getResponseWriter();
        writer.startElement("tr", null);
        if (icons.bottomStart != null) {
            writer.startElement("td", null);
            OutputUtils.renderIcon(fContext, arc, icons.bottomStart, "", null);
            writer.endElement("td");
        }
        Integer colspan = MessageBoxRenderer._getBottomBackgroundColumnCount(icons, columnCount);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)colspan, null);
        writer.writeAttribute("width", (Object)"100%", null);
        CoreSkinUtils.__renderBackgroundIcon(fContext, arc, icons.bottomBackground);
        writer.endElement("td");
        if (icons.bottomEnd != null) {
            writer.startElement("td", null);
            OutputUtils.renderIcon(fContext, arc, icons.bottomEnd, "", null);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private boolean _hasTopRow(IconData icons) {
        return icons.topStart != null || icons.topEnd != null;
    }

    private void _renderTopRow(FacesContext fContext, RenderingContext arc, IconData icons, int columnCount) throws IOException {
        ResponseWriter writer = fContext.getResponseWriter();
        writer.startElement("tr", null);
        if (icons.topStart != null) {
            writer.startElement("td", null);
            OutputUtils.renderIcon(fContext, arc, icons.topStart, "", null);
            writer.endElement("td");
        }
        Integer colspan = MessageBoxRenderer._getTopBackgroundColumnCount(icons, columnCount);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)colspan, null);
        writer.writeAttribute("width", (Object)"100%", null);
        CoreSkinUtils.__renderBackgroundIcon(fContext, arc, icons.topBackground);
        writer.endElement("td");
        if (icons.topEnd != null) {
            writer.startElement("td", null);
            OutputUtils.renderIcon(fContext, arc, icons.topEnd, "", null);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private int _getColumnCount(IconData icons) {
        int columnCount = 1;
        if (icons.bottomStart != null || icons.topStart != null || icons.startBackground != null) {
            ++columnCount;
        }
        if (icons.bottomEnd != null || icons.bottomEnd != null || icons.endBackground != null) {
            ++columnCount;
        }
        return columnCount;
    }

    private static Integer _getBodyColumnCount(IconData icons, int columnCount) {
        int bodyColumnCount = columnCount;
        if (icons.startBackground != null) {
            --bodyColumnCount;
        }
        if (icons.endBackground != null) {
            --bodyColumnCount;
        }
        if (bodyColumnCount == 1) {
            return null;
        }
        return bodyColumnCount;
    }

    private static Integer _getBottomBackgroundColumnCount(IconData icons, int columnCount) {
        int backgroundColumnCount = columnCount;
        if (icons.bottomStart != null) {
            --backgroundColumnCount;
        }
        if (icons.bottomEnd != null) {
            --backgroundColumnCount;
        }
        if (backgroundColumnCount == 1) {
            return null;
        }
        return backgroundColumnCount;
    }

    private static Integer _getTopBackgroundColumnCount(IconData icons, int columnCount) {
        int backgroundColumnCount = columnCount;
        if (icons.topStart != null) {
            --backgroundColumnCount;
        }
        if (icons.topEnd != null) {
            --backgroundColumnCount;
        }
        if (backgroundColumnCount == 1) {
            return null;
        }
        return backgroundColumnCount;
    }

    private IconData _getIconData(UIXRenderingContext context) {
        Skin skin = context.getSkin();
        IconData icons = (IconData)skin.getProperty(_ICONS_KEY);
        Icon bottomStart = context.getIcon("af|messages::bottom-start-icon");
        if (icons == null || bottomStart == null || !icons.bottomStart.equals(bottomStart)) {
            Icon bottomEnd = context.getIcon("af|messages::bottom-end-icon");
            Icon bottomBackground = context.getIcon("af|messages::bottom-background-icon");
            Icon topStart = context.getIcon("af|messages::top-start-icon");
            Icon topEnd = context.getIcon("af|messages::top-end-icon");
            Icon topBackground = context.getIcon("af|messages::top-background-icon");
            Icon startBackground = context.getIcon("af|messages::start-background-icon");
            Icon endBackground = context.getIcon("af|messages::end-background-icon");
            icons = new IconData(bottomStart, bottomEnd, bottomBackground, topStart, topEnd, topBackground, startBackground, endBackground);
            skin.setProperty(_ICONS_KEY, (Object)icons);
        }
        return icons;
    }

    private static class IconData {
        public final Icon bottomStart;
        public final Icon bottomEnd;
        public final Icon bottomBackground;
        public final Icon topStart;
        public final Icon topEnd;
        public final Icon topBackground;
        public final Icon startBackground;
        public final Icon endBackground;

        public IconData(Icon bottomStart, Icon bottomEnd, Icon bottomBackground, Icon topStart, Icon topEnd, Icon topBackground, Icon startBackground, Icon endBackground) {
            this.bottomStart = bottomStart;
            this.bottomEnd = bottomEnd;
            this.bottomBackground = bottomBackground;
            this.topStart = topStart;
            this.topEnd = topEnd;
            this.topBackground = topBackground;
            this.startBackground = startBackground;
            this.endBackground = endBackground;
        }
    }
}

