/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.JaxpXMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextWrapper;
import org.apache.myfaces.trinidadinternal.share.xml.ParseErrorUtils;
import org.apache.myfaces.trinidadinternal.share.xml.ParserExtension;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TreeBuilder {
    final Class<?> _rootClass;
    private EntityResolver _entityResolver;
    private final ParserManager _manager;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeBuilder.class);

    public TreeBuilder() {
        this(null, null);
    }

    public TreeBuilder(ParserManager manager, Class<?> rootClass) {
        this._manager = manager == null ? new ParserManager() : (ParserManager)manager.clone();
        this._rootClass = rootClass;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public Object parse(XMLProvider provider, InputSource source) throws IOException, SAXException {
        ParseContextImpl context = new ParseContextImpl();
        return this.parse(provider, source, context);
    }

    public Object parse(XMLProvider provider, InputSource source, ParseContext context) throws IOException, SAXException {
        return this.parse(provider, source, context, null);
    }

    public Object parse(InputSource source, NodeParser rootParser) throws IOException, SAXException {
        return this.parse(null, source, new ParseContextImpl(), rootParser);
    }

    public Object parse(XMLProvider provider, InputSource source, ParseContext context, NodeParser rootParser) throws IOException, SAXException {
        if (this._rootClass == null && rootParser == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_ROOTCLASS_ROOTPARSER"));
        }
        if (provider == null) {
            provider = new JaxpXMLProvider();
        }
        ParseContextWrapper wrappedContext = new ParseContextWrapper(context, this._manager, provider);
        Handler handler = new Handler(wrappedContext, rootParser);
        XMLReader reader = provider.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        if (this.getEntityResolver() != null) {
            reader.setEntityResolver(this.getEntityResolver());
        }
        reader.parse(source);
        return handler.getRoot();
    }

    private static class StackEntry {
        private NodeParser _parser;
        private boolean _isExtension;
        private Object[] _dictionaries;

        public StackEntry(NodeParser parser, boolean isExtension) {
            this._parser = parser;
            this._isExtension = isExtension;
        }

        public NodeParser getParser() {
            return this._parser;
        }

        public boolean isExtension() {
            return this._isExtension;
        }

        public int getMapCount() {
            if (this._dictionaries == null) {
                return 0;
            }
            return this._dictionaries.length / 2;
        }

        public String getMapNamespace(int index) {
            return (String)this._dictionaries[index * 2];
        }

        public Map<Object, Object> getMap(int index) {
            return (Map)this._dictionaries[index * 2 + 1];
        }

        public void put(String namespace, Object key, Object value) {
            Map subDict = (Map)ArrayMap.get((Object[])this._dictionaries, (Object)namespace);
            if (subDict == null) {
                subDict = new ArrayMap(5, 5);
                this._dictionaries = ArrayMap.put((Object[])this._dictionaries, (Object)namespace, (Object)subDict);
            }
            subDict.put(key, value);
        }
    }

    private class Handler
    implements ContentHandler,
    ErrorHandler {
        private ParseContextWrapper _context;
        private Stack<StackEntry> _parsers;
        private NodeParser _current;
        private Object _root;
        private boolean _fatalError;
        private final NodeParser _rootParser;

        public Handler(ParseContextWrapper context, NodeParser rootParser) {
            this._context = context;
            this._parsers = new Stack();
            this._rootParser = rootParser;
        }

        public Object getRoot() {
            if (!this._parsers.isEmpty()) {
                throw new IllegalStateException();
            }
            return this._root;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this._context.__addPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void startDocument() {
            this._parsers.setSize(0);
            this._root = null;
        }

        @Override
        public void endDocument() {
            assert (this._parsers.isEmpty());
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            this._context.__startElement();
            NodeParser parser = this._getCurrentParser();
            if (parser == null) {
                parser = this._rootParser != null ? this._rootParser : this._context.getParser(TreeBuilder.this._rootClass, namespaceURI, localName);
                if (parser == null) {
                    String message = "No " + TreeBuilder.this._rootClass.getName() + " parser registered for top element;" + "check your namespace declaration." + "   Namespace: " + namespaceURI + "\n" + "   Local name: " + localName + ")";
                    SAXParseException e = new SAXParseException(message, this._context.getLocator());
                    this.fatalError(e);
                    throw e;
                }
                this._pushParser(parser, false);
            } else {
                NodeParser newParser;
                try {
                    newParser = parser.startChildElement(this._context, namespaceURI, localName, atts);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
                if (newParser == parser) {
                    this._pushParser(null, false);
                    return;
                }
                boolean isExtension = false;
                if (newParser == null) {
                    newParser = this._processElementExtensions(namespaceURI, localName, atts);
                    if (newParser != null) {
                        isExtension = true;
                    } else {
                        ParseErrorUtils.log(this._context, "<" + localName + ">" + " is not an understood element.\n" + "This sometimes means the element's " + "namespace (" + namespaceURI + ") is set " + "incorrectly.  This may also be an " + "issue with the syntax of its parent " + "element.", null, Level.WARNING, _LOG);
                        newParser = BaseNodeParser.getIgnoreParser();
                    }
                }
                this._pushParser(newParser, isExtension);
                parser = newParser;
            }
            try {
                this._processAttributeExtensions(namespaceURI, localName, atts);
                parser.startElement(this._context, namespaceURI, localName, atts);
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        private NodeParser _processElementExtensions(String namespaceURI, String localName, Attributes atts) throws SAXParseException {
            ParserExtension extension = this._context.getExtension(namespaceURI);
            if (extension != null) {
                return extension.startExtensionElement(this._context, namespaceURI, localName, atts);
            }
            return null;
        }

        private void _processAttributeExtensions(String elementNamespaceURI, String elementLocalName, Attributes atts) throws SAXParseException {
            StackEntry entry = null;
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                ParserExtension extension;
                String namespaceURI = atts.getURI(i);
                if (namespaceURI == null || namespaceURI.length() == 0 || (extension = this._context.getExtension(namespaceURI)) == null) continue;
                String localName = atts.getLocalName(i);
                String value = atts.getValue(i);
                if (value == null) continue;
                if (entry == null) {
                    entry = this._getLastNonNullStackEntry();
                }
                entry.put(namespaceURI, localName, value);
            }
            if (entry != null) {
                int count = entry.getMapCount();
                for (int i = 0; i < count; ++i) {
                    String namespaceURI = entry.getMapNamespace(i);
                    ParserExtension extension = this._context.getExtension(namespaceURI);
                    assert (extension != null);
                    extension.elementStarted(this._context, elementNamespaceURI, elementLocalName, entry.getMap(i));
                }
            }
        }

        private Object _finishExtensions(String elementNamespaceURI, String elementLocalName, StackEntry entry, Object child) throws SAXParseException {
            int count = entry.getMapCount();
            for (int i = 0; i < count; ++i) {
                String namespaceURI = entry.getMapNamespace(i);
                ParserExtension extension = this._context.getExtension(namespaceURI);
                assert (extension != null);
                child = extension.elementEnded(this._context, elementNamespaceURI, elementLocalName, child, entry.getMap(i));
            }
            return child;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            NodeParser oldParser;
            boolean isExtension;
            StackEntry oldEntry = this._popParser();
            if (oldEntry != null) {
                isExtension = oldEntry.isExtension();
                oldParser = oldEntry.getParser();
            } else {
                isExtension = false;
                oldParser = null;
            }
            NodeParser parser = this._getCurrentParser();
            if (oldParser != null) {
                Object child;
                try {
                    child = oldParser.endElement(this._context, namespaceURI, localName);
                    child = this._finishExtensions(namespaceURI, localName, oldEntry, child);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
                if (parser == null) {
                    assert (this._parsers.isEmpty());
                    this._root = child;
                } else {
                    try {
                        if (isExtension) {
                            StackEntry currentEntry = this._getLastNonNullStackEntry();
                            currentEntry.put(namespaceURI, localName, child);
                        } else {
                            parser.addCompletedChild(this._context, namespaceURI, localName, child);
                        }
                    }
                    catch (SAXParseException e) {
                        this.fatalError(e);
                        throw e;
                    }
                }
            }
            if (parser != null && oldParser == null) {
                try {
                    parser.endChildElement(this._context, namespaceURI, localName);
                }
                catch (SAXParseException e) {
                    this.fatalError(e);
                    throw e;
                }
            }
            this._context.__endElement();
        }

        @Override
        public void characters(char[] text, int start, int length) throws SAXException {
            try {
                NodeParser parser = this._getCurrentParser();
                if (parser != null) {
                    int savedStart = start;
                    int end = start + length - 1;
                    while (start <= end && Character.isWhitespace(text[start])) {
                        ++start;
                    }
                    if (start != savedStart) {
                        parser.addWhitespace(this._context, text, savedStart, start - savedStart);
                    }
                    int savedEnd = end;
                    while (end > start + 1 && Character.isWhitespace(text[end])) {
                        --end;
                    }
                    if (end >= start) {
                        parser.addText(this._context, text, start, end - start + 1);
                        if (savedEnd != end) {
                            parser.addWhitespace(this._context, text, end + 1, savedEnd - end);
                        }
                    }
                }
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._context.__setLocator(locator);
        }

        @Override
        public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
            try {
                NodeParser parser = this._getCurrentParser();
                if (parser != null) {
                    parser.addWhitespace(this._context, text, start, length);
                }
            }
            catch (SAXParseException e) {
                this.fatalError(e);
                throw e;
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this._logError(exception, Level.INFO);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this._logError(exception, Level.WARNING);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (!this._fatalError) {
                this._fatalError = true;
                this._logError(exception, Level.SEVERE);
            }
        }

        private void _logError(SAXParseException exception, Level verbosity) {
            ParseErrorUtils.log(this._context, null, exception, exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId(), verbosity, _LOG);
        }

        private void _pushParser(NodeParser parser, boolean isExtension) {
            if (parser == null) {
                this._parsers.push(null);
            } else {
                this._parsers.push(new StackEntry(parser, isExtension));
                this._current = parser;
            }
            assert (this._current == this._getLastNonNullParser());
        }

        private StackEntry _popParser() {
            StackEntry entry = this._parsers.pop();
            if (entry != null) {
                this._current = this._getLastNonNullParser();
                return entry;
            }
            return null;
        }

        private NodeParser _getCurrentParser() {
            assert (this._current == this._getLastNonNullParser());
            return this._current;
        }

        private StackEntry _getLastNonNullStackEntry() {
            for (int i = this._parsers.size() - 1; i >= 0; --i) {
                Object entry = this._parsers.elementAt(i);
                if (entry == null) continue;
                return (StackEntry)entry;
            }
            return null;
        }

        private NodeParser _getLastNonNullParser() {
            StackEntry entry = this._getLastNonNullStackEntry();
            if (entry != null) {
                return entry.getParser();
            }
            return null;
        }
    }
}

